/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.component;

import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.component.ComponentPropertyListWidget;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

public abstract class ComponentBuilderPopup<T extends IMachineComponentTemplate<?>>
extends PopupScreen {
    public static final Component CONFIRM = Component.m_237115_((String)"custommachinery.gui.popup.confirm").m_130940_(ChatFormatting.GREEN);
    public static final Component CANCEL = Component.m_237115_((String)"custommachinery.gui.popup.cancel").m_130940_(ChatFormatting.RED);
    @Nullable
    private final T baseTemplate;
    private final Consumer<T> onFinish;
    private final Component title;
    public ComponentPropertyListWidget propertyList;

    public ComponentBuilderPopup(BaseScreen parent, @Nullable T template, Consumer<T> onFinish, Component title) {
        super(parent, 256, 196);
        this.onFinish = onFinish;
        this.baseTemplate = template;
        this.title = title;
    }

    public abstract T makeTemplate();

    private void confirm() {
        this.onFinish.accept(this.makeTemplate());
        this.parent.closePopup(this);
    }

    private void cancel() {
        this.parent.closePopup(this);
    }

    public Optional<T> baseTemplate() {
        return Optional.ofNullable(this.baseTemplate);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        ((StringWidget)this.m_142416_((GuiEventListener)new StringWidget(this.title, this.f_96547_))).m_264152_(this.x + (this.xSize - this.f_96547_.m_92852_((FormattedText)this.title)) / 2, this.y + 5);
        this.propertyList = (ComponentPropertyListWidget)this.m_142416_((GuiEventListener)new ComponentPropertyListWidget(this.x + 5, this.y + 15, this.xSize - 10, this.ySize - 50, 30));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CONFIRM, b -> this.confirm()).m_252987_(this.x + this.xSize / 3 - 25, this.y + this.ySize - 30, 50, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CANCEL, b -> this.cancel()).m_252987_(this.x + this.xSize / 3 * 2 - 25, this.y + this.ySize - 30, 50, 20).m_253136_());
    }

    public boolean checkLong(String s) {
        if (s.isEmpty()) {
            return true;
        }
        try {
            Long.parseLong(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public long parseLong(String s) {
        if (s.isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }
}

