/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.appearance;

import com.mojang.blaze3d.platform.Lighting;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.SuggestedEditBox;
import fr.frinn.custommachinery.common.util.MachineModelLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class ModelSelectionPopup
extends PopupScreen {
    private static final ResourceLocation EXIT_TEXTURE = new ResourceLocation("custommachinery", "textures/gui/config/exit_button.png");
    private final Supplier<MachineModelLocation> supplier;
    private final Consumer<MachineModelLocation> consumer;
    private final boolean isBlock;
    private SuggestedEditBox box;
    private ModelSelectionList selectionList;
    private Checkbox blocks;
    private Checkbox items;
    private Checkbox models;

    public ModelSelectionPopup(BaseScreen parent, Supplier<MachineModelLocation> supplier, Consumer<MachineModelLocation> consumer, boolean isBlock) {
        super(parent, 200, 230);
        this.supplier = supplier;
        this.consumer = consumer;
        this.isBlock = isBlock;
    }

    public void refreshBoxSuggestions() {
        this.box.clearSuggestions();
        if (this.blocks.m_93840_()) {
            this.box.addSuggestions(BuiltInRegistries.f_256975_.m_6566_().stream().map(ResourceLocation::toString).toList());
        }
        if (this.items.m_93840_()) {
            this.box.addSuggestions(BuiltInRegistries.f_257033_.m_6566_().stream().map(ResourceLocation::toString).toList());
        }
        if (this.models.m_93840_()) {
            this.box.addSuggestions(Minecraft.m_91087_().m_91304_().f_119397_.keySet().stream().map(ResourceLocation::toString).toList());
        }
        this.selectionList.setList(this.box.getSuggestions().stream().limit(100L).map(s -> MachineModelLocation.of(s.getText())).toList());
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ImageButton(this.x + 5, this.y + 5, 9, 9, 0, 0, 9, EXIT_TEXTURE, 9, 18, button -> this.parent.closePopup(this)));
        this.blocks = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.x + 5, this.y + 45, 20, 20, (Component)Component.m_237113_((String)"Blocks"), this.isBlock){

            public void m_5691_() {
                super.m_5691_();
                ModelSelectionPopup.this.refreshBoxSuggestions();
            }
        });
        this.items = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.x + 65, this.y + 45, 20, 20, (Component)Component.m_237113_((String)"Items"), !this.isBlock){

            public void m_5691_() {
                super.m_5691_();
                ModelSelectionPopup.this.refreshBoxSuggestions();
            }
        });
        this.models = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.x + 125, this.y + 45, 20, 20, (Component)Component.m_237113_((String)"Models"), false){

            public void m_5691_() {
                super.m_5691_();
                ModelSelectionPopup.this.refreshBoxSuggestions();
            }
        });
        this.box = (SuggestedEditBox)this.m_142416_((GuiEventListener)new SuggestedEditBox(Minecraft.m_91087_().f_91062_, this.x + 5, this.y + 70, this.xSize - 10, 20, this.f_96539_, 5));
        this.box.m_94199_(Integer.MAX_VALUE);
        this.box.m_94144_(this.supplier.get().toString());
        this.box.m_94198_();
        this.selectionList = (ModelSelectionList)this.m_142416_((GuiEventListener)new ModelSelectionList(this.x + 5, this.y + 90, this.xSize - 10, this.ySize - 95));
        this.selectionList.setResponder(this.consumer);
        this.box.m_94151_(value -> this.selectionList.setList(this.box.getSuggestions().stream().limit(100L).map(s -> MachineModelLocation.of(s.getText())).toList()));
        this.refreshBoxSuggestions();
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ModelSelectionPopup.renderModel(graphics, (float)this.x + (float)this.xSize / 2.0f - 8.0f, this.y + 20, this.supplier.get(), 32.0f);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    public static void renderModel(GuiGraphics graphics, float x, float y, MachineModelLocation loc, float scale) {
        BakedModel model = Minecraft.m_91087_().m_91304_().m_119409_();
        if (loc.getState() != null) {
            model = Minecraft.m_91087_().m_91289_().m_110910_(loc.getState());
        } else if (loc.getItem() != null) {
            model = Minecraft.m_91087_().m_91291_().m_174264_(loc.getItem().m_7968_(), (Level)Minecraft.m_91087_().f_91073_, (LivingEntity)Minecraft.m_91087_().f_91074_, 42);
        } else if (loc.getLoc() != null && loc.getProperties() != null) {
            model = Minecraft.m_91087_().m_91304_().m_119422_(new ModelResourceLocation(loc.getLoc(), loc.getProperties()));
        } else if (loc.getLoc() != null) {
            model = Minecraft.m_91087_().m_91304_().f_119397_.getOrDefault(loc.getLoc(), model);
        }
        RenderType renderType = RenderType.m_110466_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(x, y, 50.0f);
        graphics.m_280168_().m_85841_(scale, scale, scale);
        model.m_7442_().m_269404_(ItemDisplayContext.GUI).m_111763_(false, graphics.m_280168_());
        if (loc.getState() != null) {
            graphics.m_280168_().m_252781_(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, 90.0f));
            ItemBlockRenderTypes.m_109284_((BlockState)loc.getState(), (boolean)true);
            Lighting.m_84931_();
        }
        graphics.m_280168_().m_252880_(-0.5f, -0.5f, -0.5f);
        Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(graphics.m_280168_().m_85850_(), graphics.m_280091_().m_6299_(renderType), null, model, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_);
        if (loc.getState() != null) {
            Lighting.m_84930_();
        }
        graphics.m_280168_().m_85849_();
    }

    public static class ModelSelectionList
    extends AbstractWidget {
        private final List<MachineModelLocation> list = new ArrayList<MachineModelLocation>();
        private final int maxColumns;
        private Consumer<MachineModelLocation> responder;
        private MachineModelLocation selected;
        private double scrollAmount;
        private boolean scrolling = false;

        public ModelSelectionList(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.m_237119_());
            this.maxColumns = width / 20;
        }

        public void setList(List<MachineModelLocation> list) {
            this.list.clear();
            this.list.addAll(list);
        }

        public void setResponder(Consumer<MachineModelLocation> responder) {
            this.responder = responder;
        }

        @Nullable
        public MachineModelLocation getElementUnderMouse(double mouseX, double mouseY) {
            if (mouseX < (double)this.m_252754_() || mouseX > (double)(this.m_252754_() + this.maxColumns * 20) || mouseY < (double)this.m_252907_() || mouseY > (double)(this.m_252907_() + this.m_93694_())) {
                return null;
            }
            int index = (int)((mouseY - (double)this.m_252907_() + this.scrollAmount) / 20.0) * this.maxColumns + (int)((mouseX - (double)this.m_252754_()) / 20.0);
            if (index < 0 || index >= this.list.size()) {
                return null;
            }
            return this.list.get(index);
        }

        private void scroll(int scroll) {
            this.setScrollAmount(this.getScrollAmount() + (double)scroll);
        }

        public double getScrollAmount() {
            return this.scrollAmount;
        }

        public void setScrollAmount(double scroll) {
            this.scrollAmount = Mth.m_14008_((double)scroll, (double)0.0, (double)this.getMaxScroll());
        }

        public int getMaxScroll() {
            return Math.max(0, this.getMaxPosition() - this.m_93694_() - 4);
        }

        protected int getMaxPosition() {
            return this.list.size() / this.maxColumns * 20;
        }

        public int getScrollBottom() {
            return (int)this.getScrollAmount() - this.m_93694_();
        }

        protected void updateScrollingState(double mouseX, double mouseY, int button) {
            this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPosition() && mouseX < (double)(this.getScrollbarPosition() + 6);
        }

        protected int getScrollbarPosition() {
            return this.f_93618_ / 2 + 124;
        }

        protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            int i;
            graphics.m_280588_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_());
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)this.m_252754_(), (float)this.m_252907_(), 0.0f);
            for (i = 0; i < this.list.size(); ++i) {
                int x = i % this.maxColumns * 20;
                int y = i / this.maxColumns * 20 - (int)this.getScrollAmount();
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)x, (float)y, 100.0f);
                MachineModelLocation loc = this.list.get(i);
                if (this.selected == loc) {
                    graphics.m_280509_(0, 0, 20, 20, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0));
                }
                ModelSelectionPopup.renderModel(graphics, 10.0f, 10.0f, loc, 16.0f);
                graphics.m_280168_().m_85849_();
            }
            graphics.m_280168_().m_85849_();
            if (this.getMaxScroll() > 0) {
                i = this.m_252754_() + this.m_5711_() - 10;
                int j = i + 6;
                int n = this.m_93694_() * this.m_93694_() / this.getMaxPosition();
                n = Mth.m_14045_((int)n, (int)32, (int)(this.m_93694_() - 8));
                int o = (int)this.getScrollAmount() * (this.m_93694_() - n) / this.getMaxScroll() + this.m_252907_();
                if (o < this.m_252907_()) {
                    o = this.m_252907_();
                }
                graphics.m_280509_(i, this.m_252907_(), j, this.m_252907_() + this.m_93694_(), -16777216);
                graphics.m_280509_(i, o, j, o + n, -8355712);
                graphics.m_280509_(i, o, j - 1, o + n - 1, -4144960);
            }
            graphics.m_280618_();
            MachineModelLocation hovered = this.getElementUnderMouse(mouseX, mouseY);
            if (hovered != null) {
                graphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)hovered.toString()), mouseX, mouseY);
            }
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            this.updateScrollingState(mouseX, mouseY, button);
            MachineModelLocation selected = this.getElementUnderMouse(mouseX, mouseY);
            if (selected != null) {
                this.selected = selected;
                this.responder.accept(selected);
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (super.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
                return true;
            }
            if (button != 0 || !this.scrolling) {
                return false;
            }
            if (mouseY < (double)this.m_252907_()) {
                this.setScrollAmount(0.0);
            } else if (mouseY > (double)(this.m_252907_() + this.m_93694_())) {
                this.setScrollAmount(this.getMaxScroll());
            } else {
                double d = Math.max(1, this.getMaxScroll());
                int i = this.m_93694_();
                int j = Mth.m_14045_((int)((int)((float)(i * i) / (float)this.getMaxPosition())), (int)32, (int)(i - 8));
                double e = Math.max(1.0, d / (double)(i - j));
                this.setScrollAmount(this.getScrollAmount() + dragY * e);
            }
            return true;
        }

        public boolean m_6050_(double mouseX, double mouseY, double delta) {
            this.setScrollAmount(this.getScrollAmount() - delta * 10.0);
            return super.m_6050_(mouseX, mouseY, delta);
        }
    }
}

