/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation;

import com.google.common.collect.ImmutableList;
import fr.frinn.custommachinery.client.screen.creation.tabs.EditTabButton;
import fr.frinn.custommachinery.client.screen.creation.tabs.MachineEditTab;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.TabButton;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class MachineEditTabNavigationBar
extends AbstractContainerEventHandler
implements Renderable,
GuiEventListener,
NarratableEntry {
    private static final int NO_TAB = -1;
    private static final int MAX_WIDTH = 400;
    private static final int HEIGHT = 24;
    private static final int MARGIN = 14;
    private static final Component USAGE_NARRATION = Component.m_237115_((String)"narration.tab_navigation.usage");
    private final GridLayout layout;
    private int x;
    private int y;
    private int width;
    private int height;
    private final TabManager tabManager;
    private final ImmutableList<MachineEditTab> tabs;
    private final ImmutableList<TabButton> tabButtons;

    public MachineEditTabNavigationBar(int width, TabManager tabManager, Iterable<MachineEditTab> tabs) {
        this.width = width;
        this.tabManager = tabManager;
        this.tabs = ImmutableList.copyOf(tabs);
        this.layout = new GridLayout(0, 0);
        this.layout.m_264211_().m_264356_();
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = 0;
        for (MachineEditTab tab : tabs) {
            builder.add((Object)((TabButton)this.layout.m_264379_((LayoutElement)new EditTabButton(tabManager, tab, 0, 24), 0, i++)));
        }
        this.tabButtons = builder.build();
    }

    public void m_7522_(@Nullable GuiEventListener focused) {
        super.m_7522_(focused);
        if (focused instanceof TabButton) {
            TabButton tabButton = (TabButton)focused;
            this.tabManager.m_276088_(tabButton.m_274356_(), true);
        }
    }

    @Nullable
    public ComponentPath m_264064_(FocusNavigationEvent event) {
        TabButton tabButton;
        if (!this.m_93696_() && (tabButton = this.currentTabButton()) != null) {
            return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)ComponentPath.m_264401_((GuiEventListener)tabButton));
        }
        return event instanceof FocusNavigationEvent.TabNavigation ? null : super.m_264064_(event);
    }

    public List<TabButton> m_6702_() {
        return this.tabButtons;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return this.tabButtons.stream().map(AbstractWidget::m_142684_).max(Comparator.naturalOrder()).orElse(NarratableEntry.NarrationPriority.NONE);
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        Optional<TabButton> optional = this.tabButtons.stream().filter(AbstractWidget::m_274382_).findFirst().or(() -> Optional.ofNullable(this.currentTabButton()));
        optional.ifPresent(tabButton -> {
            this.narrateListElementPosition(narrationElementOutput.m_142047_(), (TabButton)tabButton);
            tabButton.m_142291_(narrationElementOutput);
        });
        if (this.m_93696_()) {
            narrationElementOutput.m_169146_(NarratedElementType.USAGE, USAGE_NARRATION);
        }
    }

    protected void narrateListElementPosition(NarrationElementOutput narrationElementOutput, TabButton tabButton) {
        int i;
        if (this.tabs.size() > 1 && (i = this.tabButtons.indexOf((Object)tabButton)) != -1) {
            narrationElementOutput.m_169146_(NarratedElementType.POSITION, (Component)Component.m_237110_((String)"narrator.position.tab", (Object[])new Object[]{i + 1, this.tabs.size()}));
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (TabButton tabButton : this.tabButtons) {
            tabButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void bounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public ScreenRectangle m_264198_() {
        return this.layout.m_264198_();
    }

    public void arrangeElements() {
        int i = Math.min(400, this.width);
        int j = Mth.m_144941_((int)(i / this.tabs.size()), (int)2);
        for (TabButton tabButton : this.tabButtons) {
            tabButton.m_93674_(j);
        }
        this.layout.m_264036_();
        this.layout.m_252865_(this.x);
        this.layout.m_253211_(this.y);
    }

    public void selectTab(int index, boolean playClickSound) {
        if (this.m_93696_()) {
            this.m_7522_((GuiEventListener)this.tabButtons.get(index));
        } else {
            this.tabManager.m_276088_((Tab)this.tabs.get(index), playClickSound);
        }
    }

    private int getNextTabIndex(int keycode) {
        int i;
        if (keycode >= 49 && keycode <= 57) {
            return keycode - 49;
        }
        if (keycode == 258 && (i = this.currentTabIndex()) != -1) {
            int j = Screen.m_96638_() ? i - 1 : i + 1;
            return Math.floorMod(j, this.tabs.size());
        }
        return -1;
    }

    private int currentTabIndex() {
        Tab tab = this.tabManager.m_267695_();
        int i = this.tabs.indexOf((Object)tab);
        return i != -1 ? i : -1;
    }

    @Nullable
    private TabButton currentTabButton() {
        int i = this.currentTabIndex();
        return i != -1 ? (TabButton)this.tabButtons.get(i) : null;
    }
}

