/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation;

import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineCreationScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditTabNavigationBar;
import fr.frinn.custommachinery.client.screen.creation.MachineTabManager;
import fr.frinn.custommachinery.client.screen.creation.tabs.AppearanceTab;
import fr.frinn.custommachinery.client.screen.creation.tabs.BaseInfoTab;
import fr.frinn.custommachinery.client.screen.creation.tabs.ComponentTab;
import fr.frinn.custommachinery.client.screen.creation.tabs.GuiTab;
import fr.frinn.custommachinery.client.screen.popup.ConfirmPopup;
import fr.frinn.custommachinery.common.machine.builder.CustomMachineBuilder;
import fr.frinn.custommachinery.common.network.CEditMachinePacket;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.toasts.TutorialToast;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MachineEditScreen
extends BaseScreen {
    public static final ResourceLocation WIDGETS = new ResourceLocation("custommachinery", "textures/gui/creation/edit_widget.png");
    private final MachineCreationScreen parent;
    private final CustomMachineBuilder builder;
    private boolean changed = false;
    private ImageButton save;
    private ImageButton close;
    private ImageButton wiki;
    private TabManager tabManager;
    private MachineEditTabNavigationBar bar;

    public MachineEditScreen(MachineCreationScreen parent, int xSize, int ySize, CustomMachineBuilder builder) {
        super((Component)Component.m_237113_((String)"Machine edit"), xSize, ySize);
        this.parent = parent;
        this.builder = builder;
    }

    public CustomMachineBuilder getBuilder() {
        return this.builder;
    }

    public void setChanged() {
        this.changed = true;
    }

    public void save() {
        this.changed = false;
        new CEditMachinePacket(this.builder.build()).sendToServer();
        Minecraft.m_91087_().m_91301_().m_120572_(new TutorialToast(TutorialToast.Icons.MOUSE, (Component)Component.m_237115_((String)"custommachinery.gui.creation.save.toast"), null, false), 50);
    }

    public void cancel() {
        if (!this.changed) {
            Minecraft.m_91087_().m_91152_((Screen)new MachineCreationScreen());
        }
        ConfirmPopup popup = new ConfirmPopup(this, 128, 96, () -> Minecraft.m_91087_().m_91152_((Screen)new MachineCreationScreen()));
        popup.title((Component)Component.m_237115_((String)"custommachinery.gui.popup.warning").m_130940_(ChatFormatting.DARK_RED));
        popup.text(new Component[]{Component.m_237115_((String)"custommachinery.gui.creation.popup.quit")});
        this.openPopup(popup);
    }

    public void wiki() {
        String[] s = SharedConstants.m_183709_().m_132493_().split("\\.");
        Object version = "1.19";
        if (s.length >= 2) {
            version = "1." + s[1];
        }
        Util.m_137581_().m_137646_("https://frinn.gitbook.io/custom-machinery-" + (String)version);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.save = this.m_142416_(new ImageButton(this.x - 28, this.y + 5, 20, 20, 0, 0, WIDGETS, button -> this.save()));
        this.save.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.save")));
        this.close = this.m_142416_(new ImageButton(this.x - 28, this.y + 30, 20, 20, 20, 0, WIDGETS, button -> this.cancel()));
        this.close.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.close")));
        this.wiki = this.m_142416_(new ImageButton(this.x - 28, this.y + 55, 20, 20, 40, 0, WIDGETS, button -> this.wiki()));
        this.wiki.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.wiki")));
        this.tabManager = new MachineTabManager(this::m_142416_, this::m_169411_);
        this.bar = this.m_142416_(new MachineEditTabNavigationBar(this.xSize, this.tabManager, List.of(new BaseInfoTab(this), new AppearanceTab(this), new ComponentTab(this), new GuiTab(this))));
        this.bar.selectTab(0, false);
        this.m_267719_();
    }

    public void m_267719_() {
        this.save.m_264152_(this.x - 28, this.y + 5);
        this.close.m_264152_(this.x - 28, this.y + 30);
        this.wiki.m_264152_(this.x - 28, this.y + 55);
        if (this.bar == null) {
            return;
        }
        this.bar.bounds(this.x + 5, this.y - 20, this.xSize - 10, 20);
        this.bar.arrangeElements();
        this.tabManager.m_267817_(new ScreenRectangle(this.x, this.y, this.xSize, this.ySize));
    }

    public <T extends GuiEventListener & Renderable> T m_142416_(T widget) {
        return (T)super.m_142416_(widget);
    }

    public void m_169411_(GuiEventListener listener) {
        super.m_169411_(listener);
    }

    public void m_280273_(GuiGraphics graphics) {
        super.m_280273_(graphics);
        MachineEditScreen.blankBackground(graphics, this.x, this.y, this.xSize, this.ySize);
        MachineEditScreen.blankBackground(graphics, this.x - 33, this.y, 30, 80);
    }

    public void m_7379_() {
        this.cancel();
    }
}

