/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.CreateMachinePopup;
import fr.frinn.custommachinery.client.screen.creation.DeleteMachinePopup;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineListWidget;
import fr.frinn.custommachinery.common.machine.builder.CustomMachineBuilder;
import java.io.File;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;

public class MachineCreationScreen
extends BaseScreen {
    private MachineListWidget machineList;
    private Button create;
    private Button edit;
    private Button open;
    private Button delete;

    public MachineCreationScreen() {
        super((Component)Component.m_237113_((String)"Machine creation"), 256, 192);
    }

    public void create() {
        this.openPopup(new CreateMachinePopup(this));
    }

    public void edit() {
        MachineListWidget.MachineEntry entry = (MachineListWidget.MachineEntry)this.machineList.getSelected();
        if (entry != null) {
            Minecraft.m_91087_().m_91152_((Screen)new MachineEditScreen(this, 288, 210, new CustomMachineBuilder(entry.getMachine())));
        }
    }

    public void open() {
        MachineListWidget.MachineEntry entry = (MachineListWidget.MachineEntry)this.machineList.getSelected();
        if (entry != null) {
            try {
                MinecraftServer server = (MinecraftServer)Objects.requireNonNull(Minecraft.m_91087_().m_91092_());
                File file = Objects.requireNonNull(entry.getMachine().getLocation().getFile(server));
                Util.m_137581_().m_137648_(file.toURI());
            }
            catch (NullPointerException e) {
                CustomMachinery.LOGGER.warn("Can't open machine json for machine: {}", (Object)entry.getMachine().getId());
            }
        }
    }

    public void delete() {
        MachineListWidget.MachineEntry entry = (MachineListWidget.MachineEntry)this.machineList.getSelected();
        if (entry != null) {
            this.openPopup(new DeleteMachinePopup(this, entry.getMachine()), "Delete machine");
        }
    }

    public void reloadList() {
        this.machineList.reload();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        GridLayout layout = new GridLayout(this.x, this.y);
        layout.m_264211_().m_264174_(5);
        GridLayout.RowHelper row = layout.m_264606_(4);
        LayoutSettings center = row.m_264551_().m_264356_();
        this.machineList = (MachineListWidget)row.m_264276_((LayoutElement)new MachineListWidget(this, 0, 0, this.xSize - 10, this.ySize - 40, 30), 4, center);
        this.machineList.reload();
        this.create = (Button)row.m_264206_((LayoutElement)new Button.Builder((Component)Component.m_237115_((String)"custommachinery.gui.creation.create"), button -> this.create()).m_252987_(0, 0, 50, 20).m_253136_(), center);
        this.edit = (Button)row.m_264206_((LayoutElement)new Button.Builder((Component)Component.m_237115_((String)"custommachinery.gui.creation.edit"), button -> this.edit()).m_252987_(0, 0, 50, 20).m_253136_(), center);
        this.open = (Button)row.m_264206_((LayoutElement)Button.m_253074_((Component)Component.m_237115_((String)"custommachinery.gui.creation.open"), button -> this.open()).m_252987_(0, 0, 50, 20).m_253136_(), center);
        this.delete = (Button)row.m_264206_((LayoutElement)new Button.Builder((Component)Component.m_237115_((String)"custommachinery.gui.creation.delete"), button -> this.delete()).m_252987_(0, 0, 50, 20).m_253136_(), center);
        layout.m_264036_();
        layout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }

    public void m_280273_(GuiGraphics graphics) {
        super.m_280273_(graphics);
        MachineCreationScreen.blankBackground(graphics, this.x, this.y, this.xSize, this.ySize);
        MachineListWidget.MachineEntry entry = (MachineListWidget.MachineEntry)this.machineList.getSelected();
        if (entry == null) {
            Tooltip notSelected = Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.notselected"));
            this.edit.f_93623_ = false;
            this.edit.m_257544_(notSelected);
            this.open.f_93623_ = false;
            this.open.m_257544_(notSelected);
            this.delete.f_93623_ = false;
            this.delete.m_257544_(notSelected);
            return;
        }
        if (entry.getMachine().getLocation().canEdit()) {
            this.edit.f_93623_ = true;
            this.edit.m_257544_(null);
            if (Minecraft.m_91087_().m_91092_() != null) {
                this.open.f_93623_ = true;
                this.open.m_257544_(null);
            } else {
                this.open.f_93623_ = false;
                this.open.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.cantopenserver")));
            }
            this.delete.f_93623_ = true;
            this.delete.m_257544_(null);
        } else {
            this.edit.f_93623_ = false;
            this.edit.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.cantedit")));
            this.open.f_93623_ = false;
            this.open.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.cantopen")));
            this.delete.f_93623_ = false;
            this.delete.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.cantdelete")));
        }
    }
}

