/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen;

import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.common.guielement.BackgroundGuiElement;
import fr.frinn.custommachinery.common.init.CustomMachineContainer;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.network.CGuiElementClickPacket;
import fr.frinn.custommachinery.common.util.Comparators;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElementWidget;
import fr.frinn.custommachinery.impl.guielement.GuiElementWidgetSupplierRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class CustomMachineScreen
extends AbstractContainerScreen<CustomMachineContainer>
implements IMachineScreen {
    private final CustomMachineTile tile;
    private final CustomMachine machine;
    @Nullable
    private final BackgroundGuiElement background;
    private final List<AbstractGuiElementWidget<?>> elementWidgets = new ArrayList();

    public CustomMachineScreen(CustomMachineContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.tile = container.getTile();
        this.machine = container.getTile().getMachine();
        this.f_97726_ = 256;
        this.f_97727_ = 192;
        this.background = this.tile.getGuiElements().stream().filter(element -> element instanceof BackgroundGuiElement).map(element -> (BackgroundGuiElement)element).findFirst().orElse(null);
        if (this.background != null) {
            this.f_97726_ = this.background.getWidth();
            this.f_97727_ = this.background.getHeight();
        }
    }

    protected void m_7856_() {
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.elementWidgets.clear();
        this.tile.getGuiElements().stream().filter(element -> GuiElementWidgetSupplierRegistry.hasWidgetSupplier(element.getType())).sorted(Comparators.GUI_ELEMENTS_COMPARATOR.reversed()).forEach(element -> this.addElementWidget(GuiElementWidgetSupplierRegistry.getWidgetSupplier(element.getType()).get((IGuiElement)element, this)));
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        this.m_280273_(graphics);
        if (this.background != null && this.background.getTexture() != null) {
            graphics.m_280163_(this.background.getTexture(), this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.f_97726_, this.f_97727_);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    @Override
    public int getX() {
        return this.f_97735_;
    }

    @Override
    public int getY() {
        return this.f_97736_;
    }

    @Override
    public int getWidth() {
        return this.f_97726_;
    }

    @Override
    public int getHeight() {
        return this.f_97727_;
    }

    @Override
    public CustomMachine getMachine() {
        return this.machine;
    }

    @Override
    public CustomMachineTile getTile() {
        return this.tile;
    }

    public Optional<AbstractGuiElementWidget<?>> getElementUnderMouse(double mouseX, double mouseY) {
        for (GuiEventListener widget : this.m_6702_()) {
            AbstractGuiElementWidget elementWidget;
            if (!(widget instanceof AbstractGuiElementWidget) || !(elementWidget = (AbstractGuiElementWidget)widget).m_5953_(mouseX, mouseY)) continue;
            return Optional.of(elementWidget);
        }
        return Optional.empty();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (AbstractGuiElementWidget<?> elementWidget : this.elementWidgets) {
            if (!elementWidget.m_6375_(mouseX, mouseY, button)) continue;
            new CGuiElementClickPacket(this.tile.getGuiElements().indexOf(elementWidget.getElement()), (byte)button).sendToServer();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void addElementWidget(AbstractGuiElementWidget<?> widget) {
        this.elementWidgets.add(widget);
        this.m_142416_((GuiEventListener)widget);
    }
}

