/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen;

import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.common.util.LRU;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class BaseScreen
extends Screen {
    private static final ResourceLocation BLANK_BACKGROUND = new ResourceLocation("custommachinery", "textures/gui/background.png");
    public final Minecraft mc = Minecraft.m_91087_();
    public int x;
    public int y;
    public int xSize;
    public int ySize;
    private final LRU<PopupScreen> popups = new LRU();
    private final Map<PopupScreen, String> popupToId = new HashMap<PopupScreen, String>();
    private int freezePopupsTicks;

    public BaseScreen(Component component, int xSize, int ySize) {
        super(component);
        this.xSize = xSize;
        this.ySize = ySize;
    }

    public void openPopup(PopupScreen popup) {
        if (this.popups.contains((Object)popup)) {
            return;
        }
        this.m_7522_(null);
        this.popups.add(popup);
        popup.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
    }

    public void openPopup(PopupScreen popup, String id) {
        if (this.popupToId.containsValue(id)) {
            return;
        }
        this.popupToId.put(popup, id);
        this.openPopup(popup);
        this.freezePopupsTicks = 40;
    }

    public void closePopup(PopupScreen popup) {
        popup.closed();
        this.popups.remove((Object)popup);
        this.popupToId.remove((Object)popup);
    }

    public Collection<PopupScreen> popups() {
        return this.popups;
    }

    @Nullable
    public PopupScreen getPopupUnderMouse(double mouseX, double mouseY) {
        return this.popups.stream().filter(popup -> mouseX >= (double)popup.x && mouseX <= (double)(popup.x + popup.xSize) && mouseY >= (double)popup.y && mouseY <= (double)(popup.y + popup.ySize)).findFirst().orElse(null);
    }

    public void m_7861_() {
        this.popups.forEach(PopupScreen::closed);
    }

    protected void m_7856_() {
        this.x = (this.f_96543_ - this.xSize) / 2;
        this.y = (this.f_96544_ - this.ySize) / 2;
        this.popups.forEach(popup -> popup.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_));
    }

    public void m_86600_() {
        this.popups.forEach(BaseScreen::m_86600_);
        if (this.freezePopupsTicks > 0) {
            --this.freezePopupsTicks;
        }
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        this.x = (width - this.xSize) / 2;
        this.y = (height - this.ySize) / 2;
        super.m_6574_(minecraft, width, height);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        PopupScreen hoveredPopup = this.getPopupUnderMouse(mouseX, mouseY);
        graphics.m_280168_().m_85836_();
        if (hoveredPopup != null) {
            super.m_88315_(graphics, Integer.MAX_VALUE, Integer.MAX_VALUE, partialTicks);
        } else {
            super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
        LRU.LRUIterator iterator = this.popups.descendingIterator();
        while (iterator.hasNext()) {
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 165.0f);
            PopupScreen popup = (PopupScreen)((Object)iterator.next());
            if (hoveredPopup == popup) {
                popup.m_280264_(graphics, mouseX, mouseY, partialTicks);
                continue;
            }
            popup.m_88315_(graphics, Integer.MAX_VALUE, Integer.MAX_VALUE, partialTicks);
        }
        graphics.m_280168_().m_85849_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (PopupScreen popup : this.popups) {
            if (!popup.m_5953_(mouseX, mouseY)) continue;
            boolean clicked = popup.m_6375_(mouseX, mouseY, button);
            if (this.freezePopupsTicks <= 0) {
                this.popups.moveUp(popup);
            }
            return clicked;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        for (PopupScreen popup : this.popups) {
            if (!popup.m_5953_(mouseX, mouseY)) continue;
            boolean released = popup.m_6348_(mouseX, mouseY, button);
            if (this.freezePopupsTicks <= 0) {
                this.popups.moveUp(popup);
            }
            return released;
        }
        this.m_7897_(false);
        if (this.m_7222_() != null && this.m_7222_().m_6348_(mouseX, mouseY, button)) {
            return true;
        }
        return this.m_94729_(mouseX, mouseY).filter(guiEventListener -> guiEventListener.m_6348_(mouseX, mouseY, button)).isPresent();
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        LRU.LRUIterator lRUIterator = this.popups.iterator();
        if (lRUIterator.hasNext()) {
            PopupScreen popup = (PopupScreen)((Object)lRUIterator.next());
            boolean dragged = popup.m_7979_(mouseX, mouseY, button, dragX, dragY);
            if (this.freezePopupsTicks <= 0) {
                this.popups.moveUp(popup);
            }
            return dragged;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        for (PopupScreen popup : this.popups) {
            if (!popup.m_5953_(mouseX, mouseY)) continue;
            boolean scrolled = popup.m_6050_(mouseX, mouseY, delta);
            if (this.freezePopupsTicks <= 0) {
                this.popups.moveUp(popup);
            }
            return scrolled;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        FocusNavigationEvent.ArrowNavigation event;
        if (keyCode == 256) {
            if (!this.popups.isEmpty()) {
                PopupScreen toClose = this.getPopupUnderMouse(Minecraft.m_91087_().f_91067_.m_91589_(), Minecraft.m_91087_().f_91067_.m_91594_());
                if (toClose == null) {
                    toClose = (PopupScreen)((Object)this.popups.iterator().next());
                }
                this.closePopup(toClose);
                return true;
            }
            this.m_7379_();
            return true;
        }
        for (PopupScreen popup : this.popups) {
            if (!popup.m_7933_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (this.m_7222_() != null && this.m_7222_().m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        switch (keyCode) {
            case 263: {
                FocusNavigationEvent.ArrowNavigation arrowNavigation = new FocusNavigationEvent.ArrowNavigation(ScreenDirection.LEFT);
                break;
            }
            case 262: {
                FocusNavigationEvent.ArrowNavigation arrowNavigation = new FocusNavigationEvent.ArrowNavigation(ScreenDirection.RIGHT);
                break;
            }
            case 265: {
                FocusNavigationEvent.ArrowNavigation arrowNavigation = new FocusNavigationEvent.ArrowNavigation(ScreenDirection.UP);
                break;
            }
            case 264: {
                FocusNavigationEvent.ArrowNavigation arrowNavigation = new FocusNavigationEvent.ArrowNavigation(ScreenDirection.DOWN);
                break;
            }
            case 258: {
                FocusNavigationEvent.ArrowNavigation arrowNavigation = new FocusNavigationEvent.TabNavigation(!Screen.m_96638_());
                break;
            }
            default: {
                FocusNavigationEvent.ArrowNavigation arrowNavigation = event = null;
            }
        }
        if (event != null) {
            ComponentPath path = this.popups.stream().findFirst().map(arg_0 -> BaseScreen.lambda$keyPressed$3((FocusNavigationEvent)event, arg_0)).orElse(this.m_264064_((FocusNavigationEvent)event));
            if (path == null && event instanceof FocusNavigationEvent.TabNavigation) {
                ComponentPath componentPath = this.m_264435_();
                if (componentPath != null) {
                    componentPath.m_264432_(false);
                }
                path = super.m_264064_((FocusNavigationEvent)event);
            }
            if (path != null) {
                this.m_264158_(path);
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        for (PopupScreen popup : this.popups) {
            if (!popup.m_7920_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        for (PopupScreen popup : this.popups) {
            if (!popup.m_5534_(codePoint, modifiers)) continue;
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        if (this.getPopupUnderMouse(mouseX, mouseY) != null) {
            return false;
        }
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.xSize) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.ySize);
    }

    public void m_7522_(@Nullable GuiEventListener focused) {
        if (this.m_7222_() != focused) {
            super.m_7522_(focused);
        }
        if (focused != null) {
            this.popups.forEach(popup -> popup.m_7522_(null));
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public static void blankBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.m_280163_(BLANK_BACKGROUND, x, y, 0.0f, 0.0f, 4, 4, 8, 8);
        graphics.m_280411_(BLANK_BACKGROUND, x + 4, y, width - 8, 4, 4.0f, 0.0f, 1, 4, 8, 8);
        graphics.m_280163_(BLANK_BACKGROUND, x + width - 4, y, 4.0f, 0.0f, 4, 3, 8, 8);
        graphics.m_280411_(BLANK_BACKGROUND, x, y + 4, 4, height - 7, 0.0f, 4.0f, 4, 1, 8, 8);
        graphics.m_280411_(BLANK_BACKGROUND, x + 4, y + 4, width - 7, height - 7, 4.0f, 3.0f, 1, 1, 8, 8);
        graphics.m_280411_(BLANK_BACKGROUND, x + width - 4, y + 3, 4, height - 7, 4.0f, 3.0f, 4, 1, 8, 8);
        graphics.m_280163_(BLANK_BACKGROUND, x, y + height - 3, 0.0f, 5.0f, 4, 3, 8, 8);
        graphics.m_280411_(BLANK_BACKGROUND, x + 4, y + height - 4, width - 8, 4, 3.0f, 4.0f, 1, 4, 8, 8);
        graphics.m_280411_(BLANK_BACKGROUND, x + width - 4, y + height - 4, 4, 4, 4.0f, 4.0f, 4, 4, 8, 8);
    }

    public static void drawCenteredString(GuiGraphics graphics, Font font, Component text, int x, int y, int color, boolean shadow) {
        int n = x - font.m_92852_((FormattedText)text) / 2;
        Objects.requireNonNull(font);
        graphics.m_280614_(font, text, n, y - 9 / 2, color, shadow);
    }

    public static void drawCenteredScaledString(GuiGraphics graphics, Font font, Component text, int x, int y, float scale, int color, boolean shadow) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(scale, scale, 0.0f);
        int n = (int)(((float)x - (float)font.m_92852_((FormattedText)text) * scale / 2.0f) / scale);
        Objects.requireNonNull(font);
        graphics.m_280614_(font, text, n, (int)((float)(y - 9 / 2) / scale), color, shadow);
        graphics.m_280168_().m_85849_();
    }

    public static void drawScaledString(GuiGraphics graphics, Font font, Component text, int x, int y, float scale, int color, boolean shadow) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(scale, scale, 0.0f);
        graphics.m_280614_(font, text, (int)((float)x / scale), (int)((float)y / scale), color, shadow);
        graphics.m_280168_().m_85849_();
    }

    private static /* synthetic */ ComponentPath lambda$keyPressed$3(FocusNavigationEvent event, PopupScreen popup) {
        return popup.m_264064_(event);
    }
}

