/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.frinn.custommachinery.client.RenderTypes;
import fr.frinn.custommachinery.common.integration.config.CMConfig;
import fr.frinn.custommachinery.common.util.CycleTimer;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.ingredient.BlockIngredient;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public class StructureRenderer {
    private final int time;
    private final long start;
    private final Function<Direction, Map<BlockPos, IIngredient<PartialBlockState>>> blocksGetter;
    private final CycleTimer timer;

    public StructureRenderer(int time, Function<Direction, Map<BlockPos, IIngredient<PartialBlockState>>> blocksGetter) {
        this.time = time;
        this.start = System.currentTimeMillis();
        this.blocksGetter = blocksGetter;
        this.timer = new CycleTimer(() -> CMConfig.get().blockTagCycleTime);
    }

    public void render(PoseStack matrix, MultiBufferSource buffer, Direction direction, Level world, BlockPos machinePos) {
        Map<BlockPos, IIngredient<PartialBlockState>> blocks = this.blocksGetter.apply(direction);
        this.timer.onDraw();
        blocks.forEach((pos, ingredient) -> {
            matrix.m_85836_();
            matrix.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            if ((pos.m_123341_() != 0 || pos.m_123342_() != 0 || pos.m_123343_() != 0) && ingredient != BlockIngredient.ANY) {
                PartialBlockState state = (PartialBlockState)this.timer.get(ingredient.getAll());
                BlockPos blockPos = machinePos.m_121955_((Vec3i)pos);
                if (state != null && state != PartialBlockState.ANY && !state.getBlockState().m_60795_()) {
                    if (world.m_8055_(blockPos).m_60795_()) {
                        this.renderTransparentBlock(state, matrix, buffer);
                    } else if (ingredient.getAll().stream().noneMatch(test -> test.test(new BlockInWorld((LevelReader)world, blockPos, false)))) {
                        this.renderNope(matrix, buffer);
                    }
                }
            }
            matrix.m_85849_();
        });
    }

    private void renderTransparentBlock(PartialBlockState state, PoseStack matrix, MultiBufferSource buffer) {
        VertexConsumer builder = buffer.m_6299_(RenderTypes.PHANTOM);
        matrix.m_252880_(0.1f, 0.1f, 0.1f);
        matrix.m_85841_(0.8f, 0.8f, 0.8f);
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state.getBlockState());
        int[] light = new int[4];
        Arrays.fill(light, LightTexture.m_109885_((int)15, (int)15));
        if (model != Minecraft.m_91087_().m_91304_().m_119409_()) {
            Arrays.stream(Direction.values()).flatMap(direction -> model.m_213637_(state.getBlockState(), direction, RandomSource.m_216335_((long)42L)).stream()).forEach(quad -> builder.m_85995_(matrix.m_85850_(), quad, new float[]{1.0f, 1.0f, 1.0f, 0.8f}, 1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_, false));
            model.m_213637_(state.getBlockState(), null, RandomSource.m_216335_((long)42L)).forEach(quad -> builder.m_85995_(matrix.m_85850_(), quad, new float[]{1.0f, 1.0f, 1.0f, 0.8f}, 1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_, false));
        }
    }

    private void renderNope(PoseStack matrix, MultiBufferSource buffer) {
        VertexConsumer builder = buffer.m_6299_(RenderTypes.NOPE);
        BakedModel model = Minecraft.m_91087_().m_91304_().f_119397_.getOrDefault(new ResourceLocation("custommachinery", "block/nope"), Minecraft.m_91087_().m_91304_().m_119409_());
        matrix.m_85837_(-5.0E-4, -5.0E-4, -5.0E-4);
        matrix.m_85841_(1.001f, 1.001f, 1.001f);
        int[] light = new int[4];
        Arrays.fill(light, LightTexture.m_109885_((int)15, (int)15));
        Arrays.stream(Direction.values()).flatMap(direction -> model.m_213637_(null, direction, RandomSource.m_216335_((long)42L)).stream()).forEach(quad -> builder.m_85995_(matrix.m_85850_(), quad, new float[]{1.0f, 1.0f, 1.0f, 0.8f}, 1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_, false));
        model.m_213637_(null, null, RandomSource.m_216335_((long)42L)).forEach(quad -> builder.m_85995_(matrix.m_85850_(), quad, new float[]{1.0f, 1.0f, 1.0f, 0.8f}, 1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_, false));
    }

    public boolean shouldRender() {
        return System.currentTimeMillis() < this.start + (long)this.time;
    }
}

