/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei.wrapper;

import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.integration.jei.IRecipeHelper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.common.guielement.SlotGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.ingredients.IIngredientType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemIngredientWrapper
implements IJEIIngredientWrapper<ItemStack> {
    private final RequirementIOMode mode;
    private final IIngredient<Item> item;
    private final int amount;
    private final double chance;
    private final boolean useDurability;
    @Nullable
    private final CompoundTag nbt;
    private final String slot;
    private final boolean showRequireSlot;

    public ItemIngredientWrapper(RequirementIOMode mode, IIngredient<Item> item, int amount, double chance, boolean useDurability, @Nullable CompoundTag nbt, String slot, boolean showRequireSlot) {
        this.mode = mode;
        this.item = item;
        this.amount = amount;
        this.chance = chance;
        this.useDurability = useDurability;
        this.nbt = nbt;
        this.slot = slot;
        this.showRequireSlot = showRequireSlot;
    }

    @Override
    public boolean setupRecipe(IRecipeLayoutBuilder builder, int xOffset, int yOffset, IGuiElement element, IRecipeHelper helper) {
        SlotGuiElement slotElement;
        block5: {
            block4: {
                if (!(element instanceof SlotGuiElement)) break block4;
                slotElement = (SlotGuiElement)element;
                if (element.getType() == Registration.SLOT_GUI_ELEMENT.get()) break block5;
            }
            return false;
        }
        List<ItemStack> ingredients = this.item.getAll().stream().map(item -> Utils.makeItemStack(item, this.useDurability ? 1 : this.amount, this.nbt)).toList();
        Optional<IMachineComponentTemplate<?>> template = helper.getComponentForElement(slotElement);
        if (slotElement.getComponentId().equals(this.slot) || template.map(t -> t.canAccept(ingredients, this.mode == RequirementIOMode.INPUT, helper.getDummyManager()) && (this.slot.isEmpty() || t.getId().equals(this.slot))).orElse(false).booleanValue()) {
            int slotX = element.getX() + (element.getWidth() - 16) / 2;
            int slotY = element.getY() + (element.getHeight() - 16) / 2;
            ((IRecipeSlotBuilder)builder.addSlot(this.roleFromMode(this.mode), slotX - xOffset, slotY - yOffset).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, ingredients)).addTooltipCallback((view, tooltips) -> {
                if (this.useDurability && this.mode == RequirementIOMode.INPUT) {
                    tooltips.add(Component.m_237110_((String)"custommachinery.jei.ingredient.item.durability.consume", (Object[])new Object[]{this.amount}));
                } else if (this.useDurability && this.mode == RequirementIOMode.OUTPUT) {
                    tooltips.add(Component.m_237110_((String)"custommachinery.jei.ingredient.item.durability.repair", (Object[])new Object[]{this.amount}));
                }
                if (this.chance == 0.0) {
                    tooltips.add(Component.m_237115_((String)"custommachinery.jei.ingredient.chance.0").m_130940_(ChatFormatting.DARK_RED));
                } else if (this.chance != 1.0) {
                    double percentage = this.chance * 100.0;
                    if (percentage < (double)0.01f) {
                        tooltips.add(Component.m_237110_((String)"custommachinery.jei.ingredient.chance", (Object[])new Object[]{"<0.01"}));
                    } else {
                        BigDecimal decimal = BigDecimal.valueOf(percentage).setScale(2, RoundingMode.HALF_UP);
                        if (decimal.scale() <= 0 || decimal.signum() == 0 || decimal.stripTrailingZeros().scale() <= 0) {
                            tooltips.add(Component.m_237110_((String)"custommachinery.jei.ingredient.chance", (Object[])new Object[]{decimal.intValue()}));
                        } else {
                            tooltips.add(Component.m_237110_((String)"custommachinery.jei.ingredient.chance", (Object[])new Object[]{decimal.doubleValue()}));
                        }
                    }
                }
                if (!this.slot.isEmpty() && this.showRequireSlot && Minecraft.m_91087_().f_91066_.f_92125_) {
                    tooltips.add(Component.m_237115_((String)"custommachinery.jei.ingredient.item.specificSlot").m_130940_(ChatFormatting.DARK_RED));
                }
            });
            return true;
        }
        return false;
    }
}

