/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei.experience;

import fr.frinn.custommachinery.api.integration.jei.JEIIngredientRenderer;
import fr.frinn.custommachinery.common.guielement.ExperienceGuiElement;
import fr.frinn.custommachinery.common.util.Color;
import fr.frinn.custommachinery.common.util.ExperienceUtils;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.impl.integration.jei.CustomIngredientTypes;
import fr.frinn.custommachinery.impl.integration.jei.Experience;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class ExperienceJEIIngredientRenderer
extends JEIIngredientRenderer<Experience, ExperienceGuiElement> {
    public ExperienceJEIIngredientRenderer(ExperienceGuiElement element) {
        super(element);
    }

    @Override
    public IIngredientType<Experience> getType() {
        return CustomIngredientTypes.EXPERIENCE;
    }

    public int getWidth() {
        return ((ExperienceGuiElement)this.element).getWidth() - 2;
    }

    public int getHeight() {
        return ((ExperienceGuiElement)this.element).getHeight() - 2;
    }

    public void render(GuiGraphics graphics, @Nullable Experience ingredient) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (((ExperienceGuiElement)this.element).getMode().isDisplayBar()) {
            String levels = "" + (ingredient != null ? (ingredient.isLevels() ? ingredient.getXp() : ExperienceUtils.getLevelFromXp(ingredient.getXp())) : 0);
            int xPos = width / 2 - Minecraft.m_91087_().f_91062_.m_92895_(levels) / 2;
            graphics.m_280056_(Minecraft.m_91087_().f_91062_, levels, xPos, 0, 8453920, true);
            graphics.m_280509_(0, height - 3, width, height, -16777216);
            if (ingredient != null && ingredient.isPoints()) {
                int level = ExperienceUtils.getLevelFromXp(ingredient.getXp());
                int xpDiff = ingredient.getXp() - ExperienceUtils.getXpFromLevel(level);
                if (xpDiff > 0) {
                    double percent = (double)xpDiff / (double)ExperienceUtils.getXpNeededForNextLevel(level);
                    graphics.m_280509_(1, height - 2, 1 + Math.max((int)Math.ceil((double)width * percent) - 2, 0), height - 1, -8323296);
                }
            }
        } else {
            graphics.m_280509_(((ExperienceGuiElement)this.element).getX(), ((ExperienceGuiElement)this.element).getY(), ((ExperienceGuiElement)this.element).getX() + width, ((ExperienceGuiElement)this.element).getY() + height, Color.fromColors(1, 7, 186, 7).getARGB());
        }
    }

    public List<Component> getTooltip(Experience ingredient, TooltipFlag iTooltipFlag) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        String amount = Utils.format(ingredient.getXp());
        if (ingredient.isPoints()) {
            if (ingredient.isPerTick()) {
                tooltips.add((Component)Component.m_237110_((String)"custommachinery.jei.ingredient.xp.point.pertick", (Object[])new Object[]{amount}));
            } else {
                tooltips.add((Component)Component.m_237110_((String)"custommachinery.jei.ingredient.xp.point", (Object[])new Object[]{amount}));
            }
        } else if (ingredient.isLevels()) {
            if (ingredient.isPerTick()) {
                tooltips.add((Component)Component.m_237110_((String)"custommachinery.jei.ingredient.xp.level.pertick", (Object[])new Object[]{amount}));
            } else {
                tooltips.add((Component)Component.m_237110_((String)"custommachinery.jei.ingredient.xp.level", (Object[])new Object[]{amount}));
            }
        }
        if (ingredient.getChance() == 0.0) {
            tooltips.add((Component)Component.m_237115_((String)"custommachinery.jei.ingredient.chance.0").m_130940_(ChatFormatting.DARK_RED));
        }
        if (ingredient.getChance() < 1.0 && ingredient.getChance() > 0.0) {
            tooltips.add((Component)Component.m_237110_((String)"custommachinery.jei.ingredient.chance", (Object[])new Object[]{(int)(ingredient.getChance() * 100.0)}));
        }
        return tooltips;
    }
}

