/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei;

import com.mojang.datafixers.util.Pair;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.impl.util.TextureSizeHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class RequirementDisplayInfo
implements IDisplayInfo {
    private static final IDisplayInfoRenderer DEFAULT_RENDERER = new Texture(new ResourceLocation("custommachinery", "textures/gui/creation/create_icon.png"), 10, 10, 0, 0);
    private IDisplayInfoRenderer renderer = DEFAULT_RENDERER;
    private final List<Pair<Component, IDisplayInfo.TooltipPredicate>> tooltips = new ArrayList<Pair<Component, IDisplayInfo.TooltipPredicate>>();
    private IDisplayInfo.ClickAction clickAction;

    @Override
    public RequirementDisplayInfo setTextureIcon(ResourceLocation icon, int width, int height, int u, int v) {
        this.renderer = new Texture(icon, width, height, u, v);
        return this;
    }

    @Override
    public IDisplayInfo setSpriteIcon(ResourceLocation atlas, ResourceLocation sprite) {
        this.renderer = new Sprite(atlas, sprite);
        return this;
    }

    @Override
    public RequirementDisplayInfo setItemIcon(ItemStack stack) {
        this.renderer = new Item(stack);
        return this;
    }

    @Override
    public RequirementDisplayInfo addTooltip(Component tooltip, IDisplayInfo.TooltipPredicate predicate) {
        this.tooltips.add((Pair<Component, IDisplayInfo.TooltipPredicate>)Pair.of((Object)tooltip, (Object)predicate));
        return this;
    }

    @Override
    public void setClickAction(IDisplayInfo.ClickAction clickAction) {
        this.clickAction = clickAction;
    }

    public void renderIcon(GuiGraphics graphics, int size) {
        this.renderer.render(graphics, size);
    }

    public List<Pair<Component, IDisplayInfo.TooltipPredicate>> getTooltips() {
        return this.tooltips;
    }

    public boolean hasClickAction() {
        return this.clickAction != null;
    }

    public boolean handleClick(CustomMachine machine, IMachineRecipe recipe, int button) {
        if (this.hasClickAction()) {
            this.clickAction.handleClick(machine, recipe, button);
            return true;
        }
        return false;
    }

    public boolean shouldRender() {
        return this.renderer != DEFAULT_RENDERER || !this.tooltips.isEmpty() || this.hasClickAction();
    }

    public static interface IDisplayInfoRenderer {
        public void render(GuiGraphics var1, int var2);
    }

    private record Texture(ResourceLocation icon, int width, int height, int u, int v) implements IDisplayInfoRenderer
    {
        @Override
        public void render(GuiGraphics graphics, int size) {
            int textureWidth = TextureSizeHelper.getTextureWidth(this.icon);
            int textureHeight = TextureSizeHelper.getTextureHeight(this.icon);
            graphics.m_280411_(this.icon, 0, 0, size, size, (float)this.u, (float)this.v, textureWidth, textureHeight, textureWidth, textureHeight);
        }
    }

    private record Sprite(ResourceLocation atlas, ResourceLocation sprite) implements IDisplayInfoRenderer
    {
        @Override
        public void render(GuiGraphics graphics, int size) {
            graphics.m_280159_(0, 0, 0, size, size, (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(this.atlas).apply(this.sprite));
        }
    }

    private record Item(ItemStack stack) implements IDisplayInfoRenderer
    {
        @Override
        public void render(GuiGraphics graphics, int size) {
            graphics.m_280168_().m_85841_((float)size / 16.0f, (float)size / 16.0f, 1.0f);
            graphics.m_280480_(this.stack, 0, 0);
        }
    }
}

