/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.integration.jei.DisplayInfoTemplate;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IJEIElementRenderer;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.client.integration.jei.RecipeHelper;
import fr.frinn.custommachinery.client.integration.jei.RequirementDisplayInfo;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipe;
import fr.frinn.custommachinery.common.init.CustomMachineItem;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.util.Comparators;
import fr.frinn.custommachinery.impl.integration.jei.GuiElementJEIRendererRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractRecipeCategory<T extends IMachineRecipe>
implements IRecipeCategory<T> {
    protected static final int ICON_SIZE = 10;
    protected final CustomMachine machine;
    protected final RecipeType<T> recipeType;
    protected final IGuiHelper guiHelper;
    protected final RecipeHelper recipeHelper;
    protected final LoadingCache<IRequirement<?>, RequirementDisplayInfo> infoCache;
    protected LoadingCache<T, List<IJEIIngredientWrapper<?>>> wrapperCache;
    protected int offsetX;
    protected int offsetY;
    protected int width;
    protected int height;
    protected int rowY;
    protected int maxIconPerRow;

    public AbstractRecipeCategory(CustomMachine machine, RecipeType<T> type, IJeiHelpers helpers) {
        this.machine = machine;
        this.recipeType = type;
        this.guiHelper = helpers.getGuiHelper();
        this.recipeHelper = new RecipeHelper(machine, helpers);
        this.infoCache = CacheBuilder.newBuilder().build(new CacheLoader<IRequirement<?>, RequirementDisplayInfo>(){

            public RequirementDisplayInfo load(IRequirement<?> requirement) {
                RequirementDisplayInfo info = new RequirementDisplayInfo();
                requirement.getDisplayInfo(info);
                DisplayInfoTemplate template = requirement.getDisplayInfoTemplate();
                if (template != null) {
                    if (!template.getTooltips().isEmpty()) {
                        info.getTooltips().clear();
                    }
                    template.build(info);
                }
                return info;
            }
        });
        this.wrapperCache = CacheBuilder.newBuilder().build(new CacheLoader<T, List<IJEIIngredientWrapper<?>>>(){

            public List<IJEIIngredientWrapper<?>> load(T recipe) {
                ImmutableList.Builder wrappers = ImmutableList.builder();
                recipe.getJEIIngredientRequirements().forEach(requirement -> wrappers.addAll(requirement.getJEIIngredientWrappers((IMachineRecipe)recipe)));
                return wrappers.build();
            }
        });
        this.setupRecipeDimensions();
    }

    private void setupRecipeDimensions() {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = 0;
        int maxY = 0;
        List<IGuiElement> elements = this.machine.getJeiElements().isEmpty() ? this.machine.getGuiElements() : this.machine.getJeiElements();
        for (IGuiElement element : elements) {
            if (!GuiElementJEIRendererRegistry.hasJEIRenderer(element.getType()) || !element.showInJei()) continue;
            minX = Math.min(minX, element.getX());
            minY = Math.min(minY, element.getY());
            maxX = Math.max(maxX, element.getX() + element.getWidth());
            maxY = Math.max(maxY, element.getY() + element.getHeight());
        }
        this.rowY = Math.max(maxY - minY, 20);
        this.offsetX = Math.max(minX, 0);
        this.offsetY = Math.max(minY, 0);
        this.width = Math.max(maxX - minX, 20);
        this.maxIconPerRow = this.width / 12;
        long maxDisplayRequirement = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)Registration.CUSTOM_MACHINE_RECIPE.get()).stream().filter(recipe -> recipe.getMachineId().equals((Object)this.machine.getId())).mapToLong(recipe -> recipe.getDisplayInfoRequirements().stream().map(this.infoCache).filter(RequirementDisplayInfo::shouldRender).count()).max().orElse(1L);
        int rows = Math.toIntExact(maxDisplayRequirement) / this.maxIconPerRow + 1;
        this.height = this.rowY + 12 * rows;
    }

    public RecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    public Component getTitle() {
        return this.machine.getName();
    }

    public IDrawable getBackground() {
        return this.guiHelper.createBlankDrawable(this.width, this.height);
    }

    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)CustomMachineItem.makeMachineItem(this.machine.getId()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        CustomMachineRecipe machineRecipe;
        List<IGuiElement> elements;
        builder.moveRecipeTransferButton(this.width - 11, this.height - 11);
        ArrayList wrappers = new ArrayList((Collection)this.wrapperCache.getUnchecked(recipe));
        List<IGuiElement> list = elements = this.machine.getJeiElements().isEmpty() ? this.machine.getGuiElements() : this.machine.getJeiElements();
        if (recipe instanceof CustomMachineRecipe && !(machineRecipe = (CustomMachineRecipe)recipe).getGuiElements().isEmpty()) {
            elements = machineRecipe.getCustomGuiElements(elements);
        }
        elements.forEach(element -> {
            Iterator iterator = wrappers.iterator();
            while (iterator.hasNext()) {
                IJEIIngredientWrapper wrapper = (IJEIIngredientWrapper)iterator.next();
                if (!wrapper.setupRecipe(builder, this.offsetX, this.offsetY, (IGuiElement)element, this.recipeHelper)) continue;
                iterator.remove();
                break;
            }
        });
    }

    public void draw(T recipe, IRecipeSlotsView slotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        CustomMachineRecipe machineRecipe;
        List<IGuiElement> elements;
        List<IGuiElement> list = elements = this.machine.getJeiElements().isEmpty() ? this.machine.getGuiElements() : this.machine.getJeiElements();
        if (recipe instanceof CustomMachineRecipe && !(machineRecipe = (CustomMachineRecipe)recipe).getGuiElements().isEmpty()) {
            elements = machineRecipe.getCustomGuiElements(elements);
        }
        elements.stream().filter(element -> GuiElementJEIRendererRegistry.hasJEIRenderer(element.getType()) && element.showInJei()).sorted(Comparators.GUI_ELEMENTS_COMPARATOR.reversed()).forEach(element -> {
            IJEIElementRenderer<IGuiElement> renderer = GuiElementJEIRendererRegistry.getJEIRenderer(element.getType());
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)(-this.offsetX), (float)(-this.offsetY), 0.0f);
            renderer.renderElementInJEI(graphics, (IGuiElement)element, (IMachineRecipe)recipe, (int)mouseX, (int)mouseY);
            graphics.m_280168_().m_85849_();
        });
        graphics.m_280509_(-3, this.rowY, this.width + 3, this.rowY + 1, 0x30000000);
        AtomicInteger index = new AtomicInteger();
        AtomicInteger row = new AtomicInteger(0);
        recipe.getDisplayInfoRequirements().stream().map(this.infoCache).filter(RequirementDisplayInfo::shouldRender).forEach(info -> {
            int x = index.get() * 12 - 2;
            int y = this.rowY + 2 + 12 * row.get();
            if (index.incrementAndGet() >= this.maxIconPerRow) {
                index.set(0);
                row.incrementAndGet();
            }
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85837_((double)x, (double)y, 0.0);
            info.renderIcon(graphics, 10);
            graphics.m_280168_().m_85849_();
        });
    }

    public List<Component> getTooltipStrings(T recipe, IRecipeSlotsView view, double mouseX, double mouseY) {
        Object machineRecipe;
        List<IGuiElement> elements;
        List<IGuiElement> list = elements = this.machine.getJeiElements().isEmpty() ? this.machine.getGuiElements() : this.machine.getJeiElements();
        if (recipe instanceof CustomMachineRecipe && !((CustomMachineRecipe)(machineRecipe = (CustomMachineRecipe)recipe)).getGuiElements().isEmpty()) {
            elements = ((CustomMachineRecipe)machineRecipe).getCustomGuiElements(elements);
        }
        for (IGuiElement element : elements) {
            int y;
            int x;
            IJEIElementRenderer<IGuiElement> renderer;
            if (!element.showInJei() || !GuiElementJEIRendererRegistry.hasJEIRenderer(element.getType()) || !(renderer = GuiElementJEIRendererRegistry.getJEIRenderer(element.getType())).isHoveredInJei(element, x = element.getX() - this.offsetX, y = element.getY() - this.offsetY, (int)mouseX, (int)mouseY)) continue;
            return renderer.getJEITooltips(element, (IMachineRecipe)recipe);
        }
        int index = 0;
        int row = 0;
        for (RequirementDisplayInfo info : recipe.getDisplayInfoRequirements().stream().map(this.infoCache).filter(RequirementDisplayInfo::shouldRender).toList()) {
            int x = index * 12 - 2;
            int y = this.rowY + 2 + 12 * row;
            if (index++ >= this.maxIconPerRow) {
                index = 0;
                ++row;
            }
            if (!(mouseX >= (double)x) || !(mouseX <= (double)(x + 10)) || !(mouseY >= (double)y) || !(mouseY <= (double)(y + 10)) || Minecraft.m_91087_().f_91080_ == null) continue;
            return info.getTooltips().stream().filter(pair -> ((IDisplayInfo.TooltipPredicate)pair.getSecond()).shouldDisplay((Player)Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().f_91066_.f_92125_)).map(Pair::getFirst).toList();
        }
        return Collections.emptyList();
    }

    public boolean handleInput(T recipe, double mouseX, double mouseY, InputConstants.Key mouseButton) {
        if (mouseButton.m_84873_() != 0 && mouseButton.m_84873_() != 1 && mouseButton.m_84873_() != 2) {
            return false;
        }
        AtomicInteger index = new AtomicInteger();
        AtomicInteger row = new AtomicInteger(0);
        return recipe.getDisplayInfoRequirements().stream().map(this.infoCache).filter(RequirementDisplayInfo::shouldRender).anyMatch(info -> {
            int x = index.get() * 12 - 2;
            int y = this.rowY + 2 + 12 * row.get();
            if (index.incrementAndGet() >= this.maxIconPerRow) {
                index.set(0);
                row.incrementAndGet();
            }
            if (mouseX >= (double)x && mouseX <= (double)(x + 10) && mouseY >= (double)y && mouseY <= (double)(y + 10) && Minecraft.m_91087_().f_91080_ != null) {
                return info.handleClick(this.machine, (IMachineRecipe)recipe, mouseButton.m_84873_());
            }
            return false;
        });
    }
}

