/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.element;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.common.guielement.SlotGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.integration.config.CMConfig;
import fr.frinn.custommachinery.common.util.CycleTimer;
import fr.frinn.custommachinery.common.util.GhostItem;
import fr.frinn.custommachinery.impl.guielement.TexturedGuiElementWidget;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;

public class SlotGuiElementWidget
extends TexturedGuiElementWidget<SlotGuiElement> {
    private static final CycleTimer timer = new CycleTimer(() -> CMConfig.get().itemSlotCycleTime);

    public SlotGuiElementWidget(SlotGuiElement element, IMachineScreen screen) {
        super(element, screen, (Component)Component.m_237113_((String)"Slot"));
    }

    @Override
    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_87963_(graphics, mouseX, mouseY, partialTicks);
        GhostItem ghost = ((SlotGuiElement)this.getElement()).getGhost();
        if (ghost != GhostItem.EMPTY && !ghost.items().isEmpty() && (ghost.alwaysRender() || this.isSlotEmpty())) {
            timer.onDraw();
            List items = ghost.items().stream().flatMap(ingredient -> ingredient.getAll().stream()).toList();
            RenderSystem.setShaderColor((float)((float)ghost.color().getRed() / 255.0f), (float)((float)ghost.color().getGreen() / 255.0f), (float)((float)ghost.color().getBlue() / 255.0f), (float)((float)ghost.color().getAlpha() / 255.0f));
            graphics.m_280480_(timer.getOrDefault(items, Items.f_41852_).m_7968_(), this.m_252754_() + 1, this.m_252907_() + 1);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        return false;
    }

    private boolean isSlotEmpty() {
        return this.getScreen().getTile().getComponentManager().getComponentHandler((MachineComponentType)Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(((SlotGuiElement)this.getElement()).getComponentId())).map(component -> component.getItemStack().m_41619_()).orElse(true);
    }
}

