/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.api.network.IData;
import fr.frinn.custommachinery.client.screen.CustomMachineScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineCreationScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.common.init.CustomMachineContainer;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import fr.frinn.custommachinery.common.machine.builder.CustomMachineBuilder;
import fr.frinn.custommachinery.common.network.SyncableContainer;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class ClientPacketHandler {
    public static void handleMachineStatusChangedPacket(BlockPos pos, MachineStatus status) {
        CustomMachineTile machineTile;
        BlockEntity tile;
        if (Minecraft.m_91087_().f_91073_ != null && (tile = Minecraft.m_91087_().f_91073_.m_7702_(pos)) instanceof CustomMachineTile && status != (machineTile = (CustomMachineTile)tile).getStatus()) {
            machineTile.setStatus(status);
            machineTile.refreshClientData();
            Minecraft.m_91087_().f_91073_.m_7260_(pos, tile.m_58900_(), tile.m_58900_(), 3);
        }
    }

    public static void handleRefreshCustomMachineTilePacket(BlockPos pos, ResourceLocation machine) {
        BlockEntity tile;
        if (Minecraft.m_91087_().f_91073_ != null && (tile = Minecraft.m_91087_().f_91073_.m_7702_(pos)) instanceof CustomMachineTile) {
            CustomMachineTile machineTile = (CustomMachineTile)tile;
            machineTile.setId(machine);
            machineTile.refreshClientData();
            Minecraft.m_91087_().f_91073_.m_7260_(pos, machineTile.m_58900_(), machineTile.m_58900_(), 3);
        }
    }

    public static void handleUpdateContainerPacket(int windowId, List<IData<?>> data) {
        AbstractContainerMenu abstractContainerMenu;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (abstractContainerMenu = player.f_36096_) instanceof SyncableContainer) {
            SyncableContainer container = (SyncableContainer)abstractContainerMenu;
            if (player.f_36096_.f_38840_ == windowId) {
                data.forEach(container::handleData);
            }
        }
    }

    public static void handleUpdateMachinesPacket(Map<ResourceLocation, CustomMachine> machines) {
        CustomMachinery.MACHINES.clear();
        CustomMachinery.MACHINES.putAll(machines);
        Minecraft mc = Minecraft.m_91087_();
        CreativeModeTab.ItemDisplayParameters params = new CreativeModeTab.ItemDisplayParameters(mc.f_91074_.f_108617_.m_247016_(), mc.f_91074_.m_36337_() && (Boolean)mc.f_91066_.m_257871_().m_231551_() != false, (HolderLookup.Provider)mc.f_91073_.m_9598_());
        ((CreativeModeTab)Registration.CUSTOM_MACHINE_TAB.get()).m_269498_(params);
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof MachineCreationScreen) {
            MachineCreationScreen creationScreen = (MachineCreationScreen)screen;
            creationScreen.reloadList();
        }
    }

    public static void handleUpdateMachineAppearancePacket(BlockPos pos, @Nullable MachineAppearance appearance) {
        BlockEntity tile;
        if (Minecraft.m_91087_().f_91073_ != null && (tile = Minecraft.m_91087_().f_91073_.m_7702_(pos)) instanceof CustomMachineTile) {
            CustomMachineTile machineTile = (CustomMachineTile)tile;
            machineTile.setCustomAppearance(appearance);
            machineTile.refreshClientData();
            Minecraft.m_91087_().f_91073_.m_7260_(pos, machineTile.m_58900_(), machineTile.m_58900_(), 3);
        }
    }

    public static void handleUpdateMachineGuiElementsPacket(BlockPos pos, List<IGuiElement> elements) {
        BlockEntity tile;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && (tile = mc.f_91073_.m_7702_(pos)) instanceof CustomMachineTile) {
            CustomMachineTile machineTile = (CustomMachineTile)tile;
            machineTile.setCustomGuiElements(elements);
            Screen screen = mc.f_91080_;
            if (screen instanceof CustomMachineScreen) {
                CustomMachineScreen screen2 = (CustomMachineScreen)screen;
                screen2.m_6574_(mc, mc.m_91268_().m_85445_(), mc.m_91268_().m_85446_());
                ((CustomMachineContainer)screen2.m_6262_()).init();
            }
        }
    }

    public static void handleOpenCreationScreenPacket() {
        Minecraft.m_91087_().m_91152_((Screen)new MachineCreationScreen());
    }

    public static void handleOpenEditScreenPacket(ResourceLocation machineId) {
        CustomMachine machine = CustomMachinery.MACHINES.get(machineId);
        if (machine != null) {
            Minecraft.m_91087_().m_91152_((Screen)new MachineEditScreen(new MachineCreationScreen(), 288, 210, new CustomMachineBuilder(machine)));
        }
    }
}

