/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.api.requirement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.IMachineComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.DisplayInfoTemplate;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.impl.codec.RegistrarCodec;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public interface IRequirement<T extends IMachineComponent> {
    public static final NamedCodec<IRequirement<?>> CODEC = NamedCodec.record(iRequirementInstance -> iRequirementInstance.group(RegistrarCodec.REQUIREMENT.dispatch(IRequirement::getType, RequirementType::getCodec, "Requirement").forGetter(requirement -> requirement), DisplayInfoTemplate.CODEC.optionalFieldOf("info").forGetter(requirement -> Optional.ofNullable(requirement.getDisplayInfoTemplate()))).apply((Applicative)iRequirementInstance, (requirement, info) -> {
        info.ifPresent(requirement::setDisplayInfoTemplate);
        return requirement;
    }), "Requirement");

    public RequirementType<? extends IRequirement<?>> getType();

    public MachineComponentType<T> getComponentType();

    public boolean test(T var1, ICraftingContext var2);

    public CraftingResult processStart(T var1, ICraftingContext var2);

    public CraftingResult processEnd(T var1, ICraftingContext var2);

    public RequirementIOMode getMode();

    public void setDisplayInfoTemplate(DisplayInfoTemplate var1);

    @Nullable
    public DisplayInfoTemplate getDisplayInfoTemplate();

    default public void getDisplayInfo(IDisplayInfo info) {
    }
}

