/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.api.network;

import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.api.network.DataType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public interface IData<T> {
    public DataType<?, T> getType();

    public short getID();

    public T getValue();

    default public void writeData(FriendlyByteBuf buffer) {
        if (this.getType().getId() == null) {
            throw new IllegalStateException("Attempting to write invalid data to Custom Machine container syncing packet : " + this.getType().toString() + " is not registered !");
        }
        buffer.m_130085_(this.getType().getId());
        buffer.writeShort((int)this.getID());
    }

    public static IData<?> readData(FriendlyByteBuf buffer) {
        ResourceLocation typeId = buffer.m_130281_();
        DataType type = (DataType)ICustomMachineryAPI.INSTANCE.dataRegistrar().get(typeId);
        if (type == null) {
            throw new IllegalStateException("Attempting to read invalid IData : " + typeId + " is not a valid registered DataType !");
        }
        short id = buffer.readShort();
        return type.readData(id, buffer);
    }
}

