/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.api.integration.jei;

import com.mojang.serialization.DataResult;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.machine.ICustomMachine;
import fr.frinn.custommachinery.impl.codec.FieldCodec;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface IDisplayInfo {
    default public IDisplayInfo addTooltip(Component text) {
        return this.addTooltip(text, TooltipPredicate.ALWAYS);
    }

    public IDisplayInfo addTooltip(Component var1, TooltipPredicate var2);

    default public IDisplayInfo setTextureIcon(ResourceLocation texture) {
        return this.setTextureIcon(texture, 16, 16, 0, 0);
    }

    default public IDisplayInfo setTextureIcon(ResourceLocation texture, int width, int height) {
        return this.setTextureIcon(texture, width, height, 0, 0);
    }

    public IDisplayInfo setTextureIcon(ResourceLocation var1, int var2, int var3, int var4, int var5);

    public IDisplayInfo setSpriteIcon(ResourceLocation var1, ResourceLocation var2);

    default public IDisplayInfo setItemIcon(Item item) {
        return this.setItemIcon(item.m_7968_());
    }

    public IDisplayInfo setItemIcon(ItemStack var1);

    public void setClickAction(ClickAction var1);

    @FunctionalInterface
    public static interface TooltipPredicate {
        public static final TooltipPredicate ALWAYS = (player, advancedTooltips) -> true;
        public static final TooltipPredicate ADVANCED = (player, advancedTooltips) -> advancedTooltips;
        public static final TooltipPredicate CREATIVE = (player, advancedTooltips) -> player.m_150110_().f_35937_;
        public static final NamedCodec<TooltipPredicate> CODEC = NamedCodec.STRING.comapFlatMap(s -> {
            String predicate;
            return switch (predicate = FieldCodec.toSnakeCase(s)) {
                case "advanced" -> DataResult.success((Object)ADVANCED);
                case "creative" -> DataResult.success((Object)CREATIVE);
                case "always" -> DataResult.success((Object)ALWAYS);
                default -> DataResult.error(() -> "Invalid tooltip predicate: " + s);
            };
        }, predicate -> predicate == ADVANCED ? "advanced" : (predicate == CREATIVE ? "creative" : "always"), "Tooltip predicate");

        public boolean shouldDisplay(Player var1, boolean var2);
    }

    public static interface ClickAction {
        public void handleClick(ICustomMachine var1, IMachineRecipe var2, int var3);
    }
}

