/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.api.codec;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import dev.architectury.registry.registries.Registrar;
import fr.frinn.custommachinery.impl.codec.DefaultOptionalFieldCodec;
import fr.frinn.custommachinery.impl.codec.EnhancedDispatchCodec;
import fr.frinn.custommachinery.impl.codec.EnhancedEitherCodec;
import fr.frinn.custommachinery.impl.codec.EnhancedListCodec;
import fr.frinn.custommachinery.impl.codec.EnumCodec;
import fr.frinn.custommachinery.impl.codec.EnumMapCodec;
import fr.frinn.custommachinery.impl.codec.FieldCodec;
import fr.frinn.custommachinery.impl.codec.NamedMapCodec;
import fr.frinn.custommachinery.impl.codec.NamedRecordCodec;
import fr.frinn.custommachinery.impl.codec.NumberCodec;
import fr.frinn.custommachinery.impl.codec.OptionalFieldCodec;
import fr.frinn.custommachinery.impl.codec.PairCodec;
import fr.frinn.custommachinery.impl.codec.RegistrarCodec;
import fr.frinn.custommachinery.impl.codec.UnboundedMapCodec;
import io.netty.handler.codec.EncoderException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public interface NamedCodec<A> {
    public static final NamedCodec<Boolean> BOOL = new NamedCodec<Boolean>(){

        @Override
        public <T> DataResult<Pair<Boolean, T>> decode(DynamicOps<T> ops, T input) {
            DataResult result = ops.getBooleanValue(input);
            if (result.result().isPresent()) {
                return result.map(b -> Pair.of((Object)b, (Object)ops.empty()));
            }
            DataResult stringResult = ops.getStringValue(input);
            if (stringResult.result().isPresent()) {
                String s = (String)stringResult.result().get();
                if (s.equalsIgnoreCase("true")) {
                    return DataResult.success((Object)Pair.of((Object)true, (Object)ops.empty()));
                }
                if (s.equalsIgnoreCase("false")) {
                    return DataResult.success((Object)Pair.of((Object)false, (Object)ops.empty()));
                }
            }
            return result.map(b -> Pair.of((Object)b, (Object)input));
        }

        @Override
        public <T> DataResult<T> encode(DynamicOps<T> ops, Boolean input, T prefix) {
            return ops.mergeToPrimitive(prefix, ops.createBoolean(input.booleanValue()));
        }

        @Override
        public String name() {
            return "Boolean";
        }
    };
    public static final NamedCodec<Byte> BYTE = new NumberCodec<Byte>(){

        @Override
        public <T> DataResult<Byte> parse(DynamicOps<T> ops, T input) {
            return ops.getNumberValue(input).map(Number::byteValue);
        }

        @Override
        public Byte fromString(String s) throws NumberFormatException {
            return Byte.parseByte(s);
        }

        @Override
        public String name() {
            return "Byte";
        }
    };
    public static final NamedCodec<Short> SHORT = new NumberCodec<Short>(){

        @Override
        public <T> DataResult<Short> parse(DynamicOps<T> ops, T input) {
            return ops.getNumberValue(input).map(Number::shortValue);
        }

        @Override
        public Short fromString(String s) throws NumberFormatException {
            return Short.parseShort(s);
        }

        @Override
        public String name() {
            return "Short";
        }
    };
    public static final NamedCodec<Integer> INT = new NumberCodec<Integer>(){

        @Override
        public <T> DataResult<Integer> parse(DynamicOps<T> ops, T input) {
            return ops.getNumberValue(input).map(Number::intValue);
        }

        @Override
        public Integer fromString(String s) throws NumberFormatException {
            return Integer.parseInt(s);
        }

        @Override
        public String name() {
            return "Integer";
        }
    };
    public static final NamedCodec<Long> LONG = new NumberCodec<Long>(){

        @Override
        public <T> DataResult<Long> parse(DynamicOps<T> ops, T input) {
            return ops.getNumberValue(input).map(Number::longValue);
        }

        @Override
        public Long fromString(String s) throws NumberFormatException {
            return Long.parseLong(s);
        }

        @Override
        public String name() {
            return "Long";
        }
    };
    public static final NamedCodec<Float> FLOAT = new NumberCodec<Float>(){

        @Override
        public <T> DataResult<Float> parse(DynamicOps<T> ops, T input) {
            return ops.getNumberValue(input).map(Number::floatValue);
        }

        @Override
        public Float fromString(String s) throws NumberFormatException {
            return Float.valueOf(Float.parseFloat(s));
        }

        @Override
        public String name() {
            return "Float";
        }
    };
    public static final NamedCodec<Double> DOUBLE = new NumberCodec<Double>(){

        @Override
        public <T> DataResult<Double> parse(DynamicOps<T> ops, T input) {
            return ops.getNumberValue(input).map(Number::doubleValue);
        }

        @Override
        public Double fromString(String s) throws NumberFormatException {
            return Double.parseDouble(s);
        }

        @Override
        public String name() {
            return "Double";
        }
    };
    public static final NamedCodec<String> STRING = NamedCodec.of(Codec.STRING);
    public static final NamedCodec<ByteBuffer> BYTE_BUFFER = NamedCodec.of(Codec.BYTE_BUFFER);
    public static final NamedCodec<IntStream> INT_STREAM = NamedCodec.of(Codec.INT_STREAM);
    public static final NamedCodec<LongStream> LONG_STREAM = NamedCodec.of(Codec.LONG_STREAM);
    public static final NamedCodec<DoubleStream> DOUBLE_STREAM = new NamedCodec<DoubleStream>(){

        @Override
        public <T> DataResult<Pair<DoubleStream, T>> decode(DynamicOps<T> ops, T input) {
            return ops.getStream(input).flatMap(stream -> {
                List list = stream.toList();
                if (list.stream().allMatch(element -> ops.getNumberValue(element).result().isPresent())) {
                    return DataResult.success((Object)list.stream().mapToDouble(element -> ((Number)ops.getNumberValue(element).result().get()).doubleValue()));
                }
                return DataResult.error(() -> "Some elements are not doubles: " + input);
            }).map(r -> Pair.of((Object)r, (Object)ops.empty()));
        }

        @Override
        public <T> DataResult<T> encode(DynamicOps<T> ops, DoubleStream input, T prefix) {
            return ops.mergeToPrimitive(prefix, ops.createList(input.mapToObj(arg_0 -> ops.createDouble(arg_0))));
        }

        @Override
        public String name() {
            return "DoubleStream";
        }
    };
    public static final NamedCodec<Dynamic<?>> PASSTHROUGH = new NamedCodec<Dynamic<?>>(){

        @Override
        public <T> DataResult<Pair<Dynamic<?>, T>> decode(DynamicOps<T> ops, T input) {
            return DataResult.success((Object)Pair.of((Object)new Dynamic(ops, input), (Object)ops.empty()));
        }

        @Override
        public <T> DataResult<T> encode(DynamicOps<T> ops, Dynamic<?> input, T prefix) {
            if (input.getValue() == input.getOps().empty()) {
                return DataResult.success(prefix, (Lifecycle)Lifecycle.experimental());
            }
            Object casted = input.convert(ops).getValue();
            if (prefix == ops.empty()) {
                return DataResult.success((Object)casted, (Lifecycle)Lifecycle.experimental());
            }
            DataResult toMap = ops.getMap(casted).flatMap(map -> ops.mergeToMap(prefix, map));
            return toMap.result().map(DataResult::success).orElseGet(() -> {
                DataResult toList = ops.getStream(casted).flatMap(stream -> ops.mergeToList(prefix, stream.collect(Collectors.toList())));
                return toList.result().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Don't know how to merge " + prefix + " and " + casted, (Object)prefix, (Lifecycle)Lifecycle.experimental()));
            });
        }

        @Override
        public String name() {
            return "passthrough";
        }
    };

    public static <A> NamedCodec<A> of(Codec<A> codec) {
        return NamedCodec.of(codec, codec.toString());
    }

    public static <A> NamedCodec<A> of(final Codec<A> codec, final String name) {
        return new NamedCodec<A>(){

            @Override
            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
                return codec.decode(ops, input);
            }

            @Override
            public <T> DataResult<T> encode(DynamicOps<T> ops, A input, T prefix) {
                return codec.encode(input, ops, prefix);
            }

            @Override
            public String name() {
                return name;
            }

            public String toString() {
                return name;
            }
        };
    }

    public static <A> NamedCodec<List<A>> list(NamedCodec<A> codec) {
        return EnhancedListCodec.of(codec);
    }

    public static <A> NamedCodec<List<A>> list(NamedCodec<A> codec, String name) {
        return EnhancedListCodec.of(codec, name);
    }

    public static <F, S> NamedCodec<Either<F, S>> either(NamedCodec<F> first, NamedCodec<S> second) {
        return EnhancedEitherCodec.of(first, second);
    }

    public static <F, S> NamedCodec<Either<F, S>> either(NamedCodec<F> first, NamedCodec<S> second, String name) {
        return EnhancedEitherCodec.of(first, second, name);
    }

    public static <E extends Enum<E>> NamedCodec<E> enumCodec(Class<E> enumClass) {
        return EnumCodec.of(enumClass);
    }

    public static <E extends Enum<E>> NamedCodec<E> enumCodec(Class<E> enumClass, String name) {
        return EnumCodec.of(enumClass, name);
    }

    public static <A> NamedCodec<A> registrar(Registrar<A> registrar) {
        return RegistrarCodec.of(registrar, false);
    }

    public static <K extends Enum<K>, V> NamedMapCodec<Map<K, V>> enumMap(Class<K> keyEnumClass, NamedCodec<V> valueCodec) {
        return EnumMapCodec.of(keyEnumClass, valueCodec);
    }

    public static <K extends Enum<K>, V> NamedMapCodec<Map<K, V>> enumMap(Class<K> keyEnumClass, NamedCodec<V> valueCodec, @Nullable V defaultValue) {
        return EnumMapCodec.of(keyEnumClass, valueCodec, defaultValue);
    }

    public static <K extends Enum<K>, V> NamedMapCodec<Map<K, V>> enumMap(Class<K> keyEnumClass, NamedCodec<V> valueCodec, String name) {
        return EnumMapCodec.of(keyEnumClass, valueCodec, name);
    }

    public static <K extends Enum<K>, V> NamedMapCodec<Map<K, V>> enumMap(Class<K> keyEnumClass, NamedCodec<V> valueCodec, @Nullable V defaultValue, String name) {
        return EnumMapCodec.of(keyEnumClass, valueCodec, defaultValue, name);
    }

    public static <A> NamedCodec<A> unit(A defaultValue) {
        return NamedCodec.unit(defaultValue, defaultValue.toString());
    }

    public static <A> NamedCodec<A> unit(A defaultValue, String name) {
        return NamedCodec.unit(() -> defaultValue, name);
    }

    public static <A> NamedCodec<A> unit(final Supplier<A> defaultValue, final String name) {
        return new NamedCodec<A>(){

            @Override
            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
                return DataResult.success((Object)Pair.of(defaultValue.get(), (Object)ops.empty()));
            }

            @Override
            public <T> DataResult<T> encode(DynamicOps<T> ops, A input, T prefix) {
                return ops.mapBuilder().build(prefix);
            }

            @Override
            public String name() {
                return name;
            }
        };
    }

    public static <O> NamedMapCodec<O> record(Function<NamedRecordCodec.Instance<O>, ? extends App<NamedRecordCodec.Mu<O>, O>> builder, String name) {
        return NamedRecordCodec.create(builder, name);
    }

    public static <N extends Number> Function<N, DataResult<N>> checkRange(N minInclusive, N maxInclusive) {
        return value -> {
            if (((Comparable)((Object)value)).compareTo(minInclusive) >= 0 && ((Comparable)((Object)value)).compareTo(maxInclusive) <= 0) {
                return DataResult.success((Object)value);
            }
            return DataResult.error(() -> "Value " + value + " outside of range [" + minInclusive + ":" + maxInclusive + "]", (Object)value);
        };
    }

    public static NamedCodec<Integer> intRange(int minInclusive, int maxInclusive) {
        Function<Integer, DataResult<Integer>> checker = NamedCodec.checkRange(minInclusive, maxInclusive);
        return INT.flatXmap(checker, checker, "Range: [" + minInclusive + "," + maxInclusive + "]");
    }

    public static NamedCodec<Float> floatRange(float minInclusive, float maxInclusive) {
        Function<Float, DataResult<Float>> checker = NamedCodec.checkRange(Float.valueOf(minInclusive), Float.valueOf(maxInclusive));
        return FLOAT.flatXmap(checker, checker, "Range: [" + minInclusive + "," + maxInclusive + "]");
    }

    public static NamedCodec<Double> doubleRange(double minInclusive, double maxInclusive) {
        Function<Double, DataResult<Double>> checker = NamedCodec.checkRange(minInclusive, maxInclusive);
        return DOUBLE.flatXmap(checker, checker, "Range: [" + minInclusive + "," + maxInclusive + "]");
    }

    public static NamedCodec<Long> longRange(long minInclusive, long maxInclusive) {
        Function<Long, DataResult<Long>> checker = NamedCodec.checkRange(minInclusive, maxInclusive);
        return LONG.flatXmap(checker, checker, "Range: [" + minInclusive + "," + maxInclusive + "]");
    }

    public static <A> NamedCodec<A> lazy(final Supplier<NamedCodec<A>> supplier, final String name) {
        return new NamedCodec<A>(){

            @Override
            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
                return ((NamedCodec)supplier.get()).decode(ops, input);
            }

            @Override
            public <T> DataResult<T> encode(DynamicOps<T> ops, A input, T prefix) {
                return ((NamedCodec)supplier.get()).encode(ops, input, prefix);
            }

            @Override
            public String name() {
                return name;
            }
        };
    }

    public static <K, V> UnboundedMapCodec<K, V> unboundedMap(NamedCodec<K> keyCodec, NamedCodec<V> valueCodec, String name) {
        return UnboundedMapCodec.of(keyCodec, valueCodec, name);
    }

    public static <F, S> PairCodec<F, S> pair(NamedCodec<F> first, NamedCodec<S> second) {
        return PairCodec.of(first, second);
    }

    public static <T> NamedCodec<T> fromJson(Function<JsonElement, T> parser, Function<T, JsonElement> encoder, String name) {
        return PASSTHROUGH.flatXmap(d -> {
            JsonElement json = NamedCodec.getJson(d);
            try {
                return DataResult.success(parser.apply(json));
            }
            catch (JsonSyntaxException e) {
                return DataResult.error(e::getMessage);
            }
        }, t -> {
            try {
                JsonElement json = (JsonElement)encoder.apply(t);
                return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json));
            }
            catch (JsonSyntaxException e) {
                return DataResult.error(e::getMessage);
            }
        }, name);
    }

    public static <U> JsonElement getJson(Dynamic<?> dynamic) {
        Dynamic<?> typed = dynamic;
        return typed.getValue() instanceof JsonElement ? (JsonElement)typed.getValue() : (JsonElement)typed.getOps().convertTo((DynamicOps)JsonOps.INSTANCE, typed.getValue());
    }

    public static DataResult<double[]> validateDoubleStreamSize(DoubleStream stream, int size) {
        double[] array = stream.limit(size + 1).toArray();
        if (array.length != size) {
            String s = "Input is not a list of " + size + " doubles";
            return array.length >= size ? DataResult.error(() -> s, (Object)Arrays.copyOf(array, size)) : DataResult.error(() -> s);
        }
        return DataResult.success((Object)array);
    }

    public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> var1, T var2);

    default public <T> DataResult<A> read(DynamicOps<T> ops, T input) {
        return this.decode(ops, input).map(Pair::getFirst);
    }

    public <T> DataResult<T> encode(DynamicOps<T> var1, A var2, T var3);

    default public <T> DataResult<T> encodeStart(DynamicOps<T> ops, A input) {
        return this.encode(ops, input, ops.empty());
    }

    public String name();

    default public Codec<A> codec() {
        return new Codec<A>(){

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
                return NamedCodec.this.decode(ops, input);
            }

            public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
                return NamedCodec.this.encode(ops, input, prefix);
            }

            public String toString() {
                return NamedCodec.this.name();
            }
        };
    }

    default public NamedCodec<List<A>> listOf() {
        return NamedCodec.list(this);
    }

    default public NamedCodec<List<A>> listOf(String name) {
        return NamedCodec.list(this, name);
    }

    default public <E> NamedMapCodec<E> dispatch(Function<? super E, ? extends A> type, Function<? super A, ? extends NamedCodec<? extends E>> valueCodecGetter, String name) {
        return this.dispatch("type", type, valueCodecGetter, name);
    }

    default public <E> NamedMapCodec<E> dispatch(String typeKey, Function<? super E, ? extends A> type, Function<? super A, ? extends NamedCodec<? extends E>> valueCodecGetter, String name) {
        return EnhancedDispatchCodec.of(typeKey, this, type.andThen(DataResult::success), valueCodecGetter.andThen(DataResult::success), name);
    }

    default public <S> NamedCodec<S> xmap(final Function<? super A, ? extends S> to, final Function<? super S, ? extends A> from, final String name) {
        return new NamedCodec<S>(){

            @Override
            public <T> DataResult<Pair<S, T>> decode(DynamicOps<T> ops, T input) {
                return NamedCodec.this.decode(ops, input).map(p -> p.mapFirst(to));
            }

            @Override
            public <T> DataResult<T> encode(DynamicOps<T> ops, S input, T prefix) {
                return NamedCodec.this.encode(ops, from.apply(input), prefix);
            }

            @Override
            public String name() {
                return name;
            }
        };
    }

    default public <S> NamedCodec<S> comapFlatMap(final Function<? super A, ? extends DataResult<? extends S>> to, final Function<? super S, ? extends A> from, final String name) {
        return new NamedCodec<S>(){

            @Override
            public <T> DataResult<Pair<S, T>> decode(DynamicOps<T> ops, T input) {
                return NamedCodec.this.decode(ops, input).flatMap(p -> ((DataResult)to.apply(p.getFirst())).map(r -> Pair.of((Object)r, (Object)p.getSecond())));
            }

            @Override
            public <T> DataResult<T> encode(DynamicOps<T> ops, S input, T prefix) {
                return NamedCodec.this.encode(ops, from.apply(input), prefix);
            }

            @Override
            public String name() {
                return name;
            }
        };
    }

    default public <S> NamedCodec<S> flatComapMap(final Function<? super A, ? extends S> to, final Function<? super S, ? extends DataResult<? extends A>> from, final String name) {
        return new NamedCodec<S>(){

            @Override
            public <T> DataResult<Pair<S, T>> decode(DynamicOps<T> ops, T input) {
                return NamedCodec.this.decode(ops, input).map(p -> p.mapFirst(to));
            }

            @Override
            public <T> DataResult<T> encode(DynamicOps<T> ops, S input, T prefix) {
                return ((DataResult)from.apply(input)).flatMap(a -> NamedCodec.this.encode(ops, a, prefix));
            }

            @Override
            public String name() {
                return name;
            }
        };
    }

    default public <S> NamedCodec<S> flatXmap(final Function<? super A, ? extends DataResult<? extends S>> to, final Function<? super S, ? extends DataResult<? extends A>> from, final String name) {
        return new NamedCodec<S>(){

            @Override
            public <T> DataResult<Pair<S, T>> decode(DynamicOps<T> ops, T input) {
                return NamedCodec.this.decode(ops, input).flatMap(p -> ((DataResult)to.apply(p.getFirst())).map(r -> Pair.of((Object)r, (Object)p.getSecond())));
            }

            @Override
            public <T> DataResult<T> encode(DynamicOps<T> ops, S input, T prefix) {
                return ((DataResult)from.apply(input)).flatMap(a -> NamedCodec.this.encode(ops, a, prefix));
            }

            @Override
            public String name() {
                return name;
            }
        };
    }

    default public NamedMapCodec<A> fieldOf(String fieldName) {
        return FieldCodec.of(fieldName, this, this.name());
    }

    default public NamedMapCodec<Optional<A>> optionalFieldOf(String fieldName) {
        return OptionalFieldCodec.of(fieldName, this, this.name());
    }

    default public NamedMapCodec<A> optionalFieldOf(String fieldName, A defaultValue) {
        return this.optionalFieldOf(fieldName, () -> defaultValue);
    }

    default public NamedMapCodec<A> optionalFieldOf(String fieldName, Supplier<A> defaultValue) {
        return DefaultOptionalFieldCodec.of(fieldName, this, defaultValue, this.name());
    }

    default public void toNetwork(A input, FriendlyByteBuf buf) {
        DataResult result = this.encodeStart((DynamicOps)NbtOps.f_128958_, input);
        result.error().ifPresent(error -> {
            throw new EncoderException(String.format("Failed to encode: %s\nError: %s\nInput: %s", this.name(), error.message(), input.toString()));
        });
        Tag tag = (Tag)result.result().orElseThrow();
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            buf.m_130079_(compoundTag);
        } else {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128365_("custommachinery$special_nbt_key", tag);
            buf.m_130079_(compoundTag);
        }
    }

    default public A fromNetwork(FriendlyByteBuf buf) {
        CompoundTag tag = buf.m_130261_();
        DataResult<A> result = tag != null && tag.m_128441_("custommachinery$special_nbt_key") ? this.read((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("custommachinery$special_nbt_key")) : this.read((DynamicOps)NbtOps.f_128958_, (Object)tag);
        result.error().ifPresent(error -> {
            throw new EncoderException(String.format("Failed to decode: %s\nError: %s\nInput: %S", this.name(), error.message(), tag));
        });
        return (A)result.result().orElseThrow();
    }

    default public A copy(A input) {
        return (A)this.read((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)this.encodeStart((DynamicOps)JsonOps.INSTANCE, input).result().orElseThrow())).result().orElseThrow();
    }
}

