/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.data;

import com.google.common.collect.Multimap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import se.mickelus.tetra.module.Priority;
import se.mickelus.tetra.module.data.AspectData;
import se.mickelus.tetra.module.data.EffectData;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.data.ItemProperties;
import se.mickelus.tetra.module.data.MaterialVariantData;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.module.data.UniqueVariantData;
import se.mickelus.tetra.properties.AttributeHelper;

@ParametersAreNonnullByDefault
public class VariantData
extends ItemProperties {
    private static final VariantData defaultValues = new VariantData();
    public boolean replace = false;
    public String key;
    public String category = "misc";
    public Multimap<Attribute, AttributeModifier> attributes;
    public ToolData tools;
    public EffectData effects;
    public AspectData aspects;
    public Priority namePriority = Priority.BASE;
    public Priority prefixPriority = Priority.BASE;
    public GlyphData glyph = new GlyphData();
    public ModuleModel[] models = new ModuleModel[0];
    public int magicCapacity = 0;

    public static VariantData merge(VariantData a, VariantData b) {
        if (b.replace) {
            return b;
        }
        VariantData result = new VariantData();
        result.durability = !Objects.equals(b.durability, VariantData.defaultValues.durability) ? b.durability : a.durability;
        result.durabilityMultiplier = !Objects.equals(Float.valueOf(b.durabilityMultiplier), Float.valueOf(VariantData.defaultValues.durabilityMultiplier)) ? b.durabilityMultiplier : a.durabilityMultiplier;
        result.integrity = !Objects.equals(b.integrity, VariantData.defaultValues.integrity) ? b.integrity : a.integrity;
        result.integrityMultiplier = !Objects.equals(Float.valueOf(b.integrityMultiplier), Float.valueOf(VariantData.defaultValues.integrityMultiplier)) ? b.integrityMultiplier : a.integrityMultiplier;
        result.key = !Objects.equals(b.key, VariantData.defaultValues.key) ? b.key : a.key;
        result.category = !Objects.equals(b.category, VariantData.defaultValues.category) ? b.category : a.category;
        result.attributes = AttributeHelper.overwrite(a.attributes, b.attributes);
        result.tools = ToolData.overwrite(a.tools, b.tools);
        result.effects = EffectData.overwrite(a.effects, b.effects);
        result.aspects = AspectData.overwrite(a.aspects, b.aspects);
        result.namePriority = b.namePriority != VariantData.defaultValues.namePriority ? b.namePriority : a.namePriority;
        result.prefixPriority = b.prefixPriority != VariantData.defaultValues.prefixPriority ? b.prefixPriority : a.prefixPriority;
        result.glyph = !b.glyph.equals(VariantData.defaultValues.glyph) ? b.glyph : a.glyph;
        result.models = b.models.length != 0 ? b.models : a.models;
        result.magicCapacity = b.magicCapacity != VariantData.defaultValues.magicCapacity ? b.magicCapacity : a.magicCapacity;
        return result;
    }

    public static class Deserializer
    implements JsonDeserializer<VariantData> {
        public VariantData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            if (jsonObject.has("materials")) {
                return (VariantData)context.deserialize(json, MaterialVariantData.class);
            }
            return (VariantData)context.deserialize(json, UniqueVariantData.class);
        }
    }
}

