/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.levelgen;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.registries.RegistryObject;
import se.mickelus.tetra.blocks.multischematic.MultiblockSchematicBlock;
import se.mickelus.tetra.blocks.multischematic.PrimaryMultiblockSchematicBlock;
import se.mickelus.tetra.blocks.multischematic.RuinedMultiblockSchematicBlock;
import se.mickelus.tetra.util.StreamHelper;

@ParametersAreNonnullByDefault
public class MultiblockSchematicProcessor
extends StructureProcessor {
    public static final MultiblockSchematicProcessor INSTANCE = new MultiblockSchematicProcessor();
    public static final Codec<MultiblockSchematicProcessor> codec = Codec.unit(() -> INSTANCE);
    public static RegistryObject<StructureProcessorType<?>> type;

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader world, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo $, StructureTemplate.StructureBlockInfo blockInfo, StructurePlaceSettings placementSettings, @Nullable StructureTemplate template) {
        Block block = blockInfo.f_74676_().m_60734_();
        if (block instanceof MultiblockSchematicBlock) {
            MultiblockSchematicBlock block2 = (MultiblockSchematicBlock)block;
            Random random = new Random(Mth.m_14057_((Vec3i)pos));
            int size = block2.height * block2.width;
            boolean isRuined = IntStream.range(0, size).boxed().collect(StreamHelper.toShuffledList(random)).stream().limit((int)Math.ceil((double)size * 0.25)).anyMatch(index -> index == block.y * block.width + block.x);
            if (isRuined) {
                BlockState newState = (BlockState)((RuinedMultiblockSchematicBlock)block2.ruinedRef.get()).m_49966_().m_61124_((Property)RuinedMultiblockSchematicBlock.facingProp, (Comparable)((Direction)blockInfo.f_74676_().m_61143_((Property)MultiblockSchematicBlock.facingProp)));
                return new StructureTemplate.StructureBlockInfo(blockInfo.f_74675_(), newState, blockInfo.f_74677_());
            }
            if (blockInfo.f_74676_().m_60734_() instanceof PrimaryMultiblockSchematicBlock) {
                BlockState newState = (BlockState)blockInfo.f_74676_().m_61124_((Property)PrimaryMultiblockSchematicBlock.complete, (Comparable)Boolean.valueOf(false));
                return new StructureTemplate.StructureBlockInfo(blockInfo.f_74675_(), newState, blockInfo.f_74677_());
            }
        }
        return blockInfo;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)type.get();
    }
}

