/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HolosphereEntryData;

public class HolosphereEntryStore
implements ResourceManagerReloadListener {
    protected static final String jsonExtension = ".json";
    private static final String directory = "holosphere_entries";
    private static final Logger logger = LogManager.getLogger();
    public static HolosphereEntryStore instance;
    private Map<String, HolosphereEntryData> entries = Collections.emptyMap();
    private Runnable listener;

    public HolosphereEntryStore() {
        instance = this;
    }

    public void setListener(Runnable listener) {
        this.listener = listener;
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.entries = this.parsePentries();
        logger.info("Loaded {} holosphere entries", (Object)this.entries.size());
        if (this.listener != null) {
            this.listener.run();
        }
    }

    public Map<String, HolosphereEntryData> getEntries() {
        return this.entries;
    }

    private Map<String, HolosphereEntryData> parsePentries() {
        return Minecraft.m_91087_().m_91098_().m_214159_(directory, rl -> rl.m_135815_().endsWith(jsonExtension)).entrySet().stream().filter(entry -> "tetra".equals(((ResourceLocation)entry.getKey()).m_135827_())).map(entry -> this.parseEntry((ResourceLocation)entry.getKey(), (Resource)entry.getValue())).filter(Objects::nonNull).filter(entry -> entry.item instanceof IModularItem).collect(Collectors.toMap(entry -> entry.key, entry -> entry));
    }

    private HolosphereEntryData parseEntry(ResourceLocation resourceLocation, Resource resource) {
        HolosphereEntryData holosphereEntryData;
        block8: {
            BufferedReader reader = resource.m_215508_();
            try {
                HolosphereEntryData result = (HolosphereEntryData)GsonHelper.m_13776_((Gson)DataManager.gson, (Reader)reader, HolosphereEntryData.class);
                result.key = resourceLocation.m_135815_().substring(directory.length() + 1, resourceLocation.m_135815_().length() - jsonExtension.length());
                holosphereEntryData = result;
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException | IOException e) {
                    logger.warn("Failed to parse holosphere entry from '{}': {}", (Object)resourceLocation, (Object)e);
                    return null;
                }
            }
            reader.close();
        }
        return holosphereEntryData;
    }
}

