/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.dynamic;

import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.gui.GuiModuleOffsets;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.items.modular.impl.dynamic.ArchetypeDefinition;
import se.mickelus.tetra.items.modular.impl.dynamic.ArchetypeSlotDefinition;

public class DynamicModularItem
extends ItemModularHandheld {
    public static final String identifier = "dynamic_handheld";
    public static final String typeKey = "archetype";

    public DynamicModularItem() {
        super(new Item.Properties().m_41487_(1).m_41486_());
    }

    public static String getArchetypeKey(@Nullable CompoundTag tag) {
        return Optional.ofNullable(tag).map(t -> t.m_128461_(typeKey)).orElse(null);
    }

    public static String getArchetypeKey(ItemStack itemStack) {
        return DynamicModularItem.getArchetypeKey(itemStack.m_41783_());
    }

    public static void setArchetypeKey(ItemStack itemStack, String key) {
        itemStack.m_41784_().m_128359_(typeKey, key);
    }

    protected Optional<ArchetypeDefinition> getDefinition(ItemStack itemStack) {
        return Optional.ofNullable(itemStack.m_41783_()).map(DynamicModularItem::getArchetypeKey).map(key -> new ResourceLocation("tetra", key)).map(rl -> (ArchetypeDefinition)DataManager.instance.archetypeData.getData(rl));
    }

    @Override
    public String[] getMajorModuleKeys(ItemStack itemStack) {
        return this.getDefinition(itemStack).map(ArchetypeDefinition::slots).map(slots -> (String[])Arrays.stream(slots).filter(ArchetypeSlotDefinition::major).map(ArchetypeSlotDefinition::key).toArray(String[]::new)).orElse(new String[0]);
    }

    @Override
    public String[] getMinorModuleKeys(ItemStack itemStack) {
        return this.getDefinition(itemStack).map(ArchetypeDefinition::slots).map(slots -> (String[])Arrays.stream(slots).filter(definition -> !definition.major()).map(ArchetypeSlotDefinition::key).toArray(String[]::new)).orElse(new String[0]);
    }

    @Override
    public String[] getRequiredModules(ItemStack itemStack) {
        return this.getDefinition(itemStack).map(ArchetypeDefinition::slots).map(slots -> (String[])Arrays.stream(slots).filter(ArchetypeSlotDefinition::required).map(ArchetypeSlotDefinition::key).toArray(String[]::new)).orElse(new String[0]);
    }

    @Override
    public boolean canGainHoneProgress(ItemStack itemStack) {
        return this.getDefinition(itemStack).map(ArchetypeDefinition::honeable).orElse(false);
    }

    @Override
    public int getHoneBase(ItemStack itemStack) {
        return this.getDefinition(itemStack).map(ArchetypeDefinition::honeBase).orElse(0);
    }

    @Override
    public int getHoneIntegrityMultiplier(ItemStack itemStack) {
        return this.getDefinition(itemStack).map(ArchetypeDefinition::honeIntegrityMultiplier).orElse(0);
    }

    @Override
    public GuiModuleOffsets getMajorGuiOffsets(ItemStack itemStack) {
        return this.getDefinition(itemStack).map(ArchetypeDefinition::slots).map(slots -> (ArchetypeSlotDefinition[])Arrays.stream(slots).filter(ArchetypeSlotDefinition::major).toArray(ArchetypeSlotDefinition[]::new)).map(GuiModuleOffsets::new).orElse(new GuiModuleOffsets(new int[0]));
    }

    @Override
    public GuiModuleOffsets getMinorGuiOffsets(ItemStack itemStack) {
        return this.getDefinition(itemStack).map(ArchetypeDefinition::slots).map(slots -> (ArchetypeSlotDefinition[])Arrays.stream(slots).filter(slot -> !slot.major()).toArray(ArchetypeSlotDefinition[]::new)).map(GuiModuleOffsets::new).orElse(new GuiModuleOffsets(new int[0]));
    }
}

