/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular;

import com.google.common.cache.Cache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.DigDurabilityEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.forgespi.Environment;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.mutil.network.AbstractPacket;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.Tooltips;
import se.mickelus.tetra.effect.ApplyUsageEffectsEvent;
import se.mickelus.tetra.effect.BloodboundEffect;
import se.mickelus.tetra.effect.CombustingEffect;
import se.mickelus.tetra.effect.EnderReverbEffect;
import se.mickelus.tetra.effect.FierySelfEffect;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.RavenousEffect;
import se.mickelus.tetra.effect.data.DataEffectsHandler;
import se.mickelus.tetra.effect.vexing.VexingEffect;
import se.mickelus.tetra.event.ModularItemDamageEvent;
import se.mickelus.tetra.gui.GuiModuleOffsets;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.Priority;
import se.mickelus.tetra.module.data.EffectData;
import se.mickelus.tetra.module.data.ImprovementData;
import se.mickelus.tetra.module.data.ItemProperties;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.data.SynergyData;
import se.mickelus.tetra.module.improvement.HonePacket;
import se.mickelus.tetra.module.schematic.RepairDefinition;
import se.mickelus.tetra.properties.AttributeHelper;

public interface IModularItem {
    public static final Logger logger = LogManager.getLogger();
    public static final GuiModuleOffsets[] defaultMajorOffsets = new GuiModuleOffsets[]{new GuiModuleOffsets(new int[0]), new GuiModuleOffsets(4, 0), new GuiModuleOffsets(4, 0, 4, 18), new GuiModuleOffsets(4, 0, 4, 18, -4, 0), new GuiModuleOffsets(4, 0, 4, 18, -4, 0, -4, 18)};
    public static final GuiModuleOffsets[] defaultMinorOffsets = new GuiModuleOffsets[]{new GuiModuleOffsets(new int[0]), new GuiModuleOffsets(-21, 12), new GuiModuleOffsets(-18, 5, -18, 18), new GuiModuleOffsets(-12, -1, -21, 12, -12, 25)};
    public static final String identifierKey = "id";
    public static final String repairCountKey = "repairCount";
    public static final String cooledStrengthKey = "cooledStrength";
    public static final String honeProgressKey = "honing_progress";
    public static final String honeAvailableKey = "honing_available";
    public static final String honeCountKey = "honing_count";

    public static void updateIdentifier(ItemStack itemStack) {
        IModularItem.updateIdentifier(itemStack.m_41784_());
    }

    public static void updateIdentifier(CompoundTag nbt) {
        nbt.m_128359_(identifierKey, UUID.randomUUID().toString());
    }

    public static void putModuleInSlot(ItemStack itemStack, String slot, String module, String moduleVariantKey, String moduleVariant) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128359_(slot, module);
        tag.m_128359_(moduleVariantKey, moduleVariant);
    }

    public static void putModuleInSlot(ItemStack itemStack, String slot, String module, String moduleVariant) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128359_(slot, module);
        tag.m_128359_(module + "_material", moduleVariant);
    }

    public static int getIntegrityGain(ItemStack itemStack) {
        return CastOptional.cast((Object)itemStack.m_41720_(), IModularItem.class).map(item -> item.getPropertiesCached(itemStack)).map(properties -> properties.integrity).orElse(0);
    }

    public static int getIntegrityCost(ItemStack itemStack) {
        return CastOptional.cast((Object)itemStack.m_41720_(), IModularItem.class).map(item -> item.getPropertiesCached(itemStack)).map(properties -> properties.integrityUsage).orElse(0);
    }

    public static boolean isHoneable(ItemStack itemStack) {
        return Optional.ofNullable(itemStack.m_41783_()).map(tag -> tag.m_128441_(honeAvailableKey)).orElse(false);
    }

    public static int getHoningSeed(ItemStack itemStack) {
        return Optional.ofNullable(itemStack.m_41783_()).map(tag -> tag.m_128451_(honeCountKey)).orElse(0);
    }

    public static void removeHoneable(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null) {
            tag.m_128473_(honeAvailableKey);
            tag.m_128473_(honeProgressKey);
            tag.m_128405_(honeCountKey, tag.m_128451_(honeCountKey) + 1);
        }
    }

    public static String getImprovementName(String key, int level) {
        Object name = null;
        if (I18n.m_118936_((String)("tetra.improvement." + key + ".name"))) {
            name = I18n.m_118938_((String)("tetra.improvement." + key + ".name"), (Object[])new Object[0]);
        } else {
            String materialKey;
            String templateKey;
            int lastSlash = key.lastIndexOf("/");
            if (lastSlash != -1 && I18n.m_118936_((String)(templateKey = "tetra.improvement." + key.substring(0, lastSlash) + ".name")) && I18n.m_118936_((String)(materialKey = "tetra.material." + key.substring(lastSlash + 1) + ".prefix"))) {
                name = StringUtils.capitalize((String)I18n.m_118938_((String)templateKey, (Object[])new Object[]{I18n.m_118938_((String)materialKey, (Object[])new Object[0]).toLowerCase()}));
            }
            if (name == null) {
                name = "tetra.improvement." + key + ".name";
            }
        }
        if (level > 0) {
            name = (String)name + " " + I18n.m_118938_((String)("enchantment.level." + level), (Object[])new Object[0]);
        }
        return name;
    }

    public static String getImprovementDescription(String key) {
        String splitKey;
        if (I18n.m_118936_((String)("tetra.improvement." + key + ".description"))) {
            return I18n.m_118938_((String)("tetra.improvement." + key + ".description"), (Object[])new Object[0]);
        }
        int lastSlash = key.lastIndexOf("/");
        if (lastSlash != -1 && I18n.m_118936_((String)(splitKey = "tetra.improvement." + key.substring(0, lastSlash) + ".description"))) {
            return I18n.m_118938_((String)splitKey, (Object[])new Object[0]);
        }
        return "tetra.improvement." + key + ".description";
    }

    public static ItemStack removeAllEnchantments(ItemStack itemStack) {
        itemStack.m_41749_("Enchantments");
        itemStack.m_41749_("StoredEnchantments");
        Arrays.stream(((IModularItem)itemStack.m_41720_()).getMajorModules(itemStack)).filter(Objects::nonNull).forEach(module -> module.removeEnchantments(itemStack));
        IModularItem.updateIdentifier(itemStack);
        return itemStack;
    }

    public Item getItem();

    default public ItemStack getDefaultStack() {
        return new ItemStack((ItemLike)this.getItem());
    }

    @Nullable
    default public String getIdentifier(ItemStack itemStack) {
        if (itemStack.m_41782_()) {
            return itemStack.m_41783_().m_128461_(identifierKey);
        }
        return null;
    }

    default public String getDataCacheKey(ItemStack itemStack) {
        return Optional.ofNullable(this.getIdentifier(itemStack)).filter(id -> !id.isEmpty()).orElseGet(() -> itemStack.m_41782_() ? itemStack.m_41783_().toString() : "INVALID-" + this.getItem().toString());
    }

    default public String getModelCacheKey(ItemStack itemStack, LivingEntity entity) {
        return Optional.ofNullable(this.getIdentifier(itemStack)).filter(id -> !id.isEmpty()).orElseGet(() -> itemStack.m_41782_() ? itemStack.m_41783_().toString() : "INVALID-" + this.getItem().toString());
    }

    public void clearCaches();

    public String[] getMajorModuleKeys(ItemStack var1);

    public String[] getMinorModuleKeys(ItemStack var1);

    public String[] getRequiredModules(ItemStack var1);

    default public boolean isModuleRequired(ItemStack itemStack, String moduleSlot) {
        return ArrayUtils.contains((Object[])this.getRequiredModules(itemStack), (Object)moduleSlot);
    }

    default public Collection<ItemModule> getAllModules(ItemStack stack) {
        CompoundTag stackTag = stack.m_41783_();
        if (stackTag != null) {
            return Stream.concat(Arrays.stream(this.getMajorModuleKeys(stack)), Arrays.stream(this.getMinorModuleKeys(stack))).map(arg_0 -> ((CompoundTag)stackTag).m_128461_(arg_0)).map(ItemUpgradeRegistry.instance::getModule).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    default public ItemModuleMajor[] getMajorModules(ItemStack itemStack) {
        String[] majorModuleKeys = this.getMajorModuleKeys(itemStack);
        ItemModuleMajor[] modules = new ItemModuleMajor[majorModuleKeys.length];
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null) {
            for (int i = 0; i < majorModuleKeys.length; ++i) {
                String moduleName = tag.m_128461_(majorModuleKeys[i]);
                ItemModule module = ItemUpgradeRegistry.instance.getModule(moduleName);
                if (!(module instanceof ItemModuleMajor)) continue;
                modules[i] = (ItemModuleMajor)module;
            }
        }
        return modules;
    }

    default public ItemModule[] getMinorModules(ItemStack itemStack) {
        String[] minorModuleKeys = this.getMinorModuleKeys(itemStack);
        ItemModule[] modules = new ItemModule[minorModuleKeys.length];
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null) {
            for (int i = 0; i < minorModuleKeys.length; ++i) {
                ItemModule module;
                String moduleName = tag.m_128461_(minorModuleKeys[i]);
                modules[i] = module = ItemUpgradeRegistry.instance.getModule(moduleName);
            }
        }
        return modules;
    }

    default public int getNumMajorModules(ItemStack itemStack) {
        return this.getMajorModuleKeys(itemStack).length;
    }

    default public String[] getMajorModuleNames(ItemStack itemStack) {
        return (String[])Arrays.stream(this.getMajorModuleKeys(itemStack)).map(key -> I18n.m_118938_((String)("tetra.slot." + key), (Object[])new Object[0])).toArray(String[]::new);
    }

    default public int getNumMinorModules(ItemStack itemStack) {
        return this.getMinorModuleKeys(itemStack).length;
    }

    default public String[] getMinorModuleNames(ItemStack itemStack) {
        return (String[])Arrays.stream(this.getMinorModuleKeys(itemStack)).map(key -> I18n.m_118938_((String)("tetra.slot." + key), (Object[])new Object[0])).toArray(String[]::new);
    }

    default public boolean hasModule(ItemStack itemStack, ItemModule module) {
        return this.getAllModules(itemStack).stream().anyMatch(module::equals);
    }

    default public ItemModule getModuleFromSlot(ItemStack itemStack, String slot) {
        return Optional.ofNullable(itemStack.m_41783_()).map(tag -> tag.m_128461_(slot)).map(ItemUpgradeRegistry.instance::getModule).orElse(null);
    }

    default public void tickProgression(LivingEntity entity, ItemStack itemStack, int multiplier) {
        if (!((Boolean)ConfigHandler.moduleProgression.get()).booleanValue()) {
            return;
        }
        this.tickHoningProgression(entity, itemStack, multiplier);
        for (ItemModuleMajor module : this.getMajorModules(itemStack)) {
            module.tickProgression(entity, itemStack, multiplier);
        }
    }

    default public void tickHoningProgression(@Nullable LivingEntity entity, ItemStack itemStack, int multiplier) {
        if (!((Boolean)ConfigHandler.moduleProgression.get()).booleanValue() || !this.canGainHoneProgress(itemStack)) {
            return;
        }
        CompoundTag tag = itemStack.m_41784_();
        if (!IModularItem.isHoneable(itemStack)) {
            int honingProgress = tag.m_128441_(honeProgressKey) ? tag.m_128451_(honeProgressKey) : this.getHoningLimit(itemStack);
            tag.m_128405_(honeProgressKey, honingProgress -= multiplier);
            if (honingProgress <= 0 && !IModularItem.isHoneable(itemStack)) {
                tag.m_128379_(honeAvailableKey, true);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    TetraMod.packetHandler.sendTo((AbstractPacket)new HonePacket(itemStack), serverPlayer);
                }
            }
        }
    }

    default public int getHoningProgress(ItemStack itemStack) {
        return Optional.ofNullable(itemStack.m_41783_()).filter(tag -> tag.m_128441_(honeProgressKey)).map(tag -> tag.m_128451_(honeProgressKey)).orElseGet(() -> this.getHoningLimit(itemStack));
    }

    default public void setHoningProgress(ItemStack itemStack, int progress) {
        itemStack.m_41784_().m_128405_(honeProgressKey, progress);
        if (progress <= 0) {
            itemStack.m_41784_().m_128379_(honeAvailableKey, true);
        } else {
            itemStack.m_41784_().m_128473_(honeAvailableKey);
        }
    }

    default public int getHoningLimit(ItemStack itemStack) {
        float workableFactor = (100.0f - (float)this.getEffectLevel(itemStack, ItemEffect.workable)) / 100.0f;
        return (int)Math.max((float)(this.getHoneBase(itemStack) + this.getHoneIntegrityMultiplier(itemStack) * IModularItem.getIntegrityCost(itemStack)) * workableFactor, 1.0f);
    }

    public int getHoneBase(ItemStack var1);

    public int getHoneIntegrityMultiplier(ItemStack var1);

    default public int getHoningIntegrityPenalty(ItemStack itemStack) {
        return this.getHoneIntegrityMultiplier(itemStack) * IModularItem.getIntegrityCost(itemStack);
    }

    default public int getHonedCount(ItemStack itemStack) {
        return Optional.ofNullable(itemStack.m_41783_()).map(tag -> tag.m_128451_(honeCountKey)).orElse(0);
    }

    public boolean canGainHoneProgress(ItemStack var1);

    default public void applyUsageEffects(LivingEntity entity, ItemStack itemStack, double multiplier) {
        ApplyUsageEffectsEvent event = new ApplyUsageEffectsEvent(entity, itemStack, multiplier);
        MinecraftForge.EVENT_BUS.post((Event)event);
        DataEffectsHandler.applyOnUseEffects(itemStack, entity);
        this.applyPositiveUsageEffects(entity, itemStack, event.getPositiveMultiplier());
        this.applyNegativeUsageEffects(entity, itemStack, event.getNegativeMultiplier());
    }

    default public void applyPositiveUsageEffects(LivingEntity entity, ItemStack itemStack, double multiplier) {
        this.tickProgression(entity, itemStack, (int)multiplier);
    }

    default public void applyNegativeUsageEffects(LivingEntity entity, ItemStack itemStack, double multiplier) {
        VexingEffect.perform(entity, itemStack, multiplier);
        FierySelfEffect.perform(entity, itemStack, multiplier);
        EnderReverbEffect.perform(entity, itemStack, multiplier);
        CombustingEffect.perform(entity, itemStack, multiplier);
        RavenousEffect.perform(entity, itemStack, multiplier);
    }

    default public <T extends LivingEntity> int damageItemImpl(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        ModularItemDamageEvent event = new ModularItemDamageEvent(entity, stack, amount);
        MinecraftForge.EVENT_BUS.post((Event)event);
        amount = event.getAmount();
        amount = BloodboundEffect.reduceDamage(stack, entity, amount);
        return Math.min(stack.m_41776_() - stack.m_41773_() - 1, amount);
    }

    default public void applyDamage(int amount, ItemStack itemStack, @Nullable LivingEntity responsibleEntity) {
        int maxDamage;
        int damage = itemStack.m_41773_();
        if (!this.isBroken(damage, maxDamage = itemStack.m_41776_())) {
            int reducedAmount = this.getReducedDamage(amount, itemStack, responsibleEntity);
            itemStack.m_41622_(reducedAmount, responsibleEntity, breaker -> breaker.m_21190_(breaker.m_7655_()));
            if (this.isBroken(damage + reducedAmount, maxDamage) && !responsibleEntity.m_9236_().f_46443_) {
                responsibleEntity.m_21190_(responsibleEntity.m_7655_());
                responsibleEntity.m_5496_(SoundEvents.f_12347_, 1.0f, 1.0f);
            }
        }
    }

    private int getReducedDamage(int amount, ItemStack itemStack, @Nullable LivingEntity responsibleEntity) {
        if (amount > 0) {
            int level = this.getEffectLevel(itemStack, ItemEffect.unbreaking);
            int reduction = 0;
            if (level > 0) {
                for (int i = 0; i < amount; ++i) {
                    if (!DigDurabilityEnchantment.m_220282_((ItemStack)itemStack, (int)level, (RandomSource)responsibleEntity.m_9236_().f_46441_)) continue;
                    ++reduction;
                }
            }
            return amount - reduction;
        }
        return amount;
    }

    default public boolean isBroken(ItemStack itemStack) {
        return this.isBroken(itemStack.m_41773_(), itemStack.m_41776_());
    }

    default public boolean isBroken(int damage, int maxDamage) {
        return maxDamage != 0 && damage >= maxDamage - 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public List<Component> getTooltip(ItemStack itemStack, @Nullable Level world, TooltipFlag advanced) {
        ArrayList tooltip = Lists.newArrayList();
        if (this.isBroken(itemStack)) {
            tooltip.add(Component.m_237115_((String)"item.tetra.modular.broken").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.ITALIC}));
        }
        if (Screen.m_96638_()) {
            tooltip.add(Tooltips.expanded);
            Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).forEach(module -> {
                tooltip.add(Component.m_237113_((String)"\u00bb ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237113_((String)module.getName(itemStack)).m_130940_(ChatFormatting.GRAY)));
                module.getEnchantments(itemStack).entrySet().stream().map(entry -> ((Enchantment)entry.getKey()).m_44700_(((Integer)entry.getValue()).intValue())).map(text -> Component.m_237113_((String)("  - " + text.getString()))).map(text -> text.m_130940_(ChatFormatting.DARK_GRAY)).forEach(tooltip::add);
                Arrays.stream(module.getImprovements(itemStack)).map(improvement -> "  - " + this.getImprovementTooltip(improvement.key, improvement.level, true)).map(Component::m_237113_).map(textComponent -> textComponent.m_130940_(ChatFormatting.DARK_GRAY)).forEach(tooltip::add);
            });
            Arrays.stream(this.getMinorModules(itemStack)).filter(Objects::nonNull).map(module -> Component.m_237113_((String)" * ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237113_((String)module.getName(itemStack)).m_130940_(ChatFormatting.GRAY))).forEach(tooltip::add);
            if (((Boolean)ConfigHandler.moduleProgression.get()).booleanValue() && this.canGainHoneProgress(itemStack)) {
                if (IModularItem.isHoneable(itemStack)) {
                    tooltip.add(Component.m_237113_((String)" > ").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237115_((String)"tetra.hone.available").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY))));
                } else {
                    int progress = this.getHoningProgress(itemStack);
                    int base = this.getHoningLimit(itemStack);
                    String percentage = String.format("%.0f", Float.valueOf(100.0f * (float)(base - progress) / (float)base));
                    tooltip.add(Component.m_237113_((String)" > ").m_130940_(ChatFormatting.DARK_AQUA).m_7220_((Component)Component.m_237110_((String)"tetra.hone.progress", (Object[])new Object[]{base - progress, base, percentage}).m_130940_(ChatFormatting.GRAY)));
                }
            }
        } else {
            ItemStack.m_41709_((List)tooltip, (ListTag)itemStack.m_41785_());
            tooltip.add(Tooltips.expand);
        }
        return tooltip;
    }

    default public String getImprovementTooltip(String key, int level, boolean clearFormatting) {
        if (clearFormatting) {
            return ChatFormatting.m_126649_((String)IModularItem.getImprovementName(key, level));
        }
        return IModularItem.getImprovementName(key, level);
    }

    default public Optional<ItemModule> getRepairModule(ItemStack itemStack) {
        List modules = this.getAllModules(itemStack).stream().filter(itemModule -> !itemModule.getRepairDefinitions(itemStack).isEmpty()).collect(Collectors.toList());
        if (modules.size() > 0) {
            int repairCount = this.getRepairCount(itemStack);
            return Optional.of((ItemModule)modules.get(repairCount % modules.size()));
        }
        return Optional.empty();
    }

    default public ItemModule[] getRepairCycle(ItemStack itemStack) {
        return (ItemModule[])this.getAllModules(itemStack).stream().filter(module -> !module.getRepairDefinitions(itemStack).isEmpty()).toArray(ItemModule[]::new);
    }

    default public String getRepairModuleName(ItemStack itemStack) {
        return this.getRepairModule(itemStack).map(module -> module.getName(itemStack)).orElse(null);
    }

    default public String getRepairSlot(ItemStack itemStack) {
        return this.getRepairModule(itemStack).map(ItemModule::getSlot).orElse(null);
    }

    default public Collection<RepairDefinition> getRepairDefinitions(ItemStack itemStack) {
        return this.getRepairModule(itemStack).map(module -> module.getRepairDefinitions(itemStack)).orElse(null);
    }

    default public int getRepairMaterialCount(ItemStack itemStack, ItemStack materialStack) {
        return this.getRepairModule(itemStack).map(module -> module.getRepairDefinition(itemStack, materialStack)).map(definition -> definition.material.count).orElse(0);
    }

    default public int getRepairAmount(ItemStack itemStack) {
        return this.getItem().getMaxDamage(itemStack);
    }

    default public Collection<ToolAction> getRepairRequiredTools(ItemStack itemStack, ItemStack materialStack) {
        return this.getRepairModule(itemStack).map(module -> module.getRepairRequiredTools(itemStack, materialStack)).orElseGet(Collections::emptySet);
    }

    default public Map<ToolAction, Integer> getRepairRequiredToolLevels(ItemStack itemStack, ItemStack materialStack) {
        return this.getRepairModule(itemStack).map(module -> module.getRepairRequiredToolLevels(itemStack, materialStack)).orElseGet(Collections::emptyMap);
    }

    default public int getRepairRequiredToolLevel(ItemStack itemStack, ItemStack materialStack, ToolAction toolAction) {
        return this.getRepairModule(itemStack).filter(module -> module.getRepairRequiredTools(itemStack, materialStack).contains(toolAction)).map(module -> module.getRepairRequiredToolLevel(itemStack, materialStack, toolAction)).map(level -> Math.max(1, level)).orElse(0);
    }

    default public int getRepairRequiredExperience(ItemStack itemStack, ItemStack materialStack) {
        return this.getRepairModule(itemStack).map(module -> module.getRepairExperienceCost(itemStack, materialStack)).orElse(0);
    }

    default public int getRepairCount(ItemStack itemStack) {
        return Optional.ofNullable(itemStack.m_41783_()).map(tag -> tag.m_128451_(repairCountKey)).orElse(0);
    }

    default public void incrementRepairCount(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128405_(repairCountKey, tag.m_128451_(repairCountKey) + 1);
    }

    default public void repair(ItemStack itemStack) {
        this.getItem().setDamage(itemStack, this.getItem().getDamage(itemStack) - this.getRepairAmount(itemStack));
        this.incrementRepairCount(itemStack);
    }

    default public float getStabilityModifier(ItemStack itemStack) {
        return 1.0f + (float)(this.getEffectLevel(itemStack, ItemEffect.stabilizing) - this.getEffectLevel(itemStack, ItemEffect.unstable)) / 100.0f;
    }

    default public void tweak(ItemStack itemStack, String slot, Map<String, Integer> tweaks) {
        ItemModule module = this.getModuleFromSlot(itemStack, slot);
        double durabilityFactor = 0.0;
        if (module == null || !module.isTweakable(itemStack)) {
            return;
        }
        if (itemStack.m_41763_()) {
            durabilityFactor = (double)itemStack.m_41773_() * 1.0 / (double)itemStack.m_41776_();
        }
        tweaks.forEach((tweakKey, step) -> {
            if (module.hasTweak(itemStack, (String)tweakKey)) {
                module.setTweakStep(itemStack, (String)tweakKey, (int)step);
            }
        });
        if (itemStack.m_41763_()) {
            itemStack.m_41721_((int)Math.floor(durabilityFactor * (double)itemStack.m_41776_()));
        }
        IModularItem.updateIdentifier(itemStack);
    }

    default public Multimap<Attribute, AttributeModifier> getEffectAttributes(ItemStack itemStack) {
        return AttributeHelper.emptyMap;
    }

    default public Multimap<Attribute, AttributeModifier> getModuleAttributes(ItemStack itemStack) {
        return this.getAllModules(itemStack).stream().map(module -> module.getAttributeModifiers(itemStack)).filter(Objects::nonNull).reduce(null, AttributeHelper::merge);
    }

    default public Multimap<Attribute, AttributeModifier> getAttributeModifiers(ItemStack itemStack) {
        Multimap<Attribute, AttributeModifier> attributes = AttributeHelper.merge(this.getModuleAttributes(itemStack), this.getEffectAttributes(itemStack));
        return Arrays.stream(this.getSynergyData(itemStack)).map(synergy -> synergy.attributes).filter(Objects::nonNull).reduce(attributes, AttributeHelper::merge);
    }

    default public Multimap<Attribute, AttributeModifier> getAttributeModifiersCollapsed(ItemStack itemStack) {
        if (logger.isDebugEnabled()) {
            logger.debug("Gathering attribute modifiers for {} ({})", (Object)this.getItemName(itemStack), (Object)this.getDataCacheKey(itemStack));
        }
        return Optional.ofNullable(this.getAttributeModifiers(itemStack)).map(modifiers -> (ArrayListMultimap)modifiers.asMap().entrySet().stream().collect(Multimaps.flatteningToMultimap(Map.Entry::getKey, entry -> AttributeHelper.collapse((Collection)entry.getValue()).stream(), ArrayListMultimap::create))).map(this::fixIdentifiers).orElse(null);
    }

    default public Multimap<Attribute, AttributeModifier> fixIdentifiers(Multimap<Attribute, AttributeModifier> modifiers) {
        return AttributeHelper.fixIdentifiers(modifiers);
    }

    public Cache<String, Multimap<Attribute, AttributeModifier>> getAttributeModifierCache();

    default public Multimap<Attribute, AttributeModifier> getAttributeModifiersCached(ItemStack itemStack) {
        try {
            return (Multimap)this.getAttributeModifierCache().get((Object)this.getDataCacheKey(itemStack), () -> Optional.ofNullable(this.getAttributeModifiersCollapsed(itemStack)).orElseGet(ImmutableMultimap::of));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return this.getAttributeModifiersCollapsed(itemStack);
        }
    }

    default public double getAttributeValue(ItemStack itemStack, Attribute attribute) {
        if (this.isBroken(itemStack)) {
            return 0.0;
        }
        return AttributeHelper.getMergedAmount(this.getAttributeModifiersCached(itemStack).get((Object)attribute));
    }

    default public double getAttributeValue(ItemStack itemStack, Attribute attribute, double base) {
        if (this.isBroken(itemStack)) {
            return 0.0;
        }
        return AttributeHelper.getMergedAmount(this.getAttributeModifiersCached(itemStack).get((Object)attribute), base);
    }

    default public EffectData getEffectData(ItemStack itemStack) {
        if (logger.isDebugEnabled()) {
            logger.debug("Gathering effect data for {} ({})", (Object)this.getItemName(itemStack), (Object)this.getDataCacheKey(itemStack));
        }
        return Stream.concat(this.getAllModules(itemStack).stream().map(module -> module.getEffectData(itemStack)), Arrays.stream(this.getSynergyData(itemStack)).map(synergy -> synergy.effects)).filter(Objects::nonNull).reduce(null, EffectData::merge);
    }

    public Cache<String, EffectData> getEffectDataCache();

    default public EffectData getEffectDataCached(ItemStack itemStack) {
        try {
            return (EffectData)this.getEffectDataCache().get((Object)this.getDataCacheKey(itemStack), () -> Optional.ofNullable(this.getEffectData(itemStack)).orElseGet(EffectData::new));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return Optional.ofNullable(this.getEffectData(itemStack)).orElseGet(EffectData::new);
        }
    }

    default public ItemProperties getProperties(ItemStack itemStack) {
        if (logger.isDebugEnabled()) {
            logger.debug("Gathering properties for {} ({})", (Object)this.getItemName(itemStack), (Object)this.getDataCacheKey(itemStack));
        }
        return Stream.concat(this.getAllModules(itemStack).stream().map(module -> module.getProperties(itemStack)), Arrays.stream(this.getSynergyData(itemStack))).reduce((SynergyData)new ItemProperties(), ItemProperties::merge);
    }

    public Cache<String, ItemProperties> getPropertyCache();

    default public ItemProperties getPropertiesCached(ItemStack itemStack) {
        try {
            return (ItemProperties)this.getPropertyCache().get((Object)this.getDataCacheKey(itemStack), () -> this.getProperties(itemStack));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return this.getProperties(itemStack);
        }
    }

    default public Set<TagKey<Item>> getTags(ItemStack itemStack) {
        return this.getPropertiesCached((ItemStack)itemStack).tags;
    }

    default public int getEffectLevel(ItemStack itemStack, ItemEffect effect) {
        if (this.isBroken(itemStack)) {
            return -1;
        }
        return this.getEffectDataCached(itemStack).getLevel(effect);
    }

    default public float getEffectEfficiency(ItemStack itemStack, ItemEffect effect) {
        if (this.isBroken(itemStack)) {
            return 0.0f;
        }
        return this.getEffectDataCached(itemStack).getEfficiency(effect);
    }

    default public Collection<ItemEffect> getEffects(ItemStack itemStack) {
        if (this.isBroken(itemStack)) {
            return Collections.emptyList();
        }
        return this.getEffectDataCached(itemStack).getValues();
    }

    default public ImprovementData[] getImprovements(ItemStack itemStack) {
        return (ImprovementData[])Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).flatMap(module -> Arrays.stream(module.getImprovements(itemStack))).toArray(ImprovementData[]::new);
    }

    default public String getDisplayNamePrefixes(ItemStack itemStack) {
        return Stream.concat(Arrays.stream(this.getImprovements(itemStack)).map(improvement -> Pair.of((Object)((Object)improvement.prefixPriority), (Object)("tetra.improvement." + improvement.key + ".prefix"))).filter(pair -> I18n.m_118936_((String)((String)pair.getSecond()))).map(pair -> Pair.of((Object)((Object)((Priority)((Object)((Object)pair.getFirst())))), (Object)I18n.m_118938_((String)((String)pair.getSecond()), (Object[])new Object[0]))), this.getAllModules(itemStack).stream().map(module -> Pair.of((Object)((Object)module.getItemPrefixPriority(itemStack)), (Object)module.getItemPrefix(itemStack))).filter(pair -> pair.getSecond() != null)).sorted(Comparator.comparing(Pair::getFirst).reversed()).limit(2L).map(Pair::getSecond).reduce("", (result, prefix) -> result + prefix + " ");
    }

    default public String getItemName(ItemStack itemStack) {
        if (Environment.get().getDist().isDedicatedServer()) {
            return "";
        }
        String name = Arrays.stream(this.getSynergyData(itemStack)).map(synergyData -> synergyData.name).filter(Objects::nonNull).map(key -> "tetra.synergy." + key).filter(I18n::m_118936_).map(x$0 -> I18n.m_118938_((String)x$0, (Object[])new Object[0])).findFirst().orElse(null);
        if (name == null) {
            name = this.getAllModules(itemStack).stream().sorted(Comparator.comparing(module -> module.getItemNamePriority(itemStack)).reversed()).map(module -> module.getItemName(itemStack)).filter(Objects::nonNull).findFirst().orElse("");
        }
        String prefixes = this.getDisplayNamePrefixes(itemStack);
        return WordUtils.capitalize((String)(prefixes + name));
    }

    public SynergyData[] getAllSynergyData(ItemStack var1);

    default public SynergyData[] getSynergyData(ItemStack itemStack) {
        SynergyData[] synergies = this.getAllSynergyData(itemStack);
        if (synergies.length > 0) {
            ItemModule[] modules = (ItemModule[])this.getAllModules(itemStack).stream().sorted(Comparator.comparing(ItemModule::getUnlocalizedName)).toArray(ItemModule[]::new);
            String[] variantKeys = (String[])this.getAllModules(itemStack).stream().map(module -> module.getVariantData(itemStack)).map(data -> data.key).sorted().toArray(String[]::new);
            String[] improvements = (String[])Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).map(module -> module.getImprovements(itemStack)).flatMap(Arrays::stream).map(data -> data.key).sorted().toArray(String[]::new);
            return (SynergyData[])Arrays.stream(synergies).filter(synergy -> synergy.modules.length == 0 || this.hasModuleSynergy(itemStack, (SynergyData)synergy, modules)).filter(synergy -> synergy.moduleVariants.length == 0 || this.hasVariantSynergy((SynergyData)synergy, variantKeys)).filter(synergy -> synergy.improvements.length == 0 || this.hasImprovementSynergy((SynergyData)synergy, improvements)).toArray(SynergyData[]::new);
        }
        return new SynergyData[0];
    }

    default public boolean hasImprovementSynergy(SynergyData synergy, String[] improvements) {
        int improvementMatches = 0;
        for (String improvement : improvements) {
            if (improvementMatches == synergy.improvements.length) break;
            if (!improvement.equals(synergy.improvements[improvementMatches])) continue;
            ++improvementMatches;
        }
        return synergy.improvements.length > 0 && improvementMatches == synergy.improvements.length;
    }

    default public boolean hasVariantSynergy(SynergyData synergy, String[] variantKeys) {
        int variantMatches = 0;
        for (String variantKey : variantKeys) {
            if (variantMatches == synergy.moduleVariants.length) break;
            if (!variantKey.equals(synergy.moduleVariants[variantMatches])) continue;
            ++variantMatches;
        }
        return synergy.moduleVariants.length > 0 && variantMatches == synergy.moduleVariants.length;
    }

    default public boolean hasModuleSynergy(ItemStack itemStack, SynergyData synergy, ItemModule[] modules) {
        int moduleMatches = 0;
        String variant = null;
        if (synergy.sameVariant) {
            for (ItemModule module : modules) {
                if (moduleMatches != synergy.modules.length) {
                    String moduleKey;
                    String string = moduleKey = synergy.matchSuffixed ? module.getKey() : module.getUnlocalizedName();
                    if (!moduleKey.equals(synergy.modules[moduleMatches])) continue;
                    if (variant == null) {
                        variant = module.getVariantData((ItemStack)itemStack).key;
                    }
                    if (!variant.equals(module.getVariantData((ItemStack)itemStack).key)) continue;
                    ++moduleMatches;
                    continue;
                }
                break;
            }
        } else {
            for (ItemModule module : modules) {
                if (moduleMatches != synergy.modules.length) {
                    String moduleKey;
                    String string = moduleKey = synergy.matchSuffixed ? module.getKey() : module.getUnlocalizedName();
                    if (!moduleKey.equals(synergy.modules[moduleMatches])) continue;
                    ++moduleMatches;
                    continue;
                }
                break;
            }
        }
        return synergy.modules.length > 0 && moduleMatches == synergy.modules.length;
    }

    default public void assemble(ItemStack itemStack, @Nullable Level world, float severity) {
        if (itemStack.m_41773_() > itemStack.m_41776_()) {
            itemStack.m_41721_(itemStack.m_41776_());
        }
        CompoundTag nbt = itemStack.m_41784_();
        nbt.m_128405_("HideFlags", 1);
        IModularItem.updateIdentifier(itemStack);
    }

    default public boolean acceptsEnchantment(ItemStack itemStack, Enchantment enchantment, boolean fromTable) {
        return Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).anyMatch(module -> module.acceptsEnchantment(itemStack, enchantment, fromTable));
    }

    default public int getEnchantability(ItemStack itemStack) {
        return (int)(Arrays.stream(this.getMajorModules(itemStack)).filter(Objects::nonNull).mapToInt(module -> module.getMagicCapacity(itemStack)).filter(capacity -> capacity > 0).average().orElse(0.0) / 6.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public ImmutableList<ModuleModel> getModels(ItemStack itemStack, @Nullable LivingEntity entity) {
        return this.getAllModules(itemStack).stream().sorted(Comparator.comparing(ItemModule::getRenderLayer)).flatMap(itemModule -> Arrays.stream(itemModule.getModels(itemStack))).filter(Objects::nonNull).sorted(Comparator.comparing(ModuleModel::getRenderLayer)).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public String getTransformVariant(ItemStack itemStack, @Nullable LivingEntity entity) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public GuiModuleOffsets getMajorGuiOffsets(ItemStack itemStack) {
        return defaultMajorOffsets[this.getNumMajorModules(itemStack)];
    }

    @OnlyIn(value=Dist.CLIENT)
    default public GuiModuleOffsets getMinorGuiOffsets(ItemStack itemStack) {
        return defaultMinorOffsets[this.getNumMinorModules(itemStack)];
    }
}

