/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.getter;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;

@ParametersAreNonnullByDefault
public class StatGetterClamp
implements IStatGetter {
    private final IStatGetter statGetter;
    private Double min;
    private Double max;

    public StatGetterClamp(IStatGetter statGetter, Double min, Double max) {
        this.statGetter = statGetter;
        this.min = min;
        this.max = max;
    }

    private double clamp(double value) {
        if (this.min != null && value < this.min) {
            return this.min;
        }
        if (this.max != null && value > this.max) {
            return this.max;
        }
        return value;
    }

    @Override
    public double getValue(Player player, ItemStack itemStack) {
        return this.clamp(this.statGetter.getValue(player, itemStack));
    }

    @Override
    public double getValue(Player player, ItemStack itemStack, String slot) {
        return this.clamp(this.statGetter.getValue(player, itemStack, slot));
    }

    @Override
    public double getValue(Player player, ItemStack itemStack, String slot, String improvement) {
        return this.clamp(this.statGetter.getValue(player, itemStack, slot, improvement));
    }
}

