/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui;

import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiString;
import se.mickelus.mutil.gui.GuiStringSmall;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.Tooltips;
import se.mickelus.tetra.gui.stats.bar.GuiBar;
import se.mickelus.tetra.items.modular.IModularItem;

@ParametersAreNonnullByDefault
public class GuiMagicUsage
extends GuiElement {
    protected GuiString valueString;
    protected GuiBar bar;
    protected List<Component> tooltip;
    protected List<Component> tooltipExtended;

    public GuiMagicUsage(int x, int y, int barLength) {
        super(x, y, barLength, 12);
        this.addChild((GuiElement)new GuiStringSmall(0, 0, I18n.m_118938_((String)"item.tetra.modular.magic_capacity.label", (Object[])new Object[0])));
        this.valueString = new GuiStringSmall(0, 0, "");
        this.valueString.setAttachment(GuiAttachment.topRight);
        this.addChild((GuiElement)this.valueString);
        this.bar = new GuiBar(0, 0, barLength, 0.0, 0.0);
        this.addChild(this.bar);
    }

    private static int getGain(ItemStack itemStack, String slot) {
        return CastOptional.cast((Object)itemStack.m_41720_(), IModularItem.class).map(item -> item.getModuleFromSlot(itemStack, slot)).map(module -> module.getMagicCapacityGain(itemStack)).orElse(0);
    }

    private static int getCost(ItemStack itemStack, String slot) {
        return CastOptional.cast((Object)itemStack.m_41720_(), IModularItem.class).map(item -> item.getModuleFromSlot(itemStack, slot)).map(module -> module.getMagicCapacityCost(itemStack)).orElse(0);
    }

    private static float getDestabilizeChance(ItemStack itemStack, String slot) {
        return CastOptional.cast((Object)itemStack.m_41720_(), IModularItem.class).map(item -> item.getModuleFromSlot(itemStack, slot)).map(module -> Float.valueOf(module.getDestabilizationChance(itemStack, 1.0f))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    private static int getExperienceCost(ItemStack itemStack, String slot) {
        return CastOptional.cast((Object)itemStack.m_41720_(), IModularItem.class).map(item -> item.getModuleFromSlot(itemStack, slot)).map(module -> module.getRepairExperienceCost(itemStack, ItemStack.f_41583_)).orElse(0);
    }

    public void update(ItemStack itemStack, ItemStack previewStack, String slot) {
        if (!previewStack.m_41619_()) {
            int value = GuiMagicUsage.getCost(itemStack, slot);
            int diffValue = GuiMagicUsage.getCost(previewStack, slot) - value;
            int max = GuiMagicUsage.getGain(itemStack, slot);
            int diffMax = GuiMagicUsage.getGain(previewStack, slot) - max;
            int risk = Math.round(GuiMagicUsage.getDestabilizeChance(previewStack, slot) * 100.0f);
            int xpCost = GuiMagicUsage.getExperienceCost(previewStack, slot);
            this.bar.setMax(Math.max(max + diffMax, max));
            this.tooltip = Arrays.asList(Component.m_237110_((String)"item.tetra.modular.magic_capacity.description", (Object[])new Object[]{max, value + diffValue, xpCost, risk}), Component.m_237113_((String)""), Tooltips.expand);
            this.tooltipExtended = Arrays.asList(Component.m_237110_((String)"item.tetra.modular.magic_capacity.description", (Object[])new Object[]{max, value + diffValue, xpCost, risk}), Component.m_237113_((String)""), Tooltips.expanded, Component.m_237115_((String)"item.tetra.modular.magic_capacity.description_extended"));
            if (diffMax != 0) {
                this.bar.setValue(max, max + diffMax);
                this.valueString.setString(String.format("%s(%+d)%s %d/%d", diffMax < 0 ? ChatFormatting.RED : ChatFormatting.GREEN, diffMax, ChatFormatting.RESET, max + diffMax, max + diffMax));
            } else if (diffValue != 0) {
                this.bar.setValue(max - value, max - value - diffValue);
                this.valueString.setString(String.format("%s(%+d)%s %d/%d", diffValue > 0 ? ChatFormatting.RED : ChatFormatting.GREEN, -diffValue, ChatFormatting.RESET, max - value - diffValue, max));
            } else {
                this.bar.setValue(max - value, max - value);
                this.valueString.setString(String.format("%d/%d", max - value, max));
            }
        } else {
            int value = GuiMagicUsage.getCost(itemStack, slot);
            int max = GuiMagicUsage.getGain(itemStack, slot);
            int risk = Math.round(GuiMagicUsage.getDestabilizeChance(itemStack, slot) * 100.0f);
            int xpCost = GuiMagicUsage.getExperienceCost(itemStack, slot);
            this.tooltip = Arrays.asList(Component.m_237110_((String)"item.tetra.modular.magic_capacity.description", (Object[])new Object[]{max, value, xpCost, risk}), Component.m_237113_((String)""), Tooltips.expand);
            this.tooltipExtended = Arrays.asList(Component.m_237110_((String)"item.tetra.modular.magic_capacity.description", (Object[])new Object[]{max, value, xpCost, risk}), Component.m_237113_((String)""), Tooltips.expanded, Component.m_237115_((String)"item.tetra.modular.magic_capacity.description_extended"));
            this.valueString.setString(String.format("%d/%d", max - value, max));
            this.bar.setMax(max);
            this.bar.setValue(max - value, max - value);
        }
    }

    public boolean hasChanged(ItemStack itemStack, ItemStack previewStack, String slot) {
        return !previewStack.m_41619_() && (GuiMagicUsage.getCost(itemStack, slot) != GuiMagicUsage.getCost(previewStack, slot) || GuiMagicUsage.getGain(itemStack, slot) != GuiMagicUsage.getGain(previewStack, slot));
    }

    public boolean providesCapacity(ItemStack itemStack, ItemStack previewStack, String slot) {
        return GuiMagicUsage.getGain(itemStack, slot) > 0 || GuiMagicUsage.getGain(previewStack, slot) > 0;
    }

    public List<Component> getTooltipLines() {
        if (this.hasFocus()) {
            if (Screen.m_96638_()) {
                return this.tooltipExtended;
            }
            return this.tooltip;
        }
        return super.getTooltipLines();
    }
}

