/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.client.particle;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.phys.Vec2;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TargetPointParticle
extends TextureSheetParticle {
    final SpriteSet sprites;
    double tarX;
    double tarY;
    double tarZ;
    int delay;
    List<Vector3f> colors;

    TargetPointParticle(ClientLevel level, double x, double y, double z, double tarX, double tarY, double tarZ, float friction, float gravity, int delay, SpriteSet spriteSet) {
        super(level, x, y, z);
        this.f_107226_ = gravity;
        this.f_172258_ = friction;
        this.sprites = spriteSet;
        this.delay = delay;
        this.tarX = tarX;
        this.tarY = tarY;
        this.tarZ = tarZ;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.075 + Math.random() * 0.05;
        this.f_107217_ = 0.0;
        this.f_107663_ = 0.125f;
        this.f_107225_ = 150 + this.f_107223_.m_188503_(30);
        this.f_107219_ = true;
        this.m_108339_(this.sprites);
    }

    public TargetPointParticle withInitialSpeed(double xd, double yd, double zd) {
        this.f_107215_ = xd;
        this.f_107216_ = yd;
        this.f_107217_ = zd;
        return this;
    }

    public TargetPointParticle withYD(double yd) {
        this.f_107216_ = yd;
        return this;
    }

    public TargetPointParticle withColor(int ... colors) {
        if (colors.length > 1) {
            this.colors = Arrays.stream(colors).mapToObj(color -> new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f)).collect(Collectors.toList());
        } else {
            this.f_107227_ = (float)(colors[0] >> 16 & 0xFF) / 255.0f;
            this.f_107228_ = (float)(colors[0] >> 8 & 0xFF) / 255.0f;
            this.f_107229_ = (float)(colors[0] & 0xFF) / 255.0f;
        }
        return this;
    }

    private void updateColors() {
        if (this.colors != null && this.colors.size() > 1) {
            int size = this.colors.size();
            float progress = Math.min(1.0f * (float)this.f_107224_ / (float)this.f_107225_ * (float)(size - 1), (float)size - 1.00001f);
            int index = Math.min((int)progress, size - 2);
            this.lerpColors(progress % 1.0f, this.colors.get(index), this.colors.get(index + 1));
        }
        if (this.f_107224_ > this.f_107225_ - 5) {
            this.f_107230_ = Math.max((float)(this.f_107225_ - this.f_107224_) / 5.0f, 0.0f);
        }
    }

    private void lerpColors(float factor, Vector3f fromColor, Vector3f toColor) {
        Vector3f vector3f = new Vector3f((Vector3fc)fromColor);
        vector3f.lerp((Vector3fc)toColor, factor);
        this.f_107227_ = vector3f.x();
        this.f_107228_ = vector3f.y();
        this.f_107229_ = vector3f.z();
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.sprites);
        this.updateColors();
        if (this.f_107224_ > this.delay) {
            Vec2 n = new Vec2((float)(this.tarX - this.f_107212_), (float)(this.tarZ - this.f_107214_)).m_165903_(this.getApproxNormScale((float)(this.tarX - this.f_107212_), (float)(this.tarZ - this.f_107214_)));
            n = n.m_165903_(this.getApproxNormScale(n.f_82470_, n.f_82471_) * 0.5f);
            if (this.f_107224_ < this.f_107225_ - 10) {
                n = new Vec2((float)(this.tarX - this.f_107212_ - (double)n.f_82471_), (float)(this.tarZ - this.f_107214_ + (double)n.f_82470_));
                n = n.m_165903_(this.getApproxNormScale(n.f_82470_, n.f_82471_));
            }
            this.f_107215_ = this.f_107215_ * 0.85 + (double)n.f_82470_ * 0.04;
            this.f_107217_ = this.f_107217_ * 0.85 + (double)n.f_82471_ * 0.04;
            this.f_107216_ = this.f_107216_ * 0.9 + (this.tarY - this.f_107213_ + Math.sin((float)this.f_107224_ / 10.0f + (float)this.f_107225_) * 0.2) * 0.005;
        } else {
            this.f_107215_ *= 0.95;
            this.f_107216_ *= 0.95;
            this.f_107217_ *= 0.95;
        }
    }

    private float getApproxNormScale(float x, float y) {
        x = Math.abs(x);
        y = Math.abs(y);
        float ratio = 1.0f / Math.max(x, y);
        ratio *= 1.29289f - (x + y) * ratio * 0.29289f;
        return ratio;
    }

    public int m_6355_(float p_234080_) {
        return 240;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }
}

