/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeTier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import se.mickelus.tetra.LooseItemPredicate;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.TetraSounds;
import se.mickelus.tetra.advancements.BlockInteractionCriterion;
import se.mickelus.tetra.advancements.BlockUseCriterion;
import se.mickelus.tetra.advancements.DestabilizeCriterion;
import se.mickelus.tetra.advancements.ImprovementCraftCriterion;
import se.mickelus.tetra.advancements.ModuleCraftCriterion;
import se.mickelus.tetra.blocks.ArcaneFireBlock;
import se.mickelus.tetra.blocks.InitializableBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.forged.ForgedCrateBlock;
import se.mickelus.tetra.blocks.forged.ForgedPillarBlock;
import se.mickelus.tetra.blocks.forged.ForgedPlatformBlock;
import se.mickelus.tetra.blocks.forged.ForgedPlatformSlabBlock;
import se.mickelus.tetra.blocks.forged.ForgedVentBlock;
import se.mickelus.tetra.blocks.forged.ForgedWallBlock;
import se.mickelus.tetra.blocks.forged.ForgedWorkbenchBlock;
import se.mickelus.tetra.blocks.forged.chthonic.ChthonicExtractorBlock;
import se.mickelus.tetra.blocks.forged.chthonic.ChthonicExtractorTile;
import se.mickelus.tetra.blocks.forged.chthonic.DepletedBedrockBlock;
import se.mickelus.tetra.blocks.forged.chthonic.ExtractorProjectileEntity;
import se.mickelus.tetra.blocks.forged.chthonic.FracturedBedrockBlock;
import se.mickelus.tetra.blocks.forged.chthonic.FracturedBedrockTile;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerBlock;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerBlockEntity;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerMenu;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorBaseBlock;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorBaseBlockEntity;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorPipeBlock;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorPistonBlock;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorPistonBlockEntity;
import se.mickelus.tetra.blocks.forged.extractor.SeepingBedrockBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseBlockEntity;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadBlockEntity;
import se.mickelus.tetra.blocks.forged.transfer.TransferUnitBlock;
import se.mickelus.tetra.blocks.forged.transfer.TransferUnitBlockEntity;
import se.mickelus.tetra.blocks.geode.GeodeBlock;
import se.mickelus.tetra.blocks.geode.GeodeItem;
import se.mickelus.tetra.blocks.geode.PristineAmethystItem;
import se.mickelus.tetra.blocks.geode.PristineDiamondItem;
import se.mickelus.tetra.blocks.geode.PristineEmeraldItem;
import se.mickelus.tetra.blocks.geode.PristineLapisItem;
import se.mickelus.tetra.blocks.geode.PristineQuartzItem;
import se.mickelus.tetra.blocks.holo.HolosphereBlock;
import se.mickelus.tetra.blocks.holo.HolosphereBlockEntity;
import se.mickelus.tetra.blocks.multischematic.MultiblockSchematicBlock;
import se.mickelus.tetra.blocks.rack.RackBlock;
import se.mickelus.tetra.blocks.rack.RackTile;
import se.mickelus.tetra.blocks.salvage.InteractiveBlockOverlay;
import se.mickelus.tetra.blocks.scroll.OpenScrollBlock;
import se.mickelus.tetra.blocks.scroll.RolledScrollBlock;
import se.mickelus.tetra.blocks.scroll.ScrollItem;
import se.mickelus.tetra.blocks.scroll.ScrollTile;
import se.mickelus.tetra.blocks.scroll.WallScrollBlock;
import se.mickelus.tetra.blocks.workbench.BasicWorkbenchBlock;
import se.mickelus.tetra.blocks.workbench.WorkbenchContainer;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.blocks.workbench.gui.WorkbenchStatsGui;
import se.mickelus.tetra.client.particle.DripParticles;
import se.mickelus.tetra.client.particle.Particles;
import se.mickelus.tetra.client.particle.PlainParticleType;
import se.mickelus.tetra.client.particle.SweepingStrikeParticleType;
import se.mickelus.tetra.crafting.ScrollIngredient;
import se.mickelus.tetra.crafting.ToolActionIngredient;
import se.mickelus.tetra.effect.howling.HowlingPotionEffect;
import se.mickelus.tetra.effect.potion.BleedingPotionEffect;
import se.mickelus.tetra.effect.potion.EarthboundPotionEffect;
import se.mickelus.tetra.effect.potion.ExhaustedPotionEffect;
import se.mickelus.tetra.effect.potion.MiningSpeedPotionEffect;
import se.mickelus.tetra.effect.potion.PriedPotionEffect;
import se.mickelus.tetra.effect.potion.PuncturedPotionEffect;
import se.mickelus.tetra.effect.potion.SatiatedPotionEffect;
import se.mickelus.tetra.effect.potion.SeveredPotionEffect;
import se.mickelus.tetra.effect.potion.SmallAbsorbPotionEffect;
import se.mickelus.tetra.effect.potion.SmallHealthPotionEffect;
import se.mickelus.tetra.effect.potion.SmallStrengthPotionEffect;
import se.mickelus.tetra.effect.potion.SteeledPotionEffect;
import se.mickelus.tetra.effect.potion.StunPotionEffect;
import se.mickelus.tetra.effect.potion.UnstablePowerMobEffect;
import se.mickelus.tetra.effect.potion.UnwaveringPotionEffect;
import se.mickelus.tetra.gui.stats.sorting.StatSorters;
import se.mickelus.tetra.items.InitializableItem;
import se.mickelus.tetra.items.cell.ThermalCellItem;
import se.mickelus.tetra.items.forged.BeamItem;
import se.mickelus.tetra.items.forged.BoltItem;
import se.mickelus.tetra.items.forged.CombustionChamberItem;
import se.mickelus.tetra.items.forged.EarthpiercerItem;
import se.mickelus.tetra.items.forged.InsulatedPlateItem;
import se.mickelus.tetra.items.forged.LubricantDispenserItem;
import se.mickelus.tetra.items.forged.MeshItem;
import se.mickelus.tetra.items.forged.MetalScrapItem;
import se.mickelus.tetra.items.forged.PlanarStabilizerItem;
import se.mickelus.tetra.items.forged.QuickLatchItem;
import se.mickelus.tetra.items.forged.StonecutterItem;
import se.mickelus.tetra.items.loot.DragonSinewItem;
import se.mickelus.tetra.items.modular.EffectItemPredicate;
import se.mickelus.tetra.items.modular.ItemPredicateModular;
import se.mickelus.tetra.items.modular.MaterialItemPredicate;
import se.mickelus.tetra.items.modular.ThrownModularItemEntity;
import se.mickelus.tetra.items.modular.impl.ModularBladedItem;
import se.mickelus.tetra.items.modular.impl.ModularDoubleHeadedItem;
import se.mickelus.tetra.items.modular.impl.ModularSingleHeadedItem;
import se.mickelus.tetra.items.modular.impl.bow.ModularBowItem;
import se.mickelus.tetra.items.modular.impl.crossbow.ModularCrossbowItem;
import se.mickelus.tetra.items.modular.impl.crossbow.ShootableDummyItem;
import se.mickelus.tetra.items.modular.impl.dynamic.DynamicModularItem;
import se.mickelus.tetra.items.modular.impl.holo.ModularHolosphereItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloStatsGui;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ModularToolbeltItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltContainer;
import se.mickelus.tetra.items.modular.impl.toolbelt.suspend.SuspendPotionEffect;
import se.mickelus.tetra.levelgen.ForgedContainerProcessor;
import se.mickelus.tetra.levelgen.ForgedCrateProcessor;
import se.mickelus.tetra.levelgen.ForgedHammerProcessor;
import se.mickelus.tetra.levelgen.MultiblockSchematicProcessor;
import se.mickelus.tetra.levelgen.TransferUnitProcessor;
import se.mickelus.tetra.loot.FortuneBonusCondition;
import se.mickelus.tetra.loot.ReplaceTableModifier;
import se.mickelus.tetra.loot.ScrollDataFunction;

public class TetraRegistries {
    public static final DeferredRegister<Block> blocks = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"tetra");
    public static final DeferredRegister<Item> items = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"tetra");
    public static final DeferredRegister<BlockEntityType<?>> blockEntities = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"tetra");
    public static final DeferredRegister<MenuType<?>> containers = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"tetra");
    public static final DeferredRegister<EntityType<?>> entities = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"tetra");
    public static final DeferredRegister<ParticleType<?>> particles = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"tetra");
    public static final DeferredRegister<MobEffect> effects = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"tetra");
    public static final DeferredRegister<SoundEvent> sounds = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"tetra");
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> lootModifiers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"tetra");
    public static final DeferredRegister<LootItemConditionType> lootConditions = DeferredRegister.create((ResourceKey)Registries.f_256976_, (String)"tetra");
    public static final DeferredRegister<LootItemFunctionType> lootFunctions = DeferredRegister.create((ResourceKey)Registries.f_257015_, (String)"tetra");
    public static final DeferredRegister<StructureProcessorType<?>> structureProcessors = DeferredRegister.create((ResourceKey)Registries.f_256983_, (String)"tetra");
    public static final DeferredRegister<CreativeModeTab> creativeTabs = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"tetra");
    public static final TagKey<Block> forgeHammerBreakTag = BlockTags.create((ResourceLocation)new ResourceLocation("tetra:needs_forge_hammer_tool"));
    public static final Tier forgeHammerTier = TierSortingRegistry.registerTier((Tier)new ForgeTier(Tiers.NETHERITE.m_6604_() + 1, 0, 0.0f, 0.0f, 0, forgeHammerBreakTag, () -> Ingredient.f_43901_), (ResourceLocation)new ResourceLocation("tetra:maxed_forge_hammer"), List.of(Tiers.NETHERITE), List.of());
    private static Item.Properties itemProperties;
    private static RegistryObject<CreativeModeTab> defaultCreativeTabs;
    private static RegistryObject<BasicWorkbenchBlock> basicWorkbench;
    private static RegistryObject<SeepingBedrockBlock> seepingBedrock;
    private static RegistryObject<RackBlock> rack;
    private static RegistryObject<BlockItem> chthonicExtractorItem;
    private static RegistryObject<FracturedBedrockBlock> fracturedBedrock;
    private static RegistryObject<ForgedWallBlock> forgedWall;
    private static RegistryObject<ForgedPillarBlock> forgedPillar;
    private static RegistryObject<ForgedPlatformBlock> forgedPlatform;
    private static RegistryObject<ForgedPlatformSlabBlock> forgedPlatformSlab;
    private static RegistryObject<ForgedVentBlock> forgedVent;
    private static RegistryObject<HammerBaseBlock> forgeHammer;
    private static RegistryObject<ForgedWorkbenchBlock> forgedWorkbench;
    private static RegistryObject<ForgedCrateBlock> forgedCrate;
    private static RegistryObject<TransferUnitBlock> transferUnit;
    private static RegistryObject<BoltItem> bolt;
    private static RegistryObject<DragonSinewItem> dragonSinew;
    private static RegistryObject<StonecutterItem> stonecutter;
    private static RegistryObject<EarthpiercerItem> earthpiercer;
    private static RegistryObject<ModularHolosphereItem> modularHolosphere;
    private static RegistryObject<PlanarStabilizerItem> planarStabilizer;
    private static RegistryObject<InsulatedPlateItem> insulatedPlate;
    private static RegistryObject<QuickLatchItem> quickLatch;
    private static RegistryObject<MeshItem> mesh;
    private static RegistryObject<BeamItem> beam;
    private static RegistryObject<PristineDiamondItem> pristineDiamond;
    private static RegistryObject<PristineEmeraldItem> pristineEmerald;
    private static RegistryObject<PristineLapisItem> pristineLapis;
    private static RegistryObject<PristineAmethystItem> pristineAmethyst;
    private static RegistryObject<PristineQuartzItem> pristineQuartz;
    private static RegistryObject<GeodeItem> geode;

    public static void init(IEventBus bus) {
        bus.register(TetraRegistries.class);
        blocks.register(bus);
        items.register(bus);
        blockEntities.register(bus);
        entities.register(bus);
        particles.register(bus);
        containers.register(bus);
        effects.register(bus);
        sounds.register(bus);
        lootConditions.register(bus);
        lootFunctions.register(bus);
        lootModifiers.register(bus);
        structureProcessors.register(bus);
        creativeTabs.register(bus);
        itemProperties = new Item.Properties();
        defaultCreativeTabs = creativeTabs.register("default", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)GeodeItem.instance)).m_257941_((Component)Component.m_237115_((String)"itemGroup.tetra")).m_257652_());
        basicWorkbench = blocks.register("basic_workbench", BasicWorkbenchBlock::new);
        TetraRegistries.registerBlockItem(basicWorkbench);
        HolosphereBlock.instance = blocks.register("holosphere", HolosphereBlock::new);
        rack = blocks.register("rack", RackBlock::new);
        TetraRegistries.registerBlockItem(rack);
        ArcaneFireBlock.instance = blocks.register("arcane_fire", ArcaneFireBlock::new);
        RegistryObject rolledScroll = blocks.register("scroll_rolled", RolledScrollBlock::new);
        RegistryObject wallScroll = blocks.register("scroll_wall", WallScrollBlock::new);
        RegistryObject openScroll = blocks.register("scroll_open", OpenScrollBlock::new);
        forgedWall = blocks.register("forged_wall", ForgedWallBlock::new);
        TetraRegistries.registerBlockItem(forgedWall);
        forgedPillar = blocks.register("forged_pillar", ForgedPillarBlock::new);
        TetraRegistries.registerBlockItem(forgedPillar);
        forgedPlatform = blocks.register("forged_platform", ForgedPlatformBlock::new);
        TetraRegistries.registerBlockItem(forgedPlatform);
        forgedPlatformSlab = blocks.register("forged_platform_slab", ForgedPlatformSlabBlock::new);
        TetraRegistries.registerBlockItem(forgedPlatformSlab);
        forgedVent = blocks.register("forged_vent", ForgedVentBlock::new);
        TetraRegistries.registerBlockItem(forgedVent);
        blocks.register("hammer_head", HammerHeadBlock::new);
        forgeHammer = blocks.register("hammer_base", HammerBaseBlock::new);
        TetraRegistries.registerBlockItem(forgeHammer);
        forgedWorkbench = blocks.register("forged_workbench", ForgedWorkbenchBlock::new);
        TetraRegistries.registerBlockItem(forgedWorkbench);
        ForgedContainerBlock.instance = blocks.register("forged_container", ForgedContainerBlock::new);
        TetraRegistries.registerBlockItem(ForgedContainerBlock.instance);
        forgedCrate = blocks.register("forged_crate", ForgedCrateBlock::new);
        TetraRegistries.registerBlockItem(forgedCrate);
        transferUnit = blocks.register("transfer_unit", TransferUnitBlock::new);
        TetraRegistries.registerBlockItem(transferUnit);
        RegistryObject chthonicExtractor = blocks.register("chthonic_extractor", ChthonicExtractorBlock::new);
        chthonicExtractorItem = ChthonicExtractorBlock.registerItems(items);
        fracturedBedrock = blocks.register("fractured_bedrock", FracturedBedrockBlock::new);
        blocks.register("depleted_bedrock", DepletedBedrockBlock::new);
        CoreExtractorBaseBlock.instance = blocks.register("core_extractor", CoreExtractorBaseBlock::new);
        TetraRegistries.registerBlockItem(CoreExtractorBaseBlock.instance);
        CoreExtractorPistonBlock.instance = blocks.register("extractor_piston", CoreExtractorPistonBlock::new);
        TetraRegistries.registerBlockItem(blocks.register("extractor_pipe", CoreExtractorPipeBlock::new));
        seepingBedrock = blocks.register("seeping_bedrock", SeepingBedrockBlock::new);
        TetraRegistries.registerBlockItem(seepingBedrock);
        new MultiblockSchematicBlock.Builder("stonecutter", 3, 2, ForgedBlockCommon.propertiesSolid).build(blocks, items);
        new MultiblockSchematicBlock.Builder("earthpiercer", 2, 2, ForgedBlockCommon.propertiesSolid).build(blocks, items);
        new MultiblockSchematicBlock.Builder("extractor", 3, 3, ForgedBlockCommon.propertiesSolid).build(blocks, items);
        blocks.register("block_geode", GeodeBlock::new);
        items.register("modular_sword", ModularBladedItem::new);
        items.register("modular_double", ModularDoubleHeadedItem::new);
        items.register("modular_bow", ModularBowItem::new);
        RegistryObject shootableDummy = items.register("shootable_dummy", ShootableDummyItem::new);
        items.register("modular_crossbow", () -> new ModularCrossbowItem((Item)shootableDummy.get()));
        items.register("modular_single", ModularSingleHeadedItem::new);
        items.register("modular_shield", ModularShieldItem::new);
        ModularToolbeltItem.instance = items.register("modular_toolbelt", ModularToolbeltItem::new);
        modularHolosphere = items.register("holo", ModularHolosphereItem::new);
        items.register("dynamic_handheld", DynamicModularItem::new);
        geode = items.register("geode", GeodeItem::new);
        pristineLapis = items.register("pristine_lapis", PristineLapisItem::new);
        pristineEmerald = items.register("pristine_emerald", PristineEmeraldItem::new);
        pristineDiamond = items.register("pristine_diamond", PristineDiamondItem::new);
        pristineAmethyst = items.register("pristine_amethyst", PristineAmethystItem::new);
        pristineQuartz = items.register("pristine_quartz", PristineQuartzItem::new);
        dragonSinew = items.register("dragon_sinew", DragonSinewItem::new);
        bolt = items.register("forged_bolt", BoltItem::new);
        beam = items.register("forged_beam", BeamItem::new);
        mesh = items.register("forged_mesh", MeshItem::new);
        quickLatch = items.register("quick_latch", QuickLatchItem::new);
        MetalScrapItem.instance = items.register("metal_scrap", MetalScrapItem::new);
        insulatedPlate = items.register("vent_plate", InsulatedPlateItem::new);
        planarStabilizer = items.register("planar_stabilizer", PlanarStabilizerItem::new);
        ThermalCellItem.instance = items.register("thermal_cell", ThermalCellItem::new);
        CombustionChamberItem.instance = items.register("combustion_chamber", CombustionChamberItem::new);
        LubricantDispenserItem.instance = items.register("lubricant_dispenser", LubricantDispenserItem::new);
        earthpiercer = items.register("earthpiercer", EarthpiercerItem::new);
        stonecutter = items.register("stonecutter", StonecutterItem::new);
        items.register("scroll_rolled", () -> new ScrollItem((Block)rolledScroll.get()));
        WorkbenchTile.type = blockEntities.register("workbench", () -> BlockEntityType.Builder.m_155273_(WorkbenchTile::new, (Block[])new Block[]{(Block)basicWorkbench.get(), (Block)forgedWorkbench.get()}).m_58966_(null));
        ChthonicExtractorTile.type = blockEntities.register("chthonic_extractor", () -> BlockEntityType.Builder.m_155273_(ChthonicExtractorTile::new, (Block[])new Block[]{(Block)chthonicExtractor.get()}).m_58966_(null));
        blockEntities.register("fractured_bedrock", () -> BlockEntityType.Builder.m_155273_(FracturedBedrockTile::new, (Block[])new Block[]{(Block)fracturedBedrock.get()}).m_58966_(null));
        blockEntities.register("rack", () -> BlockEntityType.Builder.m_155273_(RackTile::new, (Block[])new Block[]{(Block)rack.get()}).m_58966_(null));
        blockEntities.register("scroll", () -> BlockEntityType.Builder.m_155273_(ScrollTile::new, (Block[])new Block[]{(Block)openScroll.get(), (Block)wallScroll.get(), (Block)rolledScroll.get()}).m_58966_(null));
        HammerBaseBlockEntity.type = blockEntities.register("hammer_base", () -> BlockEntityType.Builder.m_155273_(HammerBaseBlockEntity::new, (Block[])new Block[]{HammerBaseBlock.instance}).m_58966_(null));
        HammerHeadBlockEntity.type = blockEntities.register("hammer_head", () -> BlockEntityType.Builder.m_155273_(HammerHeadBlockEntity::new, (Block[])new Block[]{HammerHeadBlock.instance}).m_58966_(null));
        TransferUnitBlockEntity.type = blockEntities.register("transfer_unit", () -> BlockEntityType.Builder.m_155273_(TransferUnitBlockEntity::new, (Block[])new Block[]{(Block)transferUnit.get()}).m_58966_(null));
        blockEntities.register("core_extractor", () -> BlockEntityType.Builder.m_155273_(CoreExtractorBaseBlockEntity::new, (Block[])new Block[]{(Block)CoreExtractorBaseBlock.instance.get()}).m_58966_(null));
        CoreExtractorPistonBlockEntity.type = blockEntities.register("extractor_piston", () -> BlockEntityType.Builder.m_155273_(CoreExtractorPistonBlockEntity::new, (Block[])new Block[]{(Block)CoreExtractorPistonBlock.instance.get()}).m_58966_(null));
        ForgedContainerBlockEntity.type = blockEntities.register("forged_container", () -> BlockEntityType.Builder.m_155273_(ForgedContainerBlockEntity::new, (Block[])new Block[]{(Block)ForgedContainerBlock.instance.get()}).m_58966_(null));
        HolosphereBlockEntity.type = blockEntities.register("holosphere", () -> BlockEntityType.Builder.m_155273_(HolosphereBlockEntity::new, (Block[])new Block[]{(Block)HolosphereBlock.instance.get()}).m_58966_(null));
        entities.register("thrown_modular_item", () -> EntityType.Builder.m_20704_(ThrownModularItemEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(ThrownModularItemEntity::new).m_20699_(0.5f, 0.5f).m_20712_("thrown_modular_item"));
        entities.register("extractor_projectile", () -> EntityType.Builder.m_20704_(ExtractorProjectileEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(ExtractorProjectileEntity::new).m_20699_(0.5f, 0.5f).m_20712_("extractor_projectile"));
        particles.register("sparkle", () -> new SimpleParticleType(false));
        particles.register("sweeping_strike", SweepingStrikeParticleType::new);
        particles.register("plain", PlainParticleType::new);
        Particles.arcaneFire = particles.register("arcane_fire", () -> new SimpleParticleType(false));
        Particles.splinteredPower = particles.register("splintered_power", () -> new SimpleParticleType(false));
        Particles.sputteringPower = particles.register("sputtering_power", () -> new SimpleParticleType(false));
        DripParticles.fallingBlood = particles.register("falling_blood", () -> new SimpleParticleType(true));
        DripParticles.landingBlood = particles.register("landing_blood", () -> new SimpleParticleType(true));
        DripParticles.fallingSlime = particles.register("falling_slime", () -> new SimpleParticleType(true));
        DripParticles.landingSlime = particles.register("landing_slime", () -> new SimpleParticleType(true));
        ToolbeltContainer.type = containers.register("modular_toolbelt", () -> IForgeMenuType.create((windowId, inv, data) -> ToolbeltContainer.create(windowId, inv)));
        WorkbenchContainer.containerType = containers.register("workbench", () -> IForgeMenuType.create((windowId, inv, data) -> WorkbenchContainer.create(windowId, data.m_130135_(), inv)));
        ForgedContainerMenu.type = containers.register("forged_container", () -> IForgeMenuType.create((windowId, inv, data) -> ForgedContainerMenu.create(windowId, data.m_130135_(), inv)));
        effects.register("bleeding", BleedingPotionEffect::new);
        effects.register("earthbound", EarthboundPotionEffect::new);
        effects.register("stun", StunPotionEffect::new);
        effects.register("howling", HowlingPotionEffect::new);
        effects.register("severed", SeveredPotionEffect::new);
        effects.register("punctured", PuncturedPotionEffect::new);
        effects.register("pried", PriedPotionEffect::new);
        effects.register("exhausted", ExhaustedPotionEffect::new);
        effects.register("steeled", SteeledPotionEffect::new);
        effects.register("small_strength", SmallStrengthPotionEffect::new);
        effects.register("unwavering", UnwaveringPotionEffect::new);
        effects.register("small_health", SmallHealthPotionEffect::new);
        effects.register("small_absorb", SmallAbsorbPotionEffect::new);
        effects.register("suspended", SuspendPotionEffect::new);
        effects.register("mining_speed", MiningSpeedPotionEffect::new);
        effects.register("unstable_power", UnstablePowerMobEffect::new);
        effects.register("satiated", SatiatedPotionEffect::new);
        sounds.register(TetraSounds.scanHit.m_11660_().m_135815_(), () -> TetraSounds.scanHit);
        sounds.register(TetraSounds.scanMiss.m_11660_().m_135815_(), () -> TetraSounds.scanMiss);
        FortuneBonusCondition.type = lootConditions.register("random_chance_with_fortune", () -> new LootItemConditionType((Serializer)new FortuneBonusCondition.ConditionSerializer()));
        ScrollDataFunction.type = lootFunctions.register("scroll", () -> new LootItemFunctionType((Serializer)new ScrollDataFunction.Serializer()));
        lootModifiers.register("replace_table", ReplaceTableModifier.codec);
        ForgedHammerProcessor.type = TetraRegistries.registerStructureProcessor("hammer", () -> ForgedHammerProcessor.codec);
        ForgedCrateProcessor.type = TetraRegistries.registerStructureProcessor("crate", () -> ForgedCrateProcessor.codec);
        ForgedContainerProcessor.type = TetraRegistries.registerStructureProcessor("container", () -> ForgedContainerProcessor.codec);
        TransferUnitProcessor.type = TetraRegistries.registerStructureProcessor("transfer_unit", () -> TransferUnitProcessor.codec);
        MultiblockSchematicProcessor.type = TetraRegistries.registerStructureProcessor("multiblock_schematic", () -> MultiblockSchematicProcessor.codec);
        CraftingHelper.register((ResourceLocation)new ResourceLocation("tetra", "scroll"), (IIngredientSerializer)ScrollIngredient.Serializer.instance);
        CraftingHelper.register((ResourceLocation)new ResourceLocation("tetra", "tool_action"), (IIngredientSerializer)ToolActionIngredient.Serializer.instance);
    }

    public static <B extends Block> RegistryObject<Item> registerBlockItem(RegistryObject<B> block) {
        return items.register(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), itemProperties));
    }

    public static <P extends StructureProcessor> RegistryObject<StructureProcessorType<?>> registerStructureProcessor(String id, StructureProcessorType<P> type) {
        return structureProcessors.register(id, () -> type);
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            try {
                CriteriaTriggers.m_10595_(BlockUseCriterion.trigger);
                CriteriaTriggers.m_10595_(BlockInteractionCriterion.trigger);
                CriteriaTriggers.m_10595_(ModuleCraftCriterion.trigger);
                CriteriaTriggers.m_10595_(ImprovementCraftCriterion.trigger);
                CriteriaTriggers.m_10595_(DestabilizeCriterion.trigger);
                ItemPredicate.register((ResourceLocation)new ResourceLocation("tetra:modular_item"), ItemPredicateModular::new);
                ItemPredicate.register((ResourceLocation)new ResourceLocation("tetra:item_effect"), EffectItemPredicate::new);
                ItemPredicate.register((ResourceLocation)new ResourceLocation("tetra:material"), MaterialItemPredicate::new);
                ItemPredicate.register((ResourceLocation)new ResourceLocation("tetra:loose"), LooseItemPredicate::new);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        blocks.getEntries().stream().map(RegistryObject::get).filter(block -> block instanceof InitializableBlock).map(block -> (InitializableBlock)block).forEach(block -> block.commonInit(TetraMod.packetHandler));
        items.getEntries().stream().map(RegistryObject::get).filter(item -> item instanceof InitializableItem).map(item -> (InitializableItem)item).forEach(item -> item.commonInit(TetraMod.packetHandler));
    }

    @SubscribeEvent
    public static void buildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == defaultCreativeTabs.getKey()) {
            event.accept(basicWorkbench);
            event.m_246342_(ModularHolosphereItem.getCreativeItemStack());
            event.accept(rack);
            event.m_246601_(ModularDoubleHeadedItem.getCreativeTabItemStacks());
            event.m_246601_(ModularBladedItem.getCreativeTabItemStacks());
            event.m_246601_(ModularToolbeltItem.getCreativeTabItemStacks());
            event.accept(geode);
            event.accept(pristineLapis);
            event.accept(pristineEmerald);
            event.accept(pristineDiamond);
            event.accept(pristineAmethyst);
            event.accept(dragonSinew);
            event.m_246601_(ScrollItem.instance.getCreativeTabItems());
            event.accept(bolt);
            event.accept(beam);
            event.accept(mesh);
            event.accept(quickLatch);
            event.accept(MetalScrapItem.instance);
            event.accept(insulatedPlate);
            event.accept(planarStabilizer);
            event.accept(CombustionChamberItem.instance);
            event.accept(LubricantDispenserItem.instance);
            event.accept(ThermalCellItem.instance);
            event.accept(earthpiercer);
            event.accept(stonecutter);
            event.accept(chthonicExtractorItem);
            event.accept(forgedWall);
            event.accept(forgedPillar);
            event.accept(forgedPlatform);
            event.accept(forgedPlatformSlab);
            event.accept(forgedVent);
            event.accept(forgeHammer);
            event.accept(forgedWorkbench);
            event.accept(ForgedContainerBlock.instance);
            event.accept(forgedCrate);
            event.accept(transferUnit);
            event.accept(CoreExtractorBaseBlock.instance);
            event.m_246326_((ItemLike)CoreExtractorPipeBlock.instance);
            event.accept(seepingBedrock);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            try {
                blocks.getEntries().stream().map(RegistryObject::get).filter(block -> block instanceof InitializableBlock).map(block -> (InitializableBlock)block).forEach(InitializableBlock::clientInit);
                items.getEntries().stream().map(RegistryObject::get).filter(item -> item instanceof InitializableItem).map(item -> (InitializableItem)item).forEach(InitializableItem::clientInit);
                MinecraftForge.EVENT_BUS.register((Object)new InteractiveBlockOverlay());
                HoloStatsGui.initializeStaticBars();
                WorkbenchStatsGui.initializeStaticBars();
                StatSorters.initializeStaticSorters();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

