/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.patreon;

import io.github.flemmli97.tenshilib.patreon.PatreonDataManager;
import io.github.flemmli97.tenshilib.patreon.PatreonEffects;
import io.github.flemmli97.tenshilib.patreon.RenderLocation;
import io.github.flemmli97.tenshilib.patreon.pkts.C2SEffectUpdatePkt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;

public class PatreonPlayerSetting {
    private PatreonEffects.PatreonEffectConfig conf;
    private RenderLocation renderLocation = RenderLocation.HAT;
    private boolean render = true;
    private int color;
    private final Player player;
    private boolean newSetting = true;

    public PatreonPlayerSetting(Player player) {
        this.player = player;
    }

    public void setToDefault(boolean forced) {
        if (forced || this.newSetting) {
            PatreonDataManager.PatreonPlayerInfo info = PatreonDataManager.get(this.player.m_20148_().toString());
            if (info.tier() > 0) {
                this.setEffect(PatreonEffects.get(info.defaultEffect()));
                if (info.defaultRenderLocation() != null) {
                    this.renderLocation = info.defaultRenderLocation();
                }
                this.color = info.color();
            } else {
                this.conf = null;
            }
        }
    }

    public void setEffect(PatreonEffects.PatreonEffectConfig conf) {
        this.conf = conf;
        if (this.conf != null) {
            this.renderLocation = this.conf.defaultLoc();
            this.color = this.conf.defaultColor();
        }
    }

    public PatreonEffects.PatreonEffectConfig effect() {
        return this.conf;
    }

    public boolean shouldRender() {
        return this.render;
    }

    public RenderLocation getRenderLocation() {
        return this.renderLocation;
    }

    public int getColor() {
        return this.color;
    }

    public CompoundTag save(CompoundTag tag) {
        if (this.conf != null) {
            tag.m_128359_("Effect", this.conf.id());
        }
        tag.m_128405_("Location", this.renderLocation.ordinal());
        tag.m_128379_("ShouldRender", this.render);
        tag.m_128405_("Color", this.color);
        return tag;
    }

    public void read(CompoundTag tag) {
        if (tag.m_128441_("Effect")) {
            this.setEffect(PatreonEffects.get(tag.m_128461_("Effect")));
        }
        RenderLocation loc = RenderLocation.values()[tag.m_128451_("Location")];
        if (this.conf != null) {
            this.renderLocation = this.conf.locationAllowed(loc) ? loc : this.conf.defaultLoc();
        }
        this.render = tag.m_128471_("ShouldRender");
        this.color = tag.m_128451_("Color");
        this.newSetting = false;
    }

    public void read(C2SEffectUpdatePkt pkt, String id) {
        this.conf = PatreonEffects.get(id);
        RenderLocation loc = pkt.location;
        if (this.conf != null) {
            this.renderLocation = this.conf.locationAllowed(loc) ? loc : this.conf.defaultLoc();
        }
        this.render = pkt.render;
        this.color = pkt.color;
    }

    public void update(PatreonEffects.PatreonEffectConfig effect, RenderLocation location, boolean render, int color) {
        this.conf = effect;
        if (this.conf != null) {
            this.renderLocation = this.conf.locationAllowed(location) ? location : this.conf.defaultLoc();
        }
        this.render = render;
        this.color = color;
    }
}

