/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

public class JsonUtils {
    public static int get(JsonObject obj, String key, int fallback) {
        try {
            return obj.get(key).getAsInt();
        }
        catch (NullPointerException | UnsupportedOperationException e) {
            return fallback;
        }
    }

    public static float get(JsonObject obj, String key, float fallback) {
        try {
            return obj.get(key).getAsFloat();
        }
        catch (NullPointerException | UnsupportedOperationException e) {
            return fallback;
        }
    }

    public static double get(JsonObject obj, String key, double fallback) {
        try {
            return obj.get(key).getAsDouble();
        }
        catch (NullPointerException | UnsupportedOperationException e) {
            return fallback;
        }
    }

    public static boolean get(JsonObject obj, String key, boolean fallback) {
        try {
            return obj.get(key).getAsBoolean();
        }
        catch (NullPointerException | UnsupportedOperationException e) {
            return fallback;
        }
    }

    public static String get(JsonObject obj, String key, String fallback) {
        try {
            return obj.get(key).getAsString();
        }
        catch (NullPointerException | UnsupportedOperationException e) {
            return fallback;
        }
    }

    public static JsonObject getObj(JsonObject obj, String key) {
        try {
            return obj.get(key).getAsJsonObject();
        }
        catch (NullPointerException | UnsupportedOperationException e) {
            return new JsonObject();
        }
    }

    public static JsonArray getArray(JsonObject obj, String key) {
        try {
            return obj.get(key).getAsJsonArray();
        }
        catch (NullPointerException | UnsupportedOperationException e) {
            return new JsonArray();
        }
    }
}

