/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity;

import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.phys.Vec3;

public class CustomDataSerializers {
    private static boolean REGISTERED = false;
    public static final EntityDataSerializer<Vec3> VEC = new EntityDataSerializer<Vec3>(){

        public void write(FriendlyByteBuf buffer, Vec3 value) {
            buffer.writeDouble(value.m_7096_());
            buffer.writeDouble(value.m_7098_());
            buffer.writeDouble(value.m_7094_());
        }

        public Vec3 read(FriendlyByteBuf buffer) {
            return new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }

        public Vec3 copy(Vec3 value) {
            return value;
        }
    };
    public static final EntityDataSerializer<Optional<Vec3>> OPTIONAL_VEC = new EntityDataSerializer<Optional<Vec3>>(){

        public void write(FriendlyByteBuf buffer, Optional<Vec3> value) {
            buffer.writeBoolean(value.isPresent());
            value.ifPresent(vec -> {
                buffer.writeDouble(vec.m_7096_());
                buffer.writeDouble(vec.m_7098_());
                buffer.writeDouble(vec.m_7094_());
            });
        }

        public Optional<Vec3> read(FriendlyByteBuf buffer) {
            if (!buffer.readBoolean()) {
                return Optional.empty();
            }
            return Optional.of(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()));
        }

        public Optional<Vec3> copy(Optional<Vec3> value) {
            return value;
        }
    };

    public static void register() {
        if (REGISTERED) {
            return;
        }
        REGISTERED = true;
        EntityDataSerializers.m_135050_(VEC);
        EntityDataSerializers.m_135050_(OPTIONAL_VEC);
    }
}

