/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.flemmli97.tenshilib.TenshiLib;
import io.github.flemmli97.tenshilib.common.config.CommentedJsonConfig;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class JsonConfig<T> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Path file;
    private T element;
    private final Class<T> type;
    private boolean mcRestart;
    private boolean worldRestart;
    private String name;
    private Gson gson = GSON;

    public JsonConfig(Path file, Class<T> type, @Nullable T defaultValue) {
        this.file = file;
        this.type = type;
        this.name = this.file.getFileName().toString();
        this.element = defaultValue;
        if (!Files.exists(file, new LinkOption[0])) {
            file.getParent().toFile().mkdirs();
            try {
                Files.createFile(file, new FileAttribute[0]);
                if (this.element != null) {
                    this.save();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.load();
    }

    public JsonConfig(Path file, Class<T> type, @Nullable Path defaultConfig) {
        this.file = file;
        this.type = type;
        this.name = this.file.getFileName().toString();
        if (!Files.exists(file, new LinkOption[0])) {
            file.getParent().toFile().mkdirs();
            try {
                Files.createFile(file, new FileAttribute[0]);
                if (defaultConfig != null && Files.exists(defaultConfig, new LinkOption[0])) {
                    Files.copy(defaultConfig, file, new CopyOption[0]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.load();
    }

    public JsonConfig<T> setGson(Gson gson) {
        this.gson = gson;
        this.load();
        return this;
    }

    public Path getConfigPath() {
        return this.file;
    }

    public T getElement() {
        return this.element;
    }

    public JsonConfig<T> setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setElement(T element) {
        this.element = element;
    }

    public JsonConfig<T> setMCRestart(boolean flag) {
        this.mcRestart = flag;
        return this;
    }

    public JsonConfig<T> setWorldRestart(boolean flag) {
        this.worldRestart = flag;
        return this;
    }

    public boolean mcRestart() {
        return this.mcRestart;
    }

    public boolean worldRestart() {
        return this.worldRestart;
    }

    public void load() {
        try {
            FileReader reader = new FileReader(this.file.toFile());
            T t = this.element;
            if (t instanceof CommentedJsonConfig) {
                CommentedJsonConfig conf = (CommentedJsonConfig)t;
                Set<String> faulty = conf.deserialize((JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class), this.gson);
                if (!faulty.isEmpty()) {
                    throw new JsonSyntaxException("Faulty keys " + faulty + ". They will get corrected to their default values.");
                }
            } else {
                this.element = this.gson.fromJson((Reader)reader, this.type);
            }
            reader.close();
        }
        catch (JsonSyntaxException | IllegalStateException e) {
            try {
                TenshiLib.LOGGER.error("Json config doesn't match expected config. Creating a backup. This is probably caused either by a config update or malformed json.");
                e.printStackTrace();
                int back = 0;
                String file = this.file.getFileName().toString() + "_back";
                while (Files.exists(this.file.getParent().resolve(file), new LinkOption[0])) {
                    file = file + ++back;
                }
                Files.copy(this.file, this.file.getParent().resolve(file), new CopyOption[0]);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.save();
    }

    public void save() {
        try {
            FileWriter writer = new FileWriter(this.file.toFile());
            T t = this.element;
            if (t instanceof CommentedJsonConfig) {
                CommentedJsonConfig conf = (CommentedJsonConfig)t;
                this.gson.toJson((JsonElement)conf.serialize(this.gson), (Appendable)writer);
            } else {
                this.gson.toJson(this.element, (Appendable)writer);
            }
            writer.close();
        }
        catch (JsonIOException | IOException e) {
            e.printStackTrace();
        }
    }
}

