/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.propellant.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.config.BigCannonPropellantPropertiesComponent;
import rbasamoyai.createbigcannons.munitions.big_cannon.propellant.config.BigCartridgeProperties;
import rbasamoyai.createbigcannons.munitions.config.BlockPropertiesTypeHandler;

public class BigCartridgePropertiesHandler
extends BlockPropertiesTypeHandler<BigCartridgeProperties> {
    private static final BigCartridgeProperties DEFAULT = new BigCartridgeProperties(BigCannonPropellantPropertiesComponent.DEFAULT, 0);

    @Override
    protected BigCartridgeProperties parseJson(ResourceLocation location, JsonObject obj) throws JsonParseException {
        String id = location.toString();
        BigCannonPropellantPropertiesComponent propellantProperties = BigCannonPropellantPropertiesComponent.fromJson(id, obj);
        int maxPowerLevels = Mth.m_14045_((int)BigCartridgePropertiesHandler.getOrWarn(obj, "maximum_power_levels", id, 4, JsonElement::getAsInt), (int)1, (int)20);
        return new BigCartridgeProperties(propellantProperties, maxPowerLevels);
    }

    @Override
    protected BigCartridgeProperties readPropertiesFromNetwork(Block block, FriendlyByteBuf buf) {
        BigCannonPropellantPropertiesComponent propellantProperties = BigCannonPropellantPropertiesComponent.fromNetwork(buf);
        int maxPowerLevels = buf.m_130242_();
        return new BigCartridgeProperties(propellantProperties, maxPowerLevels);
    }

    @Override
    protected void writePropertiesToNetwork(BigCartridgeProperties properties, FriendlyByteBuf buf) {
        properties.propellantProperties().toNetwork(buf);
        buf.m_130130_(properties.maxPowerLevels());
    }

    @Override
    protected BigCartridgeProperties getNoPropertiesValue() {
        return DEFAULT;
    }
}

