/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.autocannon;

import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.munitions.autocannon.AutocannonAmmoItem;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AutocannonAmmoType {
    AUTOCANNON{

        @Override
        public int getCapacity() {
            return (Integer)CBCConfigs.server().munitions.ammoContainerAutocannonRoundCapacity.get();
        }
    }
    ,
    MACHINE_GUN{

        @Override
        public int getCapacity() {
            return (Integer)CBCConfigs.server().munitions.ammoContainerMachineGunRoundCapacity.get();
        }
    }
    ,
    NONE{

        @Override
        public int getCapacity() {
            return 0;
        }

        @Override
        public boolean isValidMunition(ItemStack stack) {
            return 3.of(stack) != this;
        }
    };


    public abstract int getCapacity();

    public boolean isValidMunition(ItemStack stack) {
        return AutocannonAmmoType.of(stack) == this;
    }

    public static AutocannonAmmoType of(ItemStack stack) {
        AutocannonAmmoType autocannonAmmoType;
        Item item = stack.m_41720_();
        if (item instanceof AutocannonAmmoItem) {
            AutocannonAmmoItem item2 = (AutocannonAmmoItem)item;
            autocannonAmmoType = item2.getType();
        } else {
            autocannonAmmoType = NONE;
        }
        return autocannonAmmoType;
    }
}

