/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.block_hit_effects.BlockImpactTransformationHandler;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.effects.particles.explosions.ShellBlastWaveEffectParticleData;
import rbasamoyai.createbigcannons.effects.particles.explosions.ShellExplosionCloudParticleData;
import rbasamoyai.createbigcannons.index.CBCSoundEvents;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.network.ClientboundCBCExplodePacket;
import rbasamoyai.createbigcannons.remix.CustomExplosion;

public class ShellExplosion
extends CustomExplosion.Impl {
    private final Set<BlockPos> changedBlocks = new HashSet<BlockPos>();
    private final boolean isPlume;
    private final boolean noEffects;

    public ShellExplosion(Level level, @Nullable Entity source, @Nullable DamageSource damageSource, double toBlowX, double toBlowY, double toBlowZ, float radius, boolean fire, Level.ExplosionInteraction interaction, boolean noEffects) {
        super(level, source, damageSource, null, toBlowX, toBlowY, toBlowZ, radius, fire, interaction);
        BlockPos pos = BlockPos.m_274561_((double)this.x, (double)this.y, (double)this.z);
        this.isPlume = this.level.m_8055_(pos.m_7494_()).m_60795_() && !this.level.m_8055_(pos.m_7495_()).m_60795_();
        this.noEffects = noEffects;
    }

    public ShellExplosion(Level level, @Nullable Entity source, @Nullable DamageSource damageSource, double toBlowX, double toBlowY, double toBlowZ, float radius, boolean fire, Level.ExplosionInteraction interaction) {
        this(level, source, damageSource, toBlowX, toBlowY, toBlowZ, radius, fire, interaction, false);
    }

    public ShellExplosion(Level level, ClientboundCBCExplodePacket packet) {
        super(level, packet);
        BlockPos pos = BlockPos.m_274561_((double)this.x, (double)this.y, (double)this.z);
        this.isPlume = this.level.m_8055_(pos.m_7494_()).m_60795_() && !this.level.m_8055_(pos.m_7495_()).m_60795_();
        this.noEffects = packet.explosionType() == ClientboundCBCExplodePacket.ExplosionType.SHELL_NO_EFFECTS;
    }

    @Override
    protected void spawnParticles() {
        if (this.noEffects) {
            return;
        }
        ShellBlastWaveEffectParticleData blastWave = new ShellBlastWaveEffectParticleData(this.size * 12.0f, (Holder<SoundEvent>)BuiltInRegistries.f_256894_.m_263177_((Object)CBCSoundEvents.SHELL_EXPLOSION.getMainEvent()), SoundSource.BLOCKS, Math.max(this.size * 2.0f, 16.0f), 0.8f + this.level.f_46441_.m_188501_() * 0.4f, 2.0f, this.size);
        ShellExplosionCloudParticleData explosionCloud = new ShellExplosionCloudParticleData(this.size, this.isPlume);
        this.level.m_6493_((ParticleOptions)blastWave, true, this.x, this.y, this.z, 0.0, 0.0, 0.0);
        this.level.m_6493_((ParticleOptions)explosionCloud, true, this.x, this.y, this.z, 0.0, 0.0, 0.0);
    }

    @Override
    public void editBlock(Level level, BlockPos pos, BlockState blockState, FluidState fluidState, float power) {
        if (this.noEffects || !((Boolean)CBCConfigs.server().munitions.projectilesChangeSurroundings.get()).booleanValue() || this.changedBlocks.contains(pos)) {
            return;
        }
        BlockState transformed = BlockImpactTransformationHandler.transformBlock(blockState);
        level.m_7731_(pos, transformed, 11);
        this.changedBlocks.add(pos);
    }

    @Override
    public void sendExplosionToClient(ServerPlayer player) {
        double distSqr = player.m_20275_(this.x, this.y, this.z);
        if (distSqr < 263000.0) {
            Vec3 knockback = this.m_46078_().getOrDefault(player, Vec3.f_82478_);
            ClientboundCBCExplodePacket.ExplosionType type = this.noEffects ? ClientboundCBCExplodePacket.ExplosionType.SHELL_NO_EFFECTS : ClientboundCBCExplodePacket.ExplosionType.SHELL;
            NetworkPlatform.sendToClientPlayer(new ClientboundCBCExplodePacket(this.x, this.y, this.z, this.size, this.m_46081_(), (float)knockback.f_82479_, (float)knockback.f_82480_, (float)knockback.f_82481_, type), player);
        }
    }
}

