/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.foundry;

import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.index.CBCRecipeTypes;

public class BasinFoundryBlockEntity
extends BasinOperatingBlockEntity {
    public int meltingTime;
    public int recipeCooldown;
    public boolean running;
    private static final Object BASIN_MELTING_RECIPE_KEY = new Object();

    public BasinFoundryBlockEntity(BlockEntityType<? extends BasinFoundryBlockEntity> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("MeltingTime", this.meltingTime);
        compound.m_128379_("Running", this.running);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.meltingTime = compound.m_128451_("MeltingTime");
        this.running = compound.m_128471_("Running");
    }

    protected boolean isRunning() {
        return this.running;
    }

    protected void onBasinRemoved() {
        if (!this.running) {
            return;
        }
        this.meltingTime = 0;
        this.currentRecipe = null;
        this.running = false;
    }

    public void tick() {
        super.tick();
        if (!(this.m_58904_().f_46443_ || this.currentRecipe != null && this.meltingTime != -1)) {
            --this.recipeCooldown;
            if (this.recipeCooldown <= 0) {
                this.running = false;
                this.meltingTime = -1;
                this.basinChecker.scheduleUpdate();
                this.recipeCooldown = 20;
            }
        } else {
            this.recipeCooldown = 0;
        }
        if (this.running && this.m_58904_() != null) {
            if (this.m_58904_().f_46443_ && this.meltingTime > 0) {
                this.renderParticles();
            }
            if (!this.m_58904_().f_46443_ && this.meltingTime <= 0) {
                this.meltingTime = -1;
                this.applyBasinRecipe();
                this.sendData();
            }
            if (this.meltingTime > 0) {
                --this.meltingTime;
            }
        }
    }

    private void renderParticles() {
        float angle = this.m_58904_().f_46441_.m_188501_() * 360.0f;
        Vec3 offset = new Vec3(0.0, 0.0, 0.25);
        offset = VecHelper.rotate((Vec3)offset, (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 target = VecHelper.rotate((Vec3)offset, (double)-25.0, (Direction.Axis)Direction.Axis.Y).m_82520_(0.0, 0.5, 0.0);
        Vec3 center = offset.m_82549_(Vec3.m_82539_((Vec3i)this.f_58858_));
        target = VecHelper.offsetRandomly((Vec3)target.m_82546_(offset), (RandomSource)this.m_58904_().f_46441_, (float)0.0078125f);
        this.m_58904_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49991_.m_49966_()), center.f_82479_, center.f_82480_ + 0.3, center.f_82481_, target.f_82479_, target.f_82480_, target.f_82481_);
    }

    protected boolean updateBasin() {
        if (this.running) {
            return true;
        }
        if (this.m_58904_() == null || this.m_58904_().f_46443_) {
            return true;
        }
        if (!this.getBasin().filter(BasinBlockEntity::canContinueProcessing).isPresent()) {
            return true;
        }
        List recipes = this.getMatchingRecipes();
        if (recipes.isEmpty()) {
            return true;
        }
        this.currentRecipe = (Recipe)recipes.get(0);
        this.startProcessingBasin();
        this.sendData();
        return true;
    }

    public void startProcessingBasin() {
        int n;
        if (this.running && this.meltingTime > 0) {
            return;
        }
        super.startProcessingBasin();
        this.running = true;
        Recipe recipe = this.currentRecipe;
        if (recipe instanceof ProcessingRecipe) {
            ProcessingRecipe processed = (ProcessingRecipe)recipe;
            n = processed.getProcessingDuration();
        } else {
            n = 20;
        }
        this.meltingTime = n;
    }

    protected <C extends Container> boolean matchStaticFilters(Recipe<C> recipe) {
        return recipe.m_6671_() == CBCRecipeTypes.MELTING.getType();
    }

    protected Object getRecipeCacheKey() {
        return BASIN_MELTING_RECIPE_KEY;
    }

    protected Optional<BasinBlockEntity> getBasin() {
        Optional<BasinBlockEntity> optional;
        BlockEntity blockEntity;
        if (this.m_58904_() != null && (blockEntity = this.m_58904_().m_7702_(this.f_58858_.m_7495_())) instanceof BasinBlockEntity) {
            BasinBlockEntity basin = (BasinBlockEntity)blockEntity;
            optional = Optional.of(basin);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }
}

