/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.autocannon.material;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;

public record AutocannonMaterialProperties(int maxBarrelLength, float weight, float baseSpread, float spreadReductionPerBarrel, float baseSpeed, float speedIncreasePerBarrel, int maxSpeedIncreases, int projectileLifetime, float baseRecoil, boolean connectsInSurvival, boolean isWeldable, int weldDamage, int weldStressPenalty) {
    public static AutocannonMaterialProperties fromJson(JsonObject obj) {
        int maxBarrelLength = Math.max(1, GsonHelper.m_13927_((JsonObject)obj, (String)"maximum_barrel_length"));
        float weight = Math.max(0.0f, GsonHelper.m_13820_((JsonObject)obj, (String)"weight", (float)2.0f));
        float baseSpread = Math.max(0.01f, GsonHelper.m_13820_((JsonObject)obj, (String)"base_spread", (float)3.0f));
        float spreadReductionPerBarrel = Math.max(0.0f, GsonHelper.m_13820_((JsonObject)obj, (String)"spread_reduction_per_barrel", (float)0.5f));
        float baseSpeed = Math.max(0.1f, GsonHelper.m_13820_((JsonObject)obj, (String)"base_speed", (float)1.0f));
        float speedIncreasePerBarrel = Math.max(0.0f, GsonHelper.m_13820_((JsonObject)obj, (String)"speed_increase_per_barrel", (float)0.5f));
        int maxSpeedIncreases = Math.max(0, GsonHelper.m_13824_((JsonObject)obj, (String)"max_speed_increases", (int)2));
        int projectileLifetime = Math.max(1, GsonHelper.m_13927_((JsonObject)obj, (String)"projectile_lifetime"));
        float baseRecoil = Math.max(0.0f, GsonHelper.m_13820_((JsonObject)obj, (String)"base_recoil", (float)1.0f));
        boolean connectsInSurvival = GsonHelper.m_13855_((JsonObject)obj, (String)"connects_in_survival", (boolean)false);
        boolean isWeldable = GsonHelper.m_13855_((JsonObject)obj, (String)"is_weldable", (boolean)false);
        int weldDamage = Math.max(GsonHelper.m_13824_((JsonObject)obj, (String)"weld_damage", (int)0), 0);
        int weldStressPenalty = Math.max(GsonHelper.m_13824_((JsonObject)obj, (String)"weld_stress_penalty", (int)0), 0);
        return new AutocannonMaterialProperties(maxBarrelLength, weight, baseSpread, spreadReductionPerBarrel, baseSpeed, speedIncreasePerBarrel, maxSpeedIncreases, projectileLifetime, baseRecoil, connectsInSurvival, isWeldable, weldDamage, weldStressPenalty);
    }

    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("maximum_barrel_length", (Number)this.maxBarrelLength);
        obj.addProperty("weight", (Number)Float.valueOf(this.weight));
        obj.addProperty("base_spread", (Number)Float.valueOf(this.baseSpread));
        obj.addProperty("spread_reduction_per_barrel", (Number)Float.valueOf(this.spreadReductionPerBarrel));
        obj.addProperty("base_speed", (Number)Float.valueOf(this.baseSpeed));
        obj.addProperty("speed_increase_per_barrel", (Number)Float.valueOf(this.speedIncreasePerBarrel));
        obj.addProperty("max_speed_increases", (Number)this.maxSpeedIncreases);
        obj.addProperty("projectile_lifetime", (Number)this.projectileLifetime);
        obj.addProperty("base_recoil", (Number)Float.valueOf(this.baseRecoil));
        obj.addProperty("connects_in_survival", Boolean.valueOf(this.connectsInSurvival));
        obj.addProperty("is_weldable", Boolean.valueOf(this.isWeldable));
        obj.addProperty("weld_damage", (Number)this.weldDamage);
        obj.addProperty("weld_stress_penalty", (Number)this.weldStressPenalty);
        return obj;
    }

    public void writeBuf(FriendlyByteBuf buf) {
        buf.m_130130_(this.maxBarrelLength);
        buf.writeFloat(this.weight).writeFloat(this.baseSpread).writeFloat(this.spreadReductionPerBarrel).writeFloat(this.baseSpeed).writeFloat(this.speedIncreasePerBarrel);
        buf.m_130130_(this.maxSpeedIncreases).m_130130_(this.projectileLifetime).writeFloat(this.baseRecoil).writeBoolean(this.connectsInSurvival).writeBoolean(this.isWeldable);
        buf.m_130130_(this.weldDamage).m_130130_(this.weldStressPenalty);
    }

    public static AutocannonMaterialProperties fromBuf(FriendlyByteBuf buf) {
        int maxBarrelLength = buf.m_130242_();
        float weight = buf.readFloat();
        float baseSpread = buf.readFloat();
        float spreadReductionPerBarrel = buf.readFloat();
        float baseSpeed = buf.readFloat();
        float speedIncreasePerBarrel = buf.readFloat();
        int maxSpeedIncreases = buf.m_130242_();
        int projectileLifetime = buf.m_130242_();
        float baseRecoil = buf.readFloat();
        boolean connectsInSurvival = buf.readBoolean();
        boolean isWeldable = buf.readBoolean();
        int weldDamage = buf.m_130242_();
        int weldStressPenalty = buf.m_130242_();
        return new AutocannonMaterialProperties(maxBarrelLength, weight, baseSpread, spreadReductionPerBarrel, baseSpeed, speedIncreasePerBarrel, maxSpeedIncreases, projectileLifetime, baseRecoil, connectsInSurvival, isWeldable, weldDamage, weldStressPenalty);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int maxBarrelLength;
        private float weight;
        private float baseSpread;
        private float spreadReductionPerBarrel;
        private float baseSpeed;
        private float speedIncreasePerBarrel;
        private int maxSpeedIncreases;
        private int projectileLifetime;
        private float baseRecoil;
        private boolean connectsInSurvival;
        private boolean isWeldable;
        private int weldDamage;
        private int weldStressPenalty;

        private Builder() {
        }

        public Builder maxBarrelLength(int maxBarrelLength) {
            this.maxBarrelLength = maxBarrelLength;
            return this;
        }

        public Builder weight(float weight) {
            this.weight = weight;
            return this;
        }

        public Builder baseSpread(float baseSpread) {
            this.baseSpread = baseSpread;
            return this;
        }

        public Builder spreadReductionPerBarrel(float spreadReductionPerBarrel) {
            this.spreadReductionPerBarrel = spreadReductionPerBarrel;
            return this;
        }

        public Builder baseSpeed(float baseSpeed) {
            this.baseSpeed = baseSpeed;
            return this;
        }

        public Builder speedIncreasePerBarrel(float speedIncreasePerBarrel) {
            this.speedIncreasePerBarrel = speedIncreasePerBarrel;
            return this;
        }

        public Builder maxSpeedIncreases(int maxSpeedIncreases) {
            this.maxSpeedIncreases = maxSpeedIncreases;
            return this;
        }

        public Builder projectileLifetime(int projectileLifetime) {
            this.projectileLifetime = projectileLifetime;
            return this;
        }

        public Builder baseRecoil(float baseRecoil) {
            this.baseRecoil = baseRecoil;
            return this;
        }

        public Builder connectsInSurvival(boolean connectsInSurvival) {
            this.connectsInSurvival = connectsInSurvival;
            return this;
        }

        public Builder isWeldable(boolean isWeldable) {
            this.isWeldable = isWeldable;
            return this;
        }

        public Builder weldDamage(int weldDamage) {
            this.weldDamage = weldDamage;
            return this;
        }

        public Builder weldStressPenalty(int weldStressPenalty) {
            this.weldStressPenalty = weldStressPenalty;
            return this;
        }

        public AutocannonMaterialProperties build() {
            return new AutocannonMaterialProperties(this.maxBarrelLength, this.weight, this.baseSpread, this.spreadReductionPerBarrel, this.baseSpeed, this.speedIncreasePerBarrel, this.maxSpeedIncreases, this.projectileLifetime, this.baseRecoil, this.connectsInSurvival, this.isWeldable, this.weldDamage, this.weldStressPenalty);
        }
    }
}

