/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.common.entity.goal;

import com.teamabnormals.neapolitan.common.entity.animal.Chimpanzee;
import com.teamabnormals.neapolitan.common.entity.projectile.BananaPeel;
import com.teamabnormals.neapolitan.common.entity.util.ChimpanzeeAction;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBlocks;
import com.teamabnormals.neapolitan.core.registry.NeapolitanEntityTypes;
import com.teamabnormals.neapolitan.core.registry.NeapolitanItems;
import com.teamabnormals.neapolitan.core.registry.NeapolitanPoiTypes;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ChimpShakeBundleGoal
extends Goal {
    private static final Predicate<Holder<PoiType>> BUNDLE_PREDICATE = holder -> holder.m_203565_(NeapolitanPoiTypes.BANANA_BUNDLE.getKey());
    private final Chimpanzee chimpanzee;
    private final Level level;
    private final PoiManager poiManager;
    private final double moveSpeed;
    private BlockPos targetPos;
    private BlockPos bundlePos;
    private int nextStartTick;
    private int tryTicks;
    private int maxStayTicks;
    private int shakingTime;
    private int nextBananaTime;

    public ChimpShakeBundleGoal(Chimpanzee chimpanzee, double moveSpeed) {
        this.chimpanzee = chimpanzee;
        this.level = chimpanzee.m_9236_();
        this.poiManager = ((ServerLevel)this.level).m_8904_();
        this.moveSpeed = moveSpeed;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.chimpanzee.isDirty() || this.chimpanzee.needsSunlight()) {
            return false;
        }
        if (!this.chimpanzee.needsSnack()) {
            return false;
        }
        if (this.chimpanzee.m_6162_()) {
            return false;
        }
        if (this.chimpanzee.m_20159_()) {
            return false;
        }
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        this.nextStartTick = ChimpShakeBundleGoal.m_186073_((int)(200 + this.chimpanzee.m_217043_().m_188503_(200)));
        return this.findNearestShakeableBundle();
    }

    public boolean m_8045_() {
        if (this.shakingTime > 160) {
            return false;
        }
        if (this.chimpanzee.m_20159_()) {
            return false;
        }
        if (!this.level.m_8055_(this.bundlePos).m_60713_((Block)NeapolitanBlocks.BANANA_BUNDLE.get()) || this.findSafeGroundBelow(this.bundlePos) == null) {
            return false;
        }
        if (this.isBundleOccupiedByOther(this.bundlePos)) {
            return false;
        }
        return this.tryTicks >= -this.maxStayTicks && this.tryTicks <= 1200;
    }

    public void m_8056_() {
        this.tryTicks = 0;
        this.maxStayTicks = this.chimpanzee.m_217043_().m_188503_(this.chimpanzee.m_217043_().m_188503_(1200) + 1200) + 1200;
        this.shakingTime = 0;
        this.nextBananaTime = 30 + this.getNextBananaTime();
        this.chimpanzee.setLookingForBundle(true);
        this.chimpanzee.m_21573_().m_26519_((double)this.targetPos.m_123341_() + 0.5, (double)this.targetPos.m_123342_() + 1.0, (double)this.targetPos.m_123343_() + 0.5, this.moveSpeed);
    }

    public void m_8041_() {
        this.chimpanzee.setDefaultAction();
        this.chimpanzee.setLookingForBundle(false);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        this.chimpanzee.m_21563_().m_24950_((double)this.bundlePos.m_123341_() + 0.5, (double)this.bundlePos.m_123342_() + 0.5, (double)this.bundlePos.m_123343_() + 0.5, (float)(this.chimpanzee.m_8085_() + 20), (float)this.chimpanzee.m_8132_());
        if (this.chimpanzee.m_20227_(1.0) <= (double)this.bundlePos.m_123342_() && this.bundlePos.m_203195_((Position)this.chimpanzee.m_20182_().m_82520_(0.0, (double)this.chimpanzee.m_20206_(), 0.0), 1.0)) {
            this.chimpanzee.m_20256_(new Vec3(0.0, 0.1, 0.0));
            if (this.shakingTime > 30) {
                this.chimpanzee.setAction(ChimpanzeeAction.SHAKING);
                if (this.shakingTime >= this.nextBananaTime) {
                    double d0 = (double)this.bundlePos.m_123341_() + this.chimpanzee.m_217043_().m_188500_() * 0.5 + 0.25;
                    double d1 = (double)this.bundlePos.m_123343_() + this.chimpanzee.m_217043_().m_188500_() * 0.5 + 0.25;
                    if (this.chimpanzee.m_217043_().m_188503_(4) == 0) {
                        BananaPeel bananapeel = (BananaPeel)((EntityType)NeapolitanEntityTypes.BANANA_PEEL.get()).m_20615_(this.level);
                        bananapeel.m_7678_(d0, (double)this.bundlePos.m_123342_() - 0.5, d1, this.chimpanzee.m_146908_(), 0.0f);
                        bananapeel.m_20334_(this.chimpanzee.m_217043_().m_188500_() * 0.4 - 0.2, -0.1, this.chimpanzee.m_217043_().m_188500_() * 0.4 - 0.2);
                        this.level.m_7967_((Entity)bananapeel);
                    } else {
                        ItemEntity itementity = new ItemEntity(this.level, d0, (double)this.bundlePos.m_123342_() - 0.25, d1, new ItemStack((ItemLike)NeapolitanItems.BANANA_BUNCH.get()));
                        itementity.m_20334_(this.chimpanzee.m_217043_().m_188500_() * 0.4 - 0.2, -0.1, this.chimpanzee.m_217043_().m_188500_() * 0.4 - 0.2);
                        itementity.m_32060_();
                        this.level.m_7967_((Entity)itementity);
                    }
                    this.nextBananaTime = this.shakingTime + this.getNextBananaTime();
                }
            } else {
                this.chimpanzee.setAction(ChimpanzeeAction.HANGING);
            }
            ++this.shakingTime;
        } else {
            if (this.targetPos.m_203195_((Position)this.chimpanzee.m_20182_(), 1.0) && this.chimpanzee.getAction().canBeInterrupted() && this.chimpanzee.m_20096_()) {
                this.chimpanzee.m_6862_(true);
                double dx = (double)this.targetPos.m_123341_() + 0.5 - this.chimpanzee.m_20185_();
                double dy = (double)this.bundlePos.m_123342_() - this.chimpanzee.m_20186_() + 1.0;
                double dz = (double)this.targetPos.m_123343_() + 0.5 - this.chimpanzee.m_20189_();
                double d3 = 0.8 - dy * 0.1;
                this.chimpanzee.m_20256_(this.chimpanzee.m_20184_().m_82542_(0.5, 1.0, 0.5).m_82520_(dx * d3, 0.3 + dy * 0.1, dz * d3));
                --this.tryTicks;
            } else {
                if (this.tryTicks % 40 == 0) {
                    this.chimpanzee.m_21573_().m_26519_((double)this.targetPos.m_123341_() + 0.5, (double)this.targetPos.m_123342_() + 1.0, (double)this.targetPos.m_123343_() + 0.5, this.moveSpeed);
                }
                ++this.tryTicks;
            }
            this.chimpanzee.setDefaultAction();
            this.shakingTime = 0;
            this.nextBananaTime = 30 + this.getNextBananaTime();
        }
    }

    private boolean findNearestShakeableBundle() {
        BlockPos blockpos = this.chimpanzee.m_20183_();
        List<PoiRecord> list = this.poiManager.m_27181_(BUNDLE_PREDICATE, blockpos, 48, PoiManager.Occupancy.HAS_SPACE).sorted(Comparator.comparingDouble(poi -> poi.m_27257_().m_123331_((Vec3i)blockpos))).toList();
        for (PoiRecord poi2 : list) {
            BlockPos blockpos1;
            if (this.isBundleOccupiedByOther(poi2.m_27257_()) || (blockpos1 = this.findSafeGroundBelow(poi2.m_27257_())) == null || !this.chimpanzee.m_21444_(blockpos1)) continue;
            this.targetPos = blockpos1;
            this.bundlePos = poi2.m_27257_();
            return true;
        }
        return false;
    }

    private BlockPos findSafeGroundBelow(BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (int i = 1; i < 7; ++i) {
            mutable.m_122173_(Direction.DOWN);
            if (i > 2 && !GoalUtils.m_148448_((PathNavigation)this.chimpanzee.m_21573_(), (BlockPos)mutable)) {
                return mutable.m_7949_();
            }
            if (!GoalUtils.m_148461_((PathfinderMob)this.chimpanzee, (BlockPos)mutable) && !GoalUtils.m_148458_((PathfinderMob)this.chimpanzee, (BlockPos)mutable)) continue;
            return null;
        }
        return null;
    }

    private boolean isBundleOccupiedByOther(BlockPos pos) {
        return !this.level.m_6443_(Chimpanzee.class, new AABB(pos.m_7495_()), chimpanzee -> chimpanzee != this.chimpanzee && chimpanzee.isDoingAction(ChimpanzeeAction.HANGING, ChimpanzeeAction.SHAKING)).isEmpty();
    }

    private int getNextBananaTime() {
        return 5 + this.chimpanzee.m_217043_().m_188503_(30);
    }
}

