/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.common.block;

import com.teamabnormals.neapolitan.common.block.VanillaVineBlock;
import com.teamabnormals.neapolitan.core.other.tags.NeapolitanBlockTags;
import com.teamabnormals.neapolitan.core.registry.NeapolitanBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.NetherVines;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class VanillaVineTopBlock
extends Block
implements BonemealableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)16.0), Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)12.0), Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0)};

    public VanillaVineTopBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState otherState = worldIn.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_()));
        return VanillaVineTopBlock.facingSameDirection(state, otherState) || otherState.m_204336_(NeapolitanBlockTags.VANILLA_PLANTABLE_ON);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.m_61143_((Property)FACING)).m_122411_()];
    }

    public static boolean facingSameDirection(BlockState state, BlockState otherState) {
        Block block = otherState.m_60734_();
        if (block == NeapolitanBlocks.VANILLA_VINE.get() || block == NeapolitanBlocks.VANILLA_VINE_PLANT.get()) {
            return otherState.m_61143_((Property)FACING) == state.m_61143_((Property)FACING);
        }
        return false;
    }

    protected int getGrowthAmount(RandomSource rand) {
        return rand.m_188503_(2) + 1;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(world, pos, state, player);
        VanillaVineBlock.createPoisonCloud(world, pos, state, player);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!state.m_60710_((LevelReader)worldIn, pos)) {
            worldIn.m_46961_(pos, true);
        }
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        BlockPos blockpos;
        if (this.canGrowUp(state, worldIn, pos) && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos.m_121945_((Direction)state.m_61143_((Property)FACING)), (BlockState)worldIn.m_8055_(pos.m_121945_((Direction)state.m_61143_((Property)FACING))), (random.m_188500_() < 0.1 ? 1 : 0) != 0) && this.canGrowIn(worldIn.m_8055_(blockpos = pos.m_121945_((Direction)state.m_61143_((Property)FACING))))) {
            worldIn.m_46597_(blockpos, state);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)blockpos, (BlockState)worldIn.m_8055_(blockpos));
        }
    }

    private boolean canGrowUp(BlockState state, ServerLevel world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (Direction.Plane.VERTICAL.test(facing)) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!world.m_8055_(pos.m_121945_(direction)).m_60815_()) continue;
                return true;
            }
        } else {
            for (Direction direction : Direction.Plane.VERTICAL) {
                if (!world.m_8055_(pos.m_121945_(direction)).m_60815_()) continue;
                return true;
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (direction.m_122434_() == Direction.Axis.Y || direction.m_122434_() == facing.m_122434_() || !world.m_8055_(pos.m_121945_(direction)).m_60815_()) continue;
                return true;
            }
        }
        return world.m_8055_(pos.m_121945_(facing.m_122424_())).m_204336_(NeapolitanBlockTags.VANILLA_PLANTABLE_ON);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState facingBlock = worldIn.m_8055_(currentPos.m_121945_((Direction)stateIn.m_61143_((Property)FACING)));
        if (facing == ((Direction)stateIn.m_61143_((Property)FACING)).m_122424_() && !stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        if (facingBlock.m_61138_((Property)FACING) && facingBlock.m_61143_((Property)FACING) == stateIn.m_61143_((Property)FACING) && facingState.m_60713_((Block)this)) {
            return (BlockState)((Block)NeapolitanBlocks.VANILLA_VINE_PLANT.get()).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)stateIn.m_61143_((Property)FACING)));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7370_(LevelReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return this.canGrowIn(worldIn.m_8055_(pos.m_121945_((Direction)state.m_61143_((Property)FACING))));
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        BlockPos blockpos = pos.m_121945_((Direction)state.m_61143_((Property)FACING));
        int j = this.getGrowthAmount(rand);
        for (int k = 0; k < j && this.canGrowIn(worldIn.m_8055_(blockpos)); ++k) {
            worldIn.m_46597_(blockpos, state);
            blockpos = blockpos.m_121945_((Direction)state.m_61143_((Property)FACING));
        }
    }

    protected boolean canGrowIn(BlockState state) {
        return NetherVines.m_54963_((BlockState)state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }
}

