/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.neapolitan.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.teamabnormals.neapolitan.common.entity.animal.Chimpanzee;
import com.teamabnormals.neapolitan.common.entity.util.ChimpanzeeAction;
import com.teamabnormals.neapolitan.core.other.tags.NeapolitanItemTags;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChimpanzeeModel<T extends Chimpanzee>
extends HumanoidModel<T> {
    public ModelPart leftEar;
    public ModelPart rightEar;
    protected ModelPart bodyDefault;
    protected ModelPart headDefault;
    protected ModelPart leftEarDefault;
    protected ModelPart rightEarDefault;
    protected ModelPart leftArmDefault;
    protected ModelPart rightArmDefault;
    protected ModelPart leftLegDefault;
    protected ModelPart rightLegDefault;

    public ChimpanzeeModel(ModelPart root) {
        super(root);
        this.leftEar = this.f_102808_.m_171324_("left_ear");
        this.rightEar = this.f_102808_.m_171324_("right_ear");
        this.bodyDefault = root.m_171324_("body_default");
        this.headDefault = root.m_171324_("head_default");
        this.leftEarDefault = root.m_171324_("left_ear_default");
        this.rightEarDefault = root.m_171324_("right_ear_default");
        this.leftArmDefault = root.m_171324_("left_arm_default");
        this.rightArmDefault = root.m_171324_("right_arm_default");
        this.leftLegDefault = root.m_171324_("left_leg_default");
        this.rightLegDefault = root.m_171324_("right_leg_default");
    }

    public static LayerDefinition createBodyLayer(float modelSize, boolean isArmor, boolean isInner) {
        CubeDeformation deformation = CubeDeformation.f_171458_;
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)deformation, (float)0.0f);
        PartDefinition root = meshdefinition.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(37, 0).m_171488_(-5.0f, -0.0f, -1.5f, 10.0f, 8.0f, 3.0f, deformation.m_171469_(modelSize)), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(1, 1).m_171488_(-4.0f, -8.0f, -3.0f, 8.0f, 8.0f, 6.0f, deformation.m_171469_(modelSize)).m_171514_(30, 11).m_171506_(-2.0f, -5.0f, -4.0f, 4.0f, 5.0f, 1.0f, false), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEar = head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(25, 1).m_171480_().m_171488_(0.0f, -2.0f, -1.0f, 2.0f, 3.0f, 1.0f, deformation.m_171469_(modelSize)), PartPose.m_171423_((float)4.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightEar = head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(25, 1).m_171488_(-2.0f, -4.0f, -1.0f, 2.0f, 3.0f, 1.0f, deformation.m_171469_(modelSize)), PartPose.m_171423_((float)-4.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(14, 17).m_171480_().m_171488_(0.0f, -1.5f, -1.5f, 3.0f, 11.0f, 3.0f, deformation.m_171469_(modelSize)), PartPose.m_171423_((float)5.0f, (float)6.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(1, 17).m_171488_(-3.0f, -1.5f, -1.5f, 3.0f, 11.0f, 3.0f, deformation.m_171469_(modelSize)), PartPose.m_171423_((float)-5.0f, (float)6.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(40, 17).m_171480_().m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 11.0f, 3.0f, deformation.m_171469_(modelSize)), PartPose.m_171423_((float)2.5f, (float)13.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(27, 17).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 11.0f, 3.0f, deformation.m_171469_(modelSize)), PartPose.m_171423_((float)-2.5f, (float)13.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        if (isArmor) {
            head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, deformation.m_171469_(modelSize)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
            body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, -0.0f, -2.0f, 8.0f, 12.0f, 4.0f, deformation.m_171469_(modelSize)), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
            rightArm = root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -1.5f, -2.0f, 4.0f, 12.0f, 4.0f, deformation.m_171469_(modelSize)), PartPose.m_171423_((float)-5.0f, (float)6.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
            leftArm = root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171488_(-1.0f, -1.5f, -2.0f, 4.0f, 12.0f, 4.0f, deformation.m_171469_(modelSize)), PartPose.m_171423_((float)5.0f, (float)6.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
            if (isInner) {
                rightLeg = root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.5f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation.m_171469_(modelSize)), PartPose.m_171423_((float)-2.5f, (float)13.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
                leftLeg = root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-2.5f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation.m_171469_(modelSize)), PartPose.m_171423_((float)2.5f, (float)13.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
            } else {
                rightLeg = root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.5f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation.m_171469_(modelSize)), PartPose.m_171423_((float)-2.5f, (float)13.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
                leftLeg = root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-2.5f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation.m_171469_(modelSize)), PartPose.m_171423_((float)2.5f, (float)13.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
            }
            leftEar = root.m_171599_("left_ear", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
            rightEar = root.m_171599_("right_ear", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        }
        PartDefinition hat = root.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodyDefault = root.m_171599_("body_default", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headDefault = root.m_171599_("head_default", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEarDefault = root.m_171599_("left_ear_default", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)4.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightEarDefault = root.m_171599_("right_ear_default", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-4.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArmDefault = root.m_171599_("left_arm_default", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)5.0f, (float)6.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArmDefault = root.m_171599_("right_arm_default", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-5.0f, (float)6.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLegDefault = root.m_171599_("left_leg_default", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)2.5f, (float)13.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLegDefault = root.m_171599_("right_leg_default", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-2.5f, (float)13.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f1;
        float f;
        float partialtick = ageInTicks - (float)((Chimpanzee)((Object)entity)).f_19797_;
        float fullclimbanim = ((Chimpanzee)((Object)entity)).getClimbingAnim(partialtick);
        float climbanim = Math.min(fullclimbanim * 5.0f / 3.0f, 1.0f);
        int attacktimer = ((Chimpanzee)((Object)entity)).getAttackTimer();
        int earstate = this.getEarState(entity);
        boolean apemode = ((Chimpanzee)((Object)entity)).getApeModeTime() > 0;
        HumanoidArm mainhand = entity.m_5737_();
        this.f_102810_.m_104315_(this.bodyDefault);
        this.f_102808_.m_104315_(this.headDefault);
        this.leftEar.m_104315_(this.leftEarDefault);
        this.rightEar.m_104315_(this.rightEarDefault);
        this.f_102812_.m_104315_(this.leftArmDefault);
        this.f_102811_.m_104315_(this.rightArmDefault);
        this.f_102814_.m_104315_(this.leftLegDefault);
        this.f_102813_.m_104315_(this.rightLegDefault);
        if (earstate == 2) {
            this.leftEar.f_104207_ = false;
            this.rightEar.f_104207_ = false;
        } else {
            if (earstate == 1) {
                this.leftEar.f_104204_ = -1.5707964f;
                this.leftEar.f_104200_ -= 0.1f;
                this.rightEar.f_104204_ = 1.5707964f;
                this.rightEar.f_104200_ += 0.1f;
            }
            this.leftEar.f_104207_ = true;
            this.rightEar.f_104207_ = true;
        }
        if (this.f_102610_) {
            this.f_102808_.f_104201_ -= 1.6f;
        }
        this.f_102808_.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.f_102808_.f_104203_ = headPitch * ((float)Math.PI / 180);
        if (((Chimpanzee)((Object)entity)).isPartying()) {
            this.f_102811_.f_104203_ = (1.0f - climbanim) * (float)(-Math.PI);
            this.f_102812_.f_104203_ = (1.0f - climbanim) * (float)(-Math.PI);
        } else {
            f = apemode ? 1.4f : 1.0f;
            this.f_102811_.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f * f;
            this.f_102812_.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f * f;
            if (!entity.m_21205_().m_41619_()) {
                this.m_102851_((HumanoidArm)mainhand).f_104203_ -= 0.31415927f;
            }
            if (!entity.m_21206_().m_41619_()) {
                this.m_102851_((HumanoidArm)mainhand.m_20828_()).f_104203_ -= 0.31415927f;
            }
        }
        if (this.f_102609_) {
            if (!((Chimpanzee)((Object)entity)).isPartying()) {
                this.f_102811_.f_104203_ += -0.62831855f;
                this.f_102812_.f_104203_ += -0.62831855f;
            }
            this.f_102813_.f_104203_ = -1.4137167f;
            this.f_102813_.f_104204_ = 0.31415927f;
            this.f_102813_.f_104205_ = 0.07853982f;
            this.f_102814_.f_104203_ = -1.4137167f;
            this.f_102814_.f_104204_ = -0.31415927f;
            this.f_102814_.f_104205_ = -0.07853982f;
        } else {
            f = ((Chimpanzee)((Object)entity)).getSitAnim(partialtick);
            if (f > 0.0f) {
                if (!((Chimpanzee)((Object)entity)).isPartying()) {
                    this.f_102811_.f_104203_ += f * -0.62831855f;
                    this.f_102812_.f_104203_ += f * -0.62831855f;
                }
                this.f_102810_.f_104201_ += f * 10.0f;
                this.f_102808_.f_104201_ = this.f_102808_.f_104201_ + f * (this.f_102610_ ? 6.5f : 10.0f);
                this.f_102811_.f_104201_ += f * 10.0f;
                this.f_102812_.f_104201_ += f * 10.0f;
                this.f_102813_.f_104201_ += f * 10.0f;
                this.f_102813_.f_104202_ += f;
                this.f_102814_.f_104201_ += f * 10.0f;
                this.f_102814_.f_104202_ += f;
                this.f_102813_.f_104203_ = f * -1.5707964f;
                this.f_102813_.f_104204_ = f * 0.31415927f;
                this.f_102814_.f_104203_ = f * -1.5707964f;
                this.f_102814_.f_104204_ = f * -0.31415927f;
            }
            if (!((Chimpanzee)((Object)entity)).isDoingAction(ChimpanzeeAction.SHAKING)) {
                this.f_102813_.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
                this.f_102814_.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            }
        }
        if (((Chimpanzee)((Object)entity)).isDoingAction(ChimpanzeeAction.EATING)) {
            f = Mth.m_14031_((float)(ageInTicks * 0.7f));
            this.f_102808_.f_104203_ = -f * 0.2f;
            this.f_102808_.f_104204_ = 0.0f;
            this.f_102811_.f_104203_ = f * 0.4f - 1.7f;
            this.f_102812_.f_104203_ = f * 0.4f - 1.7f;
            this.f_102811_.f_104204_ = -0.6f;
            this.f_102812_.f_104204_ = 0.6f;
        } else if (((Chimpanzee)((Object)entity)).isDoingAction(ChimpanzeeAction.GROOMING)) {
            f = Mth.m_14031_((float)(ageInTicks * 0.5f));
            this.f_102811_.f_104203_ = f * 0.4f - 1.5707964f;
            this.f_102812_.f_104203_ = -f * 0.4f - 1.5707964f;
        } else if (((Chimpanzee)((Object)entity)).isDoingAction(ChimpanzeeAction.SHAKING)) {
            f = Mth.m_14031_((float)(ageInTicks * 0.82f)) * 1.4f;
            f1 = Mth.m_14089_((float)(ageInTicks * 0.82f)) * 1.8f;
            this.f_102808_.f_104201_ += f1 + 1.5f;
            this.f_102808_.f_104202_ += f;
            this.f_102810_.f_104201_ += f1 + 1.5f;
            this.f_102810_.f_104202_ += f;
            this.f_102811_.f_104201_ += 1.5f;
            this.f_102811_.f_104202_ += f * 0.5f;
            this.f_102812_.f_104201_ += 1.5f;
            this.f_102812_.f_104202_ += f * 0.5f;
            this.f_102813_.f_104201_ += f1 + 1.5f;
            this.f_102813_.f_104202_ += f;
            this.f_102814_.f_104201_ += f1 + 1.5f;
            this.f_102814_.f_104202_ += f;
            this.f_102813_.f_104203_ = f * 0.35f - 0.31415927f;
            this.f_102814_.f_104203_ = f * 0.35f - 0.31415927f;
        } else if (((Chimpanzee)((Object)entity)).isDoingAction(ChimpanzeeAction.CRYING)) {
            f = Mth.m_14031_((float)(ageInTicks * 0.6f));
            this.f_102808_.f_104203_ = 0.3f - f * 0.2f;
            this.f_102808_.f_104204_ = 0.0f;
            this.f_102812_.f_104203_ = f * 0.4f - 1.7f;
            this.f_102812_.f_104204_ = 0.5f;
            this.f_102811_.f_104203_ = f * 0.4f - 1.7f;
            this.f_102811_.f_104204_ = -0.5f;
        } else if (((Chimpanzee)((Object)entity)).isDoingAction(ChimpanzeeAction.LOOKING_AT_ITEM)) {
            this.f_102808_.f_104203_ = 0.5f;
            this.f_102808_.f_104204_ = 0.0f;
            if (entity.m_21526_()) {
                this.f_102812_.f_104204_ = 0.5f;
                this.f_102812_.f_104203_ = -0.9f;
            } else {
                this.f_102811_.f_104204_ = -0.5f;
                this.f_102811_.f_104203_ = -0.9f;
            }
        } else if (((Chimpanzee)((Object)entity)).isDoingAction(ChimpanzeeAction.PLAYING_WITH_ITEM)) {
            f = Mth.m_14031_((float)(ageInTicks * 0.6f));
            this.f_102808_.f_104203_ = -0.1f + Mth.m_14031_((float)(ageInTicks * 0.6f - 0.5f)) * 0.1f;
            if (entity.m_21526_()) {
                this.f_102812_.f_104203_ = f * 0.5f - 1.8f;
                this.f_102808_.f_104204_ = -0.5f;
            } else {
                this.f_102811_.f_104203_ = f * 0.5f - 1.8f;
                this.f_102808_.f_104204_ = 0.5f;
            }
        } else if (((Chimpanzee)((Object)entity)).isDoingAction(ChimpanzeeAction.PLAYING_WITH_HELMET)) {
            this.f_102808_.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.55f)) * 0.5f;
            this.f_102808_.f_104204_ = 0.0f;
            this.f_102808_.f_104205_ = Mth.m_14031_((float)(ageInTicks * 0.55f)) * 0.3f;
        } else if (((Chimpanzee)((Object)entity)).isDoingAction(ChimpanzeeAction.JUMPING)) {
            f = -Math.abs(Mth.m_14031_((float)(ageInTicks * 0.2f)));
            this.f_102811_.f_104200_ += 1.0f;
            this.f_102812_.f_104200_ += -1.0f;
            this.f_102811_.f_104203_ = (float)(-Math.PI);
            this.f_102812_.f_104203_ = (float)(-Math.PI);
            this.f_102811_.f_104205_ = f * 0.4f - 0.4f;
            this.f_102812_.f_104205_ = -f * 0.4f + 0.4f;
        } else if (((Chimpanzee)((Object)entity)).isDoingAction(ChimpanzeeAction.DRUMMING)) {
            f = -Math.abs(Mth.m_14031_((float)(ageInTicks * 0.3f)));
            f1 = -Math.abs(Mth.m_14031_((float)(ageInTicks * 0.3f + 1.5707964f)));
            this.f_102811_.f_104203_ = f - 0.9f;
            this.f_102812_.f_104203_ = f1 - 0.9f;
            this.f_102811_.f_104204_ = -0.5f;
            this.f_102812_.f_104204_ = 0.5f;
        } else {
            f = ((Chimpanzee)((Object)entity)).getHeadShakeAnim(partialtick);
            if (f > 0.0f) {
                this.f_102808_.f_104204_ = Mth.m_14031_((float)(f * (float)Math.PI / 8.0f)) * 0.3f;
                this.f_102808_.f_104203_ = 0.6f;
            }
        }
        this.f_102811_.f_104203_ += -fullclimbanim * (float)Math.PI;
        this.f_102812_.f_104203_ += -fullclimbanim * (float)Math.PI;
        this.f_102811_.f_104204_ += climbanim * 0.6f;
        this.f_102812_.f_104204_ += -climbanim * 0.6f;
        this.f_102813_.f_104203_ += -climbanim * (float)Math.PI * 0.2f;
        this.f_102814_.f_104203_ += -climbanim * (float)Math.PI * 0.2f;
        if (!((Chimpanzee)((Object)entity)).isDoingAction(ChimpanzeeAction.CLIMBING, ChimpanzeeAction.HANGING, ChimpanzeeAction.SHAKING)) {
            AnimationUtils.m_102082_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (float)ageInTicks);
        }
        if (((Chimpanzee)((Object)entity)).isPartying()) {
            f = Mth.m_14089_((float)(ageInTicks * 0.75f)) * 0.5f;
            f1 = Mth.m_14031_((float)(ageInTicks * 0.75f)) * 0.5f;
            this.f_102808_.f_104200_ += f;
            this.f_102810_.f_104200_ += f;
            this.f_102811_.f_104200_ += f;
            this.f_102812_.f_104200_ += f;
            this.f_102808_.f_104202_ += f1;
            this.f_102810_.f_104202_ += f1;
            this.f_102811_.f_104202_ += f1;
            this.f_102812_.f_104202_ += f1;
            this.f_102811_.f_104203_ += f * 0.1f;
            this.f_102812_.f_104203_ += f * 0.1f;
            this.f_102811_.f_104205_ += f1 * 0.2f - 0.1f;
            this.f_102812_.f_104205_ += f1 * 0.2f + 0.1f;
        }
        if (attacktimer > 0) {
            this.f_102811_.f_104203_ = -2.0f + 1.5f * Mth.m_14156_((float)((float)attacktimer - partialtick), (float)10.0f);
            this.f_102812_.f_104203_ = -2.0f + 1.5f * Mth.m_14156_((float)((float)attacktimer - partialtick), (float)10.0f);
            this.f_102811_.f_104204_ = 0.0f;
            this.f_102812_.f_104204_ = 0.0f;
        }
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.f_102808_);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102810_, (Object)this.f_102812_, (Object)this.f_102811_, (Object)this.f_102814_, (Object)this.f_102813_);
    }

    public ModelPart m_5585_() {
        return this.f_102808_;
    }

    public void m_6002_(HumanoidArm sideIn, PoseStack matrixStackIn) {
        this.m_102851_(sideIn).m_104299_(matrixStackIn);
    }

    private int getEarState(T entity) {
        ItemStack itemstack = entity.m_6844_(EquipmentSlot.HEAD);
        Item item = itemstack.m_41720_();
        if (itemstack.m_204117_(NeapolitanItemTags.HIDES_CHIMPANZEE_EARS)) {
            return 2;
        }
        if (item instanceof BlockItem || item instanceof ArmorItem && ((ArmorItem)item).m_40402_() == EquipmentSlot.HEAD) {
            return 1;
        }
        return 0;
    }
}

