/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.common.item;

import com.illusivesoulworks.comforts.common.ComfortsConfig;
import com.illusivesoulworks.comforts.common.block.BaseComfortsBlock;
import com.illusivesoulworks.comforts.common.item.BaseComfortsItem;
import com.illusivesoulworks.comforts.platform.Services;
import com.mojang.datafixers.util.Either;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class SleepingBagItem
extends BaseComfortsItem {
    public SleepingBagItem(Block block) {
        super(block);
    }

    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        boolean autoUse = (Boolean)ComfortsConfig.SERVER.autoUse.get();
        Player player = context.m_43723_();
        if (!autoUse || player != null && player.m_6047_()) {
            return super.m_6225_(context);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Either<Player.BedSleepingProblem, Unit> result = BaseComfortsBlock.trySleep(serverPlayer, context.m_8083_().m_7494_(), true);
            return (InteractionResult)result.map(bedSleepingProblem -> {
                MutableComponent text;
                switch (bedSleepingProblem) {
                    case NOT_POSSIBLE_NOW: {
                        MutableComponent mutableComponent = ((ComfortsConfig.ComfortsTimeUse)((Object)((Object)ComfortsConfig.SERVER.sleepingBagUse.get()))).getMessage();
                        break;
                    }
                    case TOO_FAR_AWAY: {
                        MutableComponent mutableComponent = Component.m_237115_((String)"block.comforts.sleeping_bag.too_far_away");
                        break;
                    }
                    default: {
                        MutableComponent mutableComponent = text = bedSleepingProblem.m_36423_();
                    }
                }
                if (text != null) {
                    player.m_5661_((Component)text, true);
                }
                return InteractionResult.FAIL;
            }, unit -> {
                InteractionResult interactionResult = super.m_6225_(context);
                if (interactionResult.m_19077_()) {
                    Services.SLEEP_EVENTS.sendPlaceBagPacket(serverPlayer, context);
                    BlockPos pos = context.m_8083_().m_7494_();
                    Services.SLEEP_EVENTS.getSleepData(player).ifPresent(data -> data.setAutoSleepPos(pos));
                    Services.SLEEP_EVENTS.sendAutoSleepPacket(serverPlayer, pos);
                }
                return interactionResult;
            });
        }
        return InteractionResult.CONSUME;
    }

    public void syncedUseOn(@Nonnull UseOnContext useOnContext) {
        super.m_6225_(useOnContext);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> components, @Nonnull TooltipFlag flag) {
        if (((Boolean)ComfortsConfig.SERVER.autoUse.get()).booleanValue()) {
            components.add((Component)Component.m_237115_((String)"item.comforts.sleeping_bag.auto_use.tooltip").m_130940_(ChatFormatting.GRAY));
        }
    }
}

