/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.tileentities;

import appeng.api.storage.cells.CellState;
import appeng.blockentity.storage.DriveBlockEntity;
import appeng.core.AELog;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import com.glodblock.github.extendedae.common.EPPItemAndBlock;
import com.glodblock.github.extendedae.container.ContainerExDrive;
import com.glodblock.github.extendedae.util.Ae2Reflect;
import com.glodblock.github.glodium.util.GlodUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TileExDrive
extends DriveBlockEntity {
    public TileExDrive(BlockPos pos, BlockState blockState) {
        super(GlodUtil.getTileType(TileExDrive.class, TileExDrive::new, (Block)EPPItemAndBlock.EX_DRIVE), pos, blockState);
    }

    public int getCellCount() {
        return 20;
    }

    protected void writeToStream(FriendlyByteBuf data) {
        int i;
        Ae2Reflect.updateDriveClientSideState(this);
        long packedState = 0L;
        for (i = 0; i < this.getCellCount(); ++i) {
            packedState |= (long)Ae2Reflect.getCellState(this)[i].ordinal() << (int)((long)i * 3L);
        }
        if (Ae2Reflect.getClientOnline(this)) {
            packedState |= 0x2000000000000000L;
        }
        data.writeLong(packedState);
        for (i = 0; i < this.getCellCount(); ++i) {
            data.m_130130_(BuiltInRegistries.f_257033_.m_7447_((Object)this.getCellItem(i)));
        }
    }

    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean online;
        boolean changed = false;
        long packedState = data.readLong();
        for (int i = 0; i < this.getCellCount(); ++i) {
            long cellStateOrdinal = packedState >> i * 3 & 7L;
            CellState cellState = CellState.values()[(int)cellStateOrdinal];
            if (Ae2Reflect.getCellState(this)[i] == cellState) continue;
            Ae2Reflect.getCellState((DriveBlockEntity)this)[i] = cellState;
            changed = true;
        }
        boolean bl = online = (packedState & 0x2000000000000000L) != 0L;
        if (Ae2Reflect.getClientOnline(this) != online) {
            Ae2Reflect.setClientOnline(this, online);
            changed = true;
        }
        for (int i = 0; i < this.getCellCount(); ++i) {
            Item item;
            int itemId = data.m_130242_();
            Item item2 = item = itemId == 0 ? null : (Item)BuiltInRegistries.f_257033_.m_7942_(itemId);
            if (itemId != 0 && item == Items.f_41852_) {
                AELog.warn((String)"Received unknown item id from server for disk drive %s: %d", (Object[])new Object[]{this, itemId});
            }
            if (Ae2Reflect.getCellItem(this)[i] == item) continue;
            Ae2Reflect.getCellItem((DriveBlockEntity)this)[i] = item;
            changed = true;
        }
        return changed;
    }

    public void openMenu(Player player) {
        MenuOpener.open(ContainerExDrive.TYPE, (Player)player, (MenuLocator)MenuLocators.forBlockEntity((BlockEntity)this));
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        MenuOpener.returnTo(ContainerExDrive.TYPE, (Player)player, (MenuLocator)MenuLocators.forBlockEntity((BlockEntity)this));
    }

    public ItemStack getMainMenuIcon() {
        return new ItemStack((ItemLike)EPPItemAndBlock.EX_DRIVE);
    }
}

