/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.parts;

import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.PartModel;
import appeng.util.SettingsFrom;
import appeng.util.prioritylist.IPartitionList;
import com.glodblock.github.extendedae.common.me.taglist.TagPriorityList;
import com.glodblock.github.extendedae.common.parts.base.PartSpecialStorageBus;
import com.glodblock.github.extendedae.container.ContainerTagStorageBus;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.Nullable;

public class PartTagStorageBus
extends PartSpecialStorageBus {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("expatternprovider", "part/tag_storage_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("ae2", "part/storage_bus_off")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("ae2", "part/storage_bus_on")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("ae2", "part/storage_bus_has_channel")});
    private String oreExpWhite = "";
    private String oreExpBlack = "";

    public PartTagStorageBus(IPartItem<?> partItem) {
        super(partItem);
    }

    @Override
    public void readFromNBT(CompoundTag data) {
        super.readFromNBT(data);
        this.oreExpWhite = data.m_128461_("oreExp");
        this.oreExpBlack = data.m_128461_("oreExp2");
    }

    @Override
    public void writeToNBT(CompoundTag data) {
        super.writeToNBT(data);
        data.m_128359_("oreExp", this.oreExpWhite);
        data.m_128359_("oreExp2", this.oreExpBlack);
    }

    @Override
    public MenuType<?> getMenuType() {
        return ContainerTagStorageBus.TYPE;
    }

    protected final int getUpgradeSlots() {
        return 2;
    }

    public void setTagFilter(String exp, boolean isWhite) {
        if (isWhite) {
            if (!exp.equals(this.oreExpWhite)) {
                this.oreExpWhite = exp;
                this.filter = null;
                this.forceUpdate();
            }
        } else if (!exp.equals(this.oreExpBlack)) {
            this.oreExpBlack = exp;
            this.filter = null;
            this.forceUpdate();
        }
    }

    public String getTagFilter(boolean isWhite) {
        return isWhite ? this.oreExpWhite : this.oreExpBlack;
    }

    @Override
    protected IPartitionList createFilter() {
        if (this.filter == null) {
            this.filter = new TagPriorityList(this.oreExpWhite, this.oreExpBlack);
        }
        return this.filter;
    }

    public void importSettings(SettingsFrom mode, CompoundTag input, @Nullable Player player) {
        super.importSettings(mode, input, player);
        this.oreExpWhite = input.m_128441_("ore_dict_exp") ? input.m_128461_("ore_dict_exp") : "";
        this.oreExpBlack = input.m_128441_("ore_dict_exp_2") ? input.m_128461_("ore_dict_exp_2") : "";
    }

    public void exportSettings(SettingsFrom mode, CompoundTag output) {
        super.exportSettings(mode, output);
        if (mode == SettingsFrom.MEMORY_CARD) {
            output.m_128359_("ore_dict_exp", this.oreExpWhite);
            output.m_128359_("ore_dict_exp_2", this.oreExpBlack);
        }
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }
}

