/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.hooks;

import appeng.api.parts.IPart;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.items.tools.quartz.QuartzCuttingKnifeItem;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.util.InteractionUtil;
import com.glodblock.github.extendedae.container.ContainerRenamer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class CutterHook {
    public static final CutterHook INSTANCE = new CutterHook();

    private CutterHook() {
    }

    @SubscribeEvent
    public void onPlayerUseBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        if (event.getUseBlock() == Event.Result.DENY) {
            return;
        }
        InteractionResult result = this.onPlayerUseBlock(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
        if (result != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }

    public InteractionResult onPlayerUseBlock(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        BlockPos pos;
        BlockEntity tile;
        if (player.m_5833_() || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack itemStack = player.m_21120_(hand);
        if (!InteractionUtil.isInAlternateUseMode((Player)player) && itemStack.m_41720_() instanceof QuartzCuttingKnifeItem && (tile = level.m_7702_(pos = hitResult.m_82425_())) instanceof AEBaseBlockEntity) {
            if (tile instanceof CableBusBlockEntity) {
                CableBusBlockEntity cable = (CableBusBlockEntity)tile;
                Vec3 hitVec = hitResult.m_82450_();
                Vec3 hitInBlock = new Vec3(hitVec.f_82479_ - (double)pos.m_123341_(), hitVec.f_82480_ - (double)pos.m_123342_(), hitVec.f_82481_ - (double)pos.m_123343_());
                IPart part = cable.selectPartLocal((Vec3)hitInBlock).part;
                if (part instanceof AEBasePart) {
                    AEBasePart p = (AEBasePart)part;
                    if (!level.f_46443_) {
                        MenuOpener.open(ContainerRenamer.TYPE, (Player)player, (MenuLocator)MenuLocators.forPart((AEBasePart)p));
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            } else {
                if (!level.f_46443_) {
                    MenuOpener.open(ContainerRenamer.TYPE, (Player)player, (MenuLocator)MenuLocators.forBlockEntity((BlockEntity)tile));
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }
}

