/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.button;

import appeng.client.gui.style.Blitter;
import com.glodblock.github.extendedae.client.button.EPPButton;
import com.glodblock.github.extendedae.client.button.EPPIcon;
import com.glodblock.github.extendedae.client.render.EAEHighlightHandler;
import com.glodblock.github.extendedae.util.FCClientUtil;
import com.glodblock.github.glodium.util.GlodUtil;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HighlightButton
extends EPPButton {
    private float multiplier;
    private Runnable successJob;
    private BlockPos pos;
    private ResourceKey<Level> dim;
    @Nullable
    private Direction face;

    public HighlightButton() {
        super(HighlightButton::highlight);
    }

    public void setMultiplier(double val) {
        this.multiplier = (float)GlodUtil.clamp((double)val, (double)1.0, (double)30.0);
    }

    public void setSuccessJob(Runnable process) {
        this.successJob = process;
    }

    public void setTarget(BlockPos pos, Direction face, ResourceKey<Level> world) {
        this.pos = pos;
        this.dim = world;
        this.face = face;
    }

    public void setTarget(BlockPos pos, ResourceKey<Level> world) {
        this.setTarget(pos, null, world);
    }

    private static void highlight(Button btn) {
        if (btn instanceof HighlightButton) {
            HighlightButton hb = (HighlightButton)btn;
            if (hb.dim != null && hb.pos != null) {
                if (hb.face == null) {
                    EAEHighlightHandler.highlight(hb.pos, hb.dim, System.currentTimeMillis() + (long)(600.0f * hb.multiplier));
                } else {
                    AABB origin = HighlightButton.getNorthPartModel().m_82338_(hb.pos);
                    Vec3 center = new AABB(hb.pos).m_82399_();
                    switch (hb.face) {
                        case WEST: {
                            origin = FCClientUtil.rotor(origin, center, Direction.Axis.Y, 1.5707964f);
                            break;
                        }
                        case SOUTH: {
                            origin = FCClientUtil.rotor(origin, center, Direction.Axis.Y, (float)Math.PI);
                            break;
                        }
                        case EAST: {
                            origin = FCClientUtil.rotor(origin, center, Direction.Axis.Y, -1.5707964f);
                            break;
                        }
                        case UP: {
                            origin = FCClientUtil.rotor(origin, center, Direction.Axis.X, -1.5707964f);
                            break;
                        }
                        case DOWN: {
                            origin = FCClientUtil.rotor(origin, center, Direction.Axis.X, 1.5707964f);
                        }
                    }
                    EAEHighlightHandler.highlight(hb.pos, hb.face, hb.dim, System.currentTimeMillis() + (long)(600.0f * hb.multiplier), origin);
                }
                if (hb.successJob != null) {
                    hb.successJob.run();
                }
            }
        }
    }

    private static AABB getNorthPartModel() {
        return new AABB(0.125, 0.125, 0.0, 0.875, 0.875, 0.125);
    }

    @Override
    public Blitter getBlitterIcon() {
        return EPPIcon.HIGHLIGHT_BLOCK;
    }
}

