/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.type.tree;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import team.creative.creativecore.common.util.type.itr.ConsecutiveIterator;
import team.creative.creativecore.common.util.type.itr.NestedIterator;

public class NamedTree<T>
implements Iterable<T> {
    private final NamedTree<T> parent;
    private final String name;
    private final LinkedHashMap<String, NamedTree<T>> children = new LinkedHashMap();
    private final LinkedHashMap<String, T> values = new LinkedHashMap();

    public NamedTree() {
        this.parent = null;
        this.name = null;
    }

    private NamedTree(NamedTree<T> parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public T add(String path, T value) {
        String[] parts = path.split("\\.");
        this.folderForce((String[])parts, (int)0, (int)(parts.length - 1)).values.put(parts[parts.length - 1], value);
        return value;
    }

    public T add(String path, String id, T value) {
        this.folderForce((String)path).values.put(id, value);
        return value;
    }

    public Collection<String> folders() {
        return this.children.keySet();
    }

    public Collection<T> values() {
        return this.values.values();
    }

    public T get(String path, String id) {
        NamedTree<T> folder = this.children.get(path);
        if (folder != null) {
            return folder.values.get(id);
        }
        return null;
    }

    public T get(String path) {
        String[] parts = path.split("\\.");
        if (parts.length == 1) {
            return this.values.get(path);
        }
        if (parts.length != 2) {
            return null;
        }
        return this.get(parts[0], parts[1]);
    }

    public NamedTree<T> folder(String path) {
        return this.folder(path.split("\\."), 0);
    }

    private NamedTree<T> folder(String[] path, int index) {
        NamedTree<T> folder = this.children.get(path[index]);
        if (folder == null) {
            return null;
        }
        if (path.length <= ++index) {
            return folder;
        }
        return folder.folder(path, index);
    }

    public NamedTree<T> folderForce(String path) {
        return this.folderForce(path.split("\\."), 0);
    }

    private NamedTree<T> folderForce(String[] path, int index) {
        return this.folderForce(path, index, path.length);
    }

    private NamedTree<T> folderForce(String[] path, int index, int end) {
        NamedTree<T> folder = this.children.get(path[index]);
        if (folder == null) {
            folder = new NamedTree<T>(this, path[index]);
            this.children.put(path[index], folder);
        }
        if (end <= ++index) {
            return folder;
        }
        return folder.folder(path, index);
    }

    public String path() {
        return this.parent != null ? this.parent.path() + this.name + "." : "";
    }

    public String toString() {
        return "[" + this.children + "|" + this.values + "]";
    }

    @Override
    public Iterator<T> iterator() {
        return new ConsecutiveIterator(this.values.values().iterator(), new NestedIterator<T>(this.children.values()));
    }
}

