/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.filter;

import team.creative.creativecore.common.util.filter.BiFilterSerializer;

@FunctionalInterface
public interface BiFilter<T, U> {
    public static final BiFilterSerializer SERIALIZER = new BiFilterSerializer();

    public boolean is(T var1, U var2);

    @SafeVarargs
    public static <T, U> BiFilter<T, U> and(BiFilter<T, U> ... filters) {
        return new BiFilterAnd<T, U>(filters);
    }

    @SafeVarargs
    public static <T, U> BiFilter<T, U> or(BiFilter<T, U> ... filters) {
        return new BiFilterOr<T, U>(filters);
    }

    public static <T, U> BiFilter<T, U> not(BiFilter<T, U> filter) {
        return new BiFilterNot<T, U>(filter);
    }

    public record BiFilterAnd<T, U>(BiFilter<T, U>[] filters) implements BiFilter<T, U>
    {
        @Override
        public boolean is(T t, U u) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i].is(t, u)) continue;
                return false;
            }
            return true;
        }
    }

    public record BiFilterOr<T, U>(BiFilter<T, U>[] filters) implements BiFilter<T, U>
    {
        @Override
        public boolean is(T t, U u) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (!this.filters[i].is(t, u)) continue;
                return true;
            }
            return false;
        }
    }

    public record BiFilterNot<T, U>(BiFilter<T, U> filter) implements BiFilter<T, U>
    {
        @Override
        public boolean is(T t, U u) {
            return !this.filter.is(t, u);
        }
    }
}

