/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.converation.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.converation.registry.GuiRegistryTagHandler;
import team.creative.creativecore.common.config.gui.IGuiConfigParent;
import team.creative.creativecore.common.config.key.ConfigKey;
import team.creative.creativecore.common.config.premade.registry.RegistryTagListConfig;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.collection.GuiListBoxBase;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.flow.GuiFlow;

public class ConfigTypeRegistryTagList
extends ConfigTypeConveration<RegistryTagListConfig> {
    @Override
    public RegistryTagListConfig readElement(HolderLookup.Provider provider, RegistryTagListConfig defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, ConfigKey key) {
        if (element.isJsonArray()) {
            RegistryTagListConfig list = new RegistryTagListConfig(defaultValue.registry);
            JsonArray array = element.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                list.add(TagKey.m_203882_((ResourceKey)defaultValue.registry.m_123023_(), (ResourceLocation)new ResourceLocation(array.get(i).getAsString())));
            }
            return list;
        }
        return defaultValue;
    }

    @Override
    public JsonElement writeElement(HolderLookup.Provider provider, RegistryTagListConfig value, boolean saveDefault, boolean ignoreRestart, Side side, ConfigKey key) {
        JsonArray array = new JsonArray(value.size());
        for (TagKey tag : value) {
            array.add(tag.f_203868_().toString());
        }
        return array;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void createControls(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
        parent.flow = GuiFlow.STACK_Y;
        GuiListBoxBase listBox = new GuiListBoxBase("data", true, new ArrayList());
        parent.add((GuiControl)listBox.setDim(50, 130).setExpandable());
        listBox.spacing = -1;
        parent.add((GuiControl)new GuiButton("add", null).setTitle((Component)Component.m_237115_((String)"gui.add")));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void loadValue(RegistryTagListConfig value, RegistryTagListConfig defaultValue, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
        GuiListBoxBase listBox = (GuiListBoxBase)parent.get("data");
        if (!listBox.isEmpty()) {
            listBox.clearItems();
        }
        configParent.setCustomData(value.registry);
        GuiButton add = (GuiButton)parent.get("add");
        add.setPressed(x -> {
            GuiParent entry = new GuiParent().setAlign(Align.STRETCH);
            GuiRegistryTagHandler.REGISTRY.get(value.registry).createControls(entry, value.registry);
            listBox.addItem(entry.setExpandableX());
        });
        for (TagKey tag : value) {
            GuiParent entry = new GuiParent().setAlign(Align.STRETCH);
            GuiRegistryTagHandler.REGISTRY.get(value.registry).createControls(entry, value.registry);
            GuiRegistryTagHandler.REGISTRY.get(value.registry).loadValue(entry, value.registry, tag);
            listBox.addItem(entry.setExpandableX());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected RegistryTagListConfig saveValue(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
        RegistryTagListConfig list = new RegistryTagListConfig((Registry)configParent.getCustomData());
        GuiListBoxBase listBox = (GuiListBoxBase)parent.get("data");
        for (int i = 0; i < listBox.size(); ++i) {
            list.add(GuiRegistryTagHandler.REGISTRY.get(list.registry).saveValue((GuiParent)listBox.get(i), list.registry));
        }
        return list;
    }

    @Override
    public RegistryTagListConfig set(ConfigKey key, RegistryTagListConfig value) {
        return value;
    }

    @Override
    public boolean areEqual(RegistryTagListConfig one, RegistryTagListConfig two, ConfigKey key, Side side) {
        if (one.size() != two.size()) {
            return false;
        }
        if (one.registry != two.registry) {
            return false;
        }
        ArrayList<TagKey> copy = new ArrayList<TagKey>();
        for (TagKey tag : two) {
            copy.add(tag);
        }
        for (int i = 0; i < one.size(); ++i) {
            if (copy.remove(one.get(i))) continue;
            return false;
        }
        return copy.isEmpty();
    }
}

