/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.item_inside;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.core.ItemShapelessContext;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.recipe.LycheeCounter;
import snownee.lychee.core.recipe.type.ItemShapelessRecipeType;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.item_inside.ItemInsideRecipe;
import snownee.lychee.util.CommonProxy;

public class ItemInsideRecipeType
extends LycheeRecipeType<ItemShapelessContext, ItemInsideRecipe> {
    private List<ItemInsideRecipe> specialRecipes = Lists.newArrayList();
    private Multimap<Item, ItemInsideRecipe> recipesByItem = ArrayListMultimap.create();

    public ItemInsideRecipeType(String name, Class<ItemInsideRecipe> clazz, @Nullable LootContextParamSet paramSet) {
        super(name, clazz, paramSet);
        this.compactInputs = true;
    }

    @Override
    public void buildCache() {
        this.specialRecipes.clear();
        this.recipesByItem.clear();
        super.buildCache();
        Object2FloatOpenHashMap itemCount = new Object2FloatOpenHashMap();
        List caches = this.recipes.stream().map(arg_0 -> this.lambda$buildCache$0((Object2FloatMap)itemCount, arg_0)).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        List<Item> sorted = itemCount.object2FloatEntrySet().stream().sorted((a, b) -> Float.compare(b.getFloatValue(), a.getFloatValue())).map(Map.Entry::getKey).toList();
        for (Item item : sorted) {
            caches.removeIf(cache -> {
                if (cache.ingredients.stream().anyMatch($ -> $.contains(item))) {
                    this.recipesByItem.put((Object)item, (Object)cache.recipe);
                    return cache.ingredients.stream().peek($ -> $.remove(item)).anyMatch(Set::isEmpty);
                }
                return false;
            });
        }
    }

    public void process(Entity entity, ItemStack stack, BlockPos pos, Vec3 origin) {
        Collection recipes;
        if (this.isEmpty()) {
            return;
        }
        MutableObject prevRecipeId = new MutableObject();
        if (entity instanceof LycheeCounter) {
            prevRecipeId.setValue((Object)((LycheeCounter)entity).lychee$getRecipeId());
            ((LycheeCounter)entity).lychee$setRecipeId(null);
        }
        if ((recipes = this.recipesByItem.get((Object)stack.m_41720_())).isEmpty() && this.specialRecipes.isEmpty()) {
            return;
        }
        Level level = entity.m_9236_();
        BlockState blockstate = level.m_8055_(pos);
        Block block = blockstate.m_60734_();
        List items = level.m_6443_(ItemEntity.class, AABB.m_165882_((Vec3)origin, (double)3.0, (double)3.0, (double)3.0), $ -> {
            if ($.m_213877_()) {
                return false;
            }
            return pos.equals((Object)$.m_20183_()) || level.m_8055_($.m_20183_()).m_60713_(block);
        });
        ItemShapelessContext.Builder ctxBuilder = new ItemShapelessContext.Builder(level, items);
        ctxBuilder.withParameter(LootContextParams.f_81460_, CommonProxy.clampPos(origin, pos));
        ctxBuilder.withParameter(LootContextParams.f_81455_, entity);
        ctxBuilder.withParameter(LootContextParams.f_81461_, blockstate);
        ctxBuilder.withParameter(LycheeLootContextParams.BLOCK_POS, pos);
        LycheeContext ctx = ctxBuilder.create(this.contextParamSet);
        ItemInsideRecipe prevRecipe = Optional.ofNullable((ResourceLocation)prevRecipeId.getValue()).map(CommonProxy::recipe).filter($ -> $.m_6671_() == this).orElse(null);
        Iterable iterable = Iterables.concat((Iterable)recipes, this.specialRecipes);
        if (prevRecipe != null) {
            iterable = Iterables.concat(List.of(prevRecipe), (Iterable)Iterables.filter((Iterable)iterable, $ -> $ != prevRecipe));
        }
        ItemShapelessRecipeType.process(this, iterable, ctx, arg_0 -> ItemInsideRecipeType.lambda$process$8(entity, prevRecipeId, (ItemShapelessContext)ctx, arg_0));
    }

    private static /* synthetic */ boolean lambda$process$8(Entity entity, MutableObject prevRecipeId, ItemShapelessContext ctx, ItemInsideRecipe recipe) {
        ((LycheeCounter)entity).lychee$update((ResourceLocation)prevRecipeId.getValue(), recipe);
        return recipe.tickOrApply(ctx);
    }

    private /* synthetic */ Cache lambda$buildCache$0(Object2FloatMap itemCount, ItemInsideRecipe $) {
        return $.buildCache((Object2FloatMap<Item>)itemCount, this.specialRecipes);
    }

    record Cache(ItemInsideRecipe recipe, List<Set<Item>> ingredients) {
    }
}

