/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.item_inside;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.core.ItemShapelessContext;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.recipe.BlockKeyRecipe;
import snownee.lychee.core.recipe.ItemShapelessRecipe;
import snownee.lychee.core.recipe.LycheeCounter;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.item_inside.ItemInsideRecipeType;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.RecipeMatcher;

public class ItemInsideRecipe
extends ItemShapelessRecipe<ItemInsideRecipe>
implements BlockKeyRecipe<ItemInsideRecipe> {
    private int time;
    protected BlockPredicate block;
    private boolean special;

    public ItemInsideRecipe(ResourceLocation id) {
        super(id);
    }

    @Override
    public LycheeRecipe.Serializer<?> getSerializer() {
        return RecipeSerializers.ITEM_INSIDE;
    }

    @Override
    public LycheeRecipeType<?, ?> getType() {
        return RecipeTypes.ITEM_INSIDE;
    }

    public int getTime() {
        return this.time;
    }

    @Override
    public boolean tickOrApply(ItemShapelessContext ctx) {
        LycheeCounter entity = (LycheeCounter)ctx.getParam(LootContextParams.f_81455_);
        if (entity.lychee$getCount() >= this.time) {
            entity.lychee$setRecipeId(null);
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(ItemShapelessContext ctx, Level pLevel) {
        int[] amount;
        if (ctx.totalItems < this.ingredients.size()) {
            return false;
        }
        if (!BlockPredicateHelper.fastMatch(this.block, ctx)) {
            return false;
        }
        List<ItemEntity> itemEntities = ctx.itemEntities.stream().filter($ -> this.ingredients.stream().anyMatch(ingredient -> ingredient.test($.m_32055_()))).limit(27L).toList();
        List<ItemStack> items = itemEntities.stream().map(ItemEntity::m_32055_).toList();
        Optional<RecipeMatcher<ItemStack>> match = RecipeMatcher.findMatches(items, this.ingredients, amount = items.stream().mapToInt(ItemStack::m_41613_).toArray());
        if (match.isEmpty()) {
            return false;
        }
        ctx.filteredItems = itemEntities;
        ctx.setMatch(match.get());
        return true;
    }

    @Override
    public BlockPredicate getBlock() {
        return this.block;
    }

    @Nullable
    public ItemInsideRecipeType.Cache buildCache(Object2FloatMap<Item> itemWeights, List<ItemInsideRecipe> specialRecipes) {
        boolean bl = this.special = !this.m_7527_().stream().anyMatch(CommonProxy::isSimpleIngredient);
        if (this.special) {
            specialRecipes.add(this);
            return null;
        }
        List<Set<Item>> mappedIngredients = this.m_7527_().stream().map(Ingredient::m_43908_).map($ -> {
            HashSet items = Sets.newHashSet();
            float weight = 1.0f / (float)((ItemStack[])$).length;
            for (ItemStack stack : $) {
                items.add(stack.m_41720_());
                itemWeights.merge((Object)stack.m_41720_(), weight, Float::sum);
            }
            return items;
        }).toList();
        return new ItemInsideRecipeType.Cache(this, mappedIngredients);
    }

    public boolean m_5598_() {
        return this.special;
    }

    public static class Serializer
    extends ItemShapelessRecipe.Serializer<ItemInsideRecipe> {
        public Serializer() {
            super(ItemInsideRecipe::new);
        }

        @Override
        public void fromJson(ItemInsideRecipe pRecipe, JsonObject pSerializedRecipe) {
            super.fromJson(pRecipe, pSerializedRecipe);
            pRecipe.time = GsonHelper.m_13824_((JsonObject)pSerializedRecipe, (String)"time", (int)0);
            pRecipe.block = BlockPredicateHelper.fromJson(pSerializedRecipe.get("block_in"));
            if (!pRecipe.ghost) {
                Preconditions.checkArgument((!pRecipe.ingredients.isEmpty() ? 1 : 0) != 0, (Object)"Ingredients cannot be empty");
            }
        }

        @Override
        public void fromNetwork(ItemInsideRecipe pRecipe, FriendlyByteBuf pBuffer) {
            super.fromNetwork(pRecipe, pBuffer);
            pRecipe.time = pBuffer.m_130242_();
            pRecipe.block = BlockPredicateHelper.fromNetwork(pBuffer);
        }

        @Override
        public void toNetwork0(FriendlyByteBuf pBuffer, ItemInsideRecipe pRecipe) {
            super.toNetwork0(pBuffer, pRecipe);
            pBuffer.m_130130_(pRecipe.time);
            BlockPredicateHelper.toNetwork(pRecipe.block, pBuffer);
        }
    }
}

