/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.recipe.type;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.Lychee;
import snownee.lychee.core.ItemShapelessContext;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;

public class ItemShapelessRecipeType<C extends ItemShapelessContext, T extends LycheeRecipe<C>>
extends LycheeRecipeType<C, T> {
    private LycheeRecipeType.ValidItemCache validItems = new LycheeRecipeType.ValidItemCache();

    public ItemShapelessRecipeType(String name, Class<T> clazz, @Nullable LootContextParamSet contextParamSet) {
        super(name, clazz, contextParamSet);
        this.compactInputs = true;
    }

    @Override
    public void buildCache() {
        super.buildCache();
        this.validItems.buildCache(this.recipes);
    }

    public void process(Level level, Stream<ItemEntity> itemEntities, Consumer<ItemShapelessContext.Builder<C>> ctxBuilderConsumer) {
        if (this.isEmpty()) {
            return;
        }
        List list = itemEntities.filter($ -> this.validItems.contains($.m_32055_())).collect(Collectors.toCollection(LinkedList::new));
        ItemShapelessContext.Builder ctxBuilder = new ItemShapelessContext.Builder(level, list);
        ctxBuilderConsumer.accept(ctxBuilder);
        ItemShapelessRecipeType.process(this, this.recipes, ctxBuilder.create(this.contextParamSet), null);
    }

    public static <C extends ItemShapelessContext, T extends LycheeRecipe<C>> void process(LycheeRecipeType<C, T> recipeType, Iterable<T> recipes, C ctx, Predicate<T> test) {
        boolean matched;
        boolean matchedAny = false;
        int loop = 0;
        HashSet excluded = Sets.newHashSet();
        block2: do {
            matched = false;
            for (LycheeRecipe recipe : recipes) {
                if (recipe.m_7527_().isEmpty() && loop > 0 || excluded.contains(recipe)) continue;
                try {
                    Optional<T> match = recipeType.tryMatch(recipe, ctx.getLevel(), ctx);
                    if (!match.isPresent()) continue;
                    if (test != null && !test.test(recipe)) {
                        excluded.add(recipe);
                        continue;
                    }
                    matched = true;
                    matchedAny = true;
                    int times = 1;
                    if (ctx.getMatch() != null && ctx.getMatch().inputUsed.length > 0) {
                        int[] inputUsed = ctx.getMatch().inputUsed;
                        times = recipe.getRandomRepeats(Integer.MAX_VALUE, ctx);
                        for (int i = 0; i < inputUsed.length; ++i) {
                            if (inputUsed[i] <= 0) continue;
                            ItemStack stack = ctx.filteredItems.get(i).m_32055_();
                            times = Math.min(times, stack.m_41613_() / inputUsed[i]);
                        }
                    }
                    ((LycheeRecipe)match.get()).applyPostActions(ctx, times);
                    if (ctx.getMatch() != null) {
                        ctx.totalItems -= ctx.itemHolders.postApply(ctx.runtime.doDefault, times);
                    }
                    if (recipe.getMaxRepeats().m_55327_()) {
                        ctx.filteredItems = null;
                        ctx.setMatch(null);
                        ctx.itemEntities.removeIf($ -> $.m_32055_().m_41619_());
                        continue;
                    }
                    break block2;
                }
                catch (Exception e) {
                    Lychee.LOGGER.error("", (Throwable)e);
                    break block2;
                }
            }
        } while (++loop < 100 && matched);
        if (matchedAny) {
            ctx.itemEntities.forEach($ -> $.m_32045_($.m_32055_()));
        }
    }
}

